/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.utils;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import androidx.core.content.ContextCompat;
import com.jiangdg.ausbc.R;
import com.serenegiant.usb.DeviceFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\f\u00a8\u0006\u000f"}, d2={"Lcom/jiangdg/ausbc/utils/CameraUtils;", "", "()V", "hasAudioPermission", "", "ctx", "Landroid/content/Context;", "hasCameraPermission", "hasStoragePermission", "isFilterDevice", "context", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "isUsbCamera", "device", "libausbc_release"})
public final class CameraUtils {
    @NotNull
    public static final CameraUtils INSTANCE = new CameraUtils();

    private CameraUtils() {
    }

    public final boolean isUsbCamera(@Nullable UsbDevice device) {
        int n;
        Integer n2;
        UsbDevice usbDevice = device;
        Integer n3 = n2 = usbDevice == null ? null : Integer.valueOf(usbDevice.getDeviceClass());
        int n4 = 14;
        if (n3 != null && n3 == n4) {
            n = 1;
        } else {
            Integer n5 = n2;
            n4 = 239;
            if (n5 != null && n5 == n4) {
                boolean isVideo = false;
                int n6 = 0;
                int n7 = device.getInterfaceCount();
                if (n6 < n7) {
                    do {
                        int i;
                        int cls;
                        if ((cls = device.getInterface(i = n6++).getInterfaceClass()) != 14) continue;
                        isVideo = true;
                        break;
                    } while (n6 < n7);
                }
                n = n4;
            } else {
                n = 0;
            }
        }
        return n != 0;
    }

    public final boolean isFilterDevice(@Nullable Context context, @Nullable UsbDevice usbDevice) {
        Object v0;
        boolean bl;
        Iterable iterable;
        block1: {
            iterable = DeviceFilter.getDeviceFilters((Context)context, (int)R.xml.default_device_filter);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getDeviceFilters(context, R.xml.default_device_filter)");
            iterable = iterable;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object e : iterable2) {
                DeviceFilter devFilter = (DeviceFilter)e;
                boolean bl3 = false;
                int n = devFilter.mProductId;
                UsbDevice usbDevice2 = usbDevice;
                if (!((usbDevice2 == null ? false : n == usbDevice2.getProductId()) && devFilter.mVendorId == usbDevice.getVendorId())) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        iterable = v0;
        bl = false;
        boolean bl4 = false;
        DeviceFilter dev = (DeviceFilter)iterable;
        boolean bl5 = false;
        return dev != null;
    }

    public final boolean hasAudioPermission(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int locPermission = ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.RECORD_AUDIO");
        return locPermission == 0;
    }

    public final boolean hasStoragePermission(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int locPermission = ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        return locPermission == 0;
    }

    public final boolean hasCameraPermission(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int locPermission = ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.CAMERA");
        return locPermission == 0;
    }
}

