/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.render.env;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.view.Surface;
import com.jiangdg.ausbc.utils.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\bJ\u0012\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bJ$\u0010\u001c\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\u0010R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jiangdg/ausbc/render/env/EGLEvn;", "", "()V", "configs", "", "Landroid/opengl/EGLConfig;", "[Landroid/opengl/EGLConfig;", "mEglContext", "Landroid/opengl/EGLContext;", "mEglDisplay", "Landroid/opengl/EGLDisplay;", "mEglSurface", "Landroid/opengl/EGLSurface;", "mSurface", "Landroid/view/Surface;", "eglMakeCurrent", "", "getEGLContext", "initEgl", "", "curContext", "loggerError", "msg", "", "releaseElg", "setPresentationTime", "nanoseconds", "", "setupSurface", "surface", "surfaceWidth", "", "surfaceHeight", "swapBuffers", "Companion", "libausbc_release"})
public final class EGLEvn {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private EGLDisplay mEglDisplay;
    @NotNull
    private EGLSurface mEglSurface;
    @NotNull
    private EGLContext mEglContext;
    @Nullable
    private Surface mSurface;
    @NotNull
    private final EGLConfig[] configs;
    @NotNull
    private static final String TAG = "EGLEvn";
    private static final int EGL_RECORDABLE_ANDROID = 12610;

    public EGLEvn() {
        EGLDisplay eGLDisplay = EGL14.EGL_NO_DISPLAY;
        Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"EGL_NO_DISPLAY");
        this.mEglDisplay = eGLDisplay;
        eGLDisplay = EGL14.EGL_NO_SURFACE;
        Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"EGL_NO_SURFACE");
        this.mEglSurface = eGLDisplay;
        eGLDisplay = EGL14.EGL_NO_CONTEXT;
        Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"EGL_NO_CONTEXT");
        this.mEglContext = eGLDisplay;
        this.configs = new EGLConfig[1];
    }

    public final boolean initEgl(@Nullable EGLContext curContext) {
        EGLDisplay eGLDisplay = EGL14.eglGetDisplay((int)0);
        Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"eglGetDisplay(EGL14.EGL_DEFAULT_DISPLAY)");
        this.mEglDisplay = eGLDisplay;
        if (Intrinsics.areEqual((Object)this.mEglDisplay, (Object)EGL14.EGL_NO_DISPLAY)) {
            this.loggerError("Get display");
            return false;
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            this.loggerError("Init egl");
            return false;
        }
        int[] nArray = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12610, 1, 12344};
        int[] configAttribs = nArray;
        int[] numConfigs = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEglDisplay, (int[])configAttribs, (int)0, (EGLConfig[])this.configs, (int)0, (int)this.configs.length, (int[])numConfigs, (int)0)) {
            this.loggerError("Choose Config");
            return false;
        }
        Object object = new int[]{12440, 2, 12344};
        int[] ctxAttribs = object;
        EGLContext eGLContext = curContext;
        object = EGL14.eglCreateContext((EGLDisplay)this.mEglDisplay, (EGLConfig)this.configs[0], (EGLContext)(eGLContext == null ? EGL14.EGL_NO_CONTEXT : eGLContext), (int[])ctxAttribs, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"eglCreateContext(mEglDisplay, configs[0], curContext ?: EGL14.EGL_NO_CONTEXT , ctxAttribs, 0)");
        this.mEglContext = (EGLContext)object;
        if (Intrinsics.areEqual((Object)this.mEglContext, (Object)EGL14.EGL_NO_CONTEXT)) {
            this.loggerError("Create context");
            return false;
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)this.mEglContext)) {
            this.loggerError("Bind context and window");
            return false;
        }
        Logger.INSTANCE.i(TAG, "Init EGL Success!");
        return true;
    }

    public static /* synthetic */ boolean initEgl$default(EGLEvn eGLEvn, EGLContext eGLContext, int n, Object object) {
        if ((n & 1) != 0) {
            eGLContext = null;
        }
        return eGLEvn.initEgl(eGLContext);
    }

    public final void setupSurface(@Nullable Surface surface, int surfaceWidth, int surfaceHeight) {
        EGLSurface eGLSurface;
        if (Intrinsics.areEqual((Object)this.mEglDisplay, (Object)EGL14.EGL_NO_DISPLAY)) {
            return;
        }
        if (surface == null) {
            int[] nArray = new int[]{12375, surfaceWidth, 12374, surfaceHeight, 12344};
            int[] attributes = nArray;
            EGLSurface eGLSurface2 = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEglDisplay, (EGLConfig)this.configs[0], (int[])attributes, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)eGLSurface2, (String)"{\n            val attributes  = intArrayOf(\n                EGL14.EGL_WIDTH, surfaceWidth,\n                EGL14.EGL_HEIGHT, surfaceHeight,\n                EGL14.EGL_NONE\n            )\n            EGL14.eglCreatePbufferSurface(mEglDisplay, configs[0], attributes , 0)\n        }");
            eGLSurface = eGLSurface2;
        } else {
            int[] nArray = new int[]{12344};
            int[] attributes = nArray;
            EGLSurface eGLSurface3 = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEglDisplay, (EGLConfig)this.configs[0], (Object)surface, (int[])attributes, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)eGLSurface3, (String)"{\n            val attributes  = intArrayOf(\n                EGL14.EGL_NONE\n            )\n            EGL14.eglCreateWindowSurface(mEglDisplay, configs[0], surface, attributes , 0)\n        }");
            eGLSurface = this.mEglSurface = eGLSurface3;
        }
        if (Intrinsics.areEqual((Object)this.mEglSurface, (Object)EGL14.EGL_NO_SURFACE)) {
            this.loggerError("Create window");
        }
        this.mSurface = surface;
        Logger.INSTANCE.i(TAG, "setupSurface Success!");
    }

    public static /* synthetic */ void setupSurface$default(EGLEvn eGLEvn, Surface surface, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        eGLEvn.setupSurface(surface, n, n2);
    }

    public final void eglMakeCurrent() {
        if (Intrinsics.areEqual((Object)this.mEglContext, (Object)EGL14.EGL_NO_CONTEXT)) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.mEglSurface, (Object)EGL14.EGL_NO_SURFACE)) {
            return;
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface, (EGLSurface)this.mEglSurface, (EGLContext)this.mEglContext)) {
            this.loggerError("Bind context and window");
        }
    }

    public final void setPresentationTime(long nanoseconds) {
        if (Intrinsics.areEqual((Object)this.mEglContext, (Object)EGL14.EGL_NO_CONTEXT)) {
            return;
        }
        if (this.mSurface == null) {
            return;
        }
        if (!EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface, (long)nanoseconds)) {
            this.loggerError("Set Presentation time");
        }
    }

    public final void swapBuffers() {
        if (Intrinsics.areEqual((Object)this.mEglContext, (Object)EGL14.EGL_NO_CONTEXT)) {
            return;
        }
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface)) {
            this.loggerError("Swap buffers");
        }
    }

    public final void releaseElg() {
        Surface surface;
        if (!Intrinsics.areEqual((Object)this.mEglDisplay, (Object)EGL14.EGL_NO_DISPLAY)) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface);
            EGL14.eglDestroyContext((EGLDisplay)this.mEglDisplay, (EGLContext)this.mEglContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.mEglDisplay);
        }
        if ((surface = this.mSurface) != null) {
            surface.release();
        }
        surface = EGL14.EGL_NO_DISPLAY;
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"EGL_NO_DISPLAY");
        this.mEglDisplay = surface;
        surface = EGL14.EGL_NO_SURFACE;
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"EGL_NO_SURFACE");
        this.mEglSurface = surface;
        surface = EGL14.EGL_NO_CONTEXT;
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"EGL_NO_CONTEXT");
        this.mEglContext = surface;
        this.mSurface = null;
        Logger.INSTANCE.i(TAG, "Release EGL Success!");
    }

    private final void loggerError(String msg) {
        Logger.INSTANCE.e(TAG, msg + " failed. error = " + EGL14.eglGetError());
    }

    @NotNull
    public final EGLContext getEGLContext() {
        EGLContext eGLContext = EGL14.eglGetCurrentContext();
        Intrinsics.checkNotNullExpressionValue((Object)eGLContext, (String)"eglGetCurrentContext()");
        return eGLContext;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jiangdg/ausbc/render/env/EGLEvn$Companion;", "", "()V", "EGL_RECORDABLE_ANDROID", "", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

