/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.widget;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.View;
import com.jiangdg.ausbc.R;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.MediaUtils;
import com.jiangdg.ausbc.widget.IAspectRatio;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 J2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002JKB\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010!\u001a\u00020\u000eH\u0002J\b\u0010\"\u001a\u00020\u000eH\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\b\u0010&\u001a\u00020\u0013H\u0002J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000eH\u0016J\b\u0010*\u001a\u00020\u000eH\u0016J\b\u0010+\u001a\u00020$H\u0002J\b\u0010,\u001a\u00020$H\u0002J\b\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020$H\u0014J\u0012\u00104\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0012\u00107\u001a\u00020$2\b\u00108\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000eH\u0014J\"\u0010<\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\u000eH\u0016J\u001c\u0010?\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u0001062\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\u0016\u0010B\u001a\u00020$2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020$0DH\u0016J\u0010\u0010E\u001a\u00020$2\u0006\u0010F\u001a\u00020\fH\u0002J\u0018\u0010E\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\u000eH\u0016J\u0016\u0010G\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\u000eJ\u0010\u0010H\u001a\u00020$2\b\u0010I\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/jiangdg/ausbc/widget/AspectRatioGLSurfaceView;", "Landroid/opengl/GLSurfaceView;", "Landroid/opengl/GLSurfaceView$Renderer;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "Lcom/jiangdg/ausbc/widget/IAspectRatio;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "mAspectRatio", "", "mESOTextureId", "", "mFragmentShader", "mListener", "Lcom/jiangdg/ausbc/widget/AspectRatioGLSurfaceView$OnSurfaceLifecycleListener;", "mMVPMatrix", "", "mMVPMatrixHandle", "mPositionLocation", "mProgram", "mStMatrix", "mStMatrixHandle", "mSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "mTextureCoordLocation", "mUIHandler", "Landroid/os/Handler;", "mVertexBuffer", "Ljava/nio/FloatBuffer;", "mVertexShader", "createExternalTexture", "createProgram", "deInitGLESEngine", "", "deInitSurface", "getMVPMatrix", "getSurface", "Landroid/view/Surface;", "getSurfaceHeight", "getSurfaceWidth", "initGLESEngine", "initSurface", "isGLESStatusError", "", "loadShader", "shaderType", "source", "", "onDetachedFromWindow", "onDrawFrame", "gl", "Ljavax/microedition/khronos/opengles/GL10;", "onFrameAvailable", "surfaceTexture", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSurfaceChanged", "width", "height", "onSurfaceCreated", "config", "Ljavax/microedition/khronos/egl/EGLConfig;", "postUITask", "task", "Lkotlin/Function0;", "setAspectRatio", "aspectRatio", "setDefaultBufferSize", "setOnSurfaceLifecycleListener", "listener", "Companion", "OnSurfaceLifecycleListener", "libausbc_release"})
public final class AspectRatioGLSurfaceView
extends GLSurfaceView
implements GLSurfaceView.Renderer,
SurfaceTexture.OnFrameAvailableListener,
IAspectRatio {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double mAspectRatio;
    @Nullable
    private SurfaceTexture mSurfaceTexture;
    @Nullable
    private FloatBuffer mVertexBuffer;
    @Nullable
    private OnSurfaceLifecycleListener mListener;
    private int mVertexShader;
    private int mFragmentShader;
    private int mProgram;
    private int mESOTextureId;
    @NotNull
    private final float[] mStMatrix;
    @NotNull
    private final float[] mMVPMatrix;
    @NotNull
    private final Handler mUIHandler;
    private int mPositionLocation;
    private int mTextureCoordLocation;
    private int mStMatrixHandle;
    private int mMVPMatrixHandle;
    @NotNull
    private static final String TAG = "AspectRatioGLSurfaceView";
    @NotNull
    private static final float[] VERTEX_DATA;

    public AspectRatioGLSurfaceView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public AspectRatioGLSurfaceView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        FloatBuffer floatBuffer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet);
        this.mAspectRatio = -1.0;
        this.mStMatrix = new float[16];
        this.mMVPMatrix = new float[16];
        this.mUIHandler = new Handler(Looper.getMainLooper());
        this.setEGLContextClientVersion(2);
        this.setRenderer(this);
        this.setRenderMode(0);
        FloatBuffer floatBuffer2 = this.mVertexBuffer = ByteBuffer.allocateDirect(VERTEX_DATA.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        if (floatBuffer2 != null && (floatBuffer = floatBuffer2.put(VERTEX_DATA)) != null) {
            floatBuffer.position(0);
        }
        Matrix.setIdentityM((float[])this.mStMatrix, (int)0);
    }

    public final void setOnSurfaceLifecycleListener(@Nullable OnSurfaceLifecycleListener listener2) {
        this.mListener = listener2;
    }

    private final void initSurface() {
        this.mESOTextureId = this.createExternalTexture();
        SurfaceTexture surfaceTexture = this.mSurfaceTexture = new SurfaceTexture(this.mESOTextureId);
        Intrinsics.checkNotNull((Object)surfaceTexture);
        surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
    }

    private final void initGLESEngine() {
        this.mProgram = this.createProgram();
        if (this.mProgram == 0) {
            this.deInitSurface();
            return;
        }
        this.mPositionLocation = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aPosition");
        this.mTextureCoordLocation = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTextureCoordinate");
        this.mStMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uStMatrix");
        this.mMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uMVPMatrix");
        if (this.isGLESStatusError()) {
            this.deInitSurface();
            Logger.INSTANCE.e(TAG, "create external texture failed");
            return;
        }
        Logger.INSTANCE.i(TAG, "init opengl es success. ");
    }

    public void onSurfaceCreated(@Nullable GL10 gl, @Nullable EGLConfig config) {
        Logger.INSTANCE.i(TAG, "onSurfaceCreated");
        this.initSurface();
        this.initGLESEngine();
        this.mUIHandler.post(() -> AspectRatioGLSurfaceView.onSurfaceCreated$lambda-0(this));
    }

    public void onSurfaceChanged(@Nullable GL10 gl, int width, int height) {
        Logger.INSTANCE.i(TAG, "onSurfaceChanged, width=" + width + " ,height=" + height);
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
    }

    public void onDrawFrame(@Nullable GL10 gl) {
        if (this.mSurfaceTexture != null) {
            SurfaceTexture surfaceTexture = this.mSurfaceTexture;
            Intrinsics.checkNotNull((Object)surfaceTexture);
            surfaceTexture.updateTexImage();
            SurfaceTexture surfaceTexture2 = this.mSurfaceTexture;
            Intrinsics.checkNotNull((Object)surfaceTexture2);
            surfaceTexture2.getTransformMatrix(this.mStMatrix);
        }
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16640);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.mESOTextureId);
        FloatBuffer floatBuffer = this.mVertexBuffer;
        Intrinsics.checkNotNull((Object)floatBuffer);
        floatBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mPositionLocation, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.mVertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mPositionLocation);
        FloatBuffer floatBuffer2 = this.mVertexBuffer;
        Intrinsics.checkNotNull((Object)floatBuffer2);
        floatBuffer2.position(3);
        GLES20.glVertexAttribPointer((int)this.mTextureCoordLocation, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.mVertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mTextureCoordLocation);
        GLES20.glUniformMatrix4fv((int)this.mMVPMatrixHandle, (int)1, (boolean)false, (float[])this.getMVPMatrix(), (int)0);
        GLES20.glUniformMatrix4fv((int)this.mStMatrixHandle, (int)1, (boolean)false, (float[])this.mStMatrix, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)36197, (int)0);
        Logger.INSTANCE.i(TAG, "--------draw a frame---------");
    }

    private final float[] getMVPMatrix() {
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
        float radius = 0.0f;
        float[] fArray = this.mMVPMatrix;
        double d = radius;
        boolean bl = false;
        fArray[0] = fArray[0] * (float)Math.cos(d);
        fArray = this.mMVPMatrix;
        d = radius;
        bl = false;
        fArray[1] = fArray[1] + (float)(-Math.sin(d));
        fArray = this.mMVPMatrix;
        d = radius;
        bl = false;
        fArray[4] = fArray[4] + (float)Math.sin(d);
        fArray = this.mMVPMatrix;
        d = radius;
        bl = false;
        fArray[5] = fArray[5] * (float)Math.cos(d);
        return this.mMVPMatrix;
    }

    public void onFrameAvailable(@Nullable SurfaceTexture surfaceTexture) {
        this.requestRender();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.deInitSurface();
        this.deInitGLESEngine();
        this.mUIHandler.post(() -> AspectRatioGLSurfaceView.onDetachedFromWindow$lambda-1(this));
    }

    private final int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Logger.INSTANCE.e(TAG, "Could not compile shader " + shaderType + ':');
            GLES20.glDeleteShader((int)shader);
            return 0;
        }
        return shader;
    }

    private final int createProgram() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.mVertexShader = this.loadShader(35633, MediaUtils.INSTANCE.readRawTextFile(context, R.raw.camera_vertex));
        if (this.mVertexShader == 0) {
            return 0;
        }
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"load vertex shader success, id = ", (Object)this.mVertexShader));
        context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.mFragmentShader = this.loadShader(35632, MediaUtils.INSTANCE.readRawTextFile(context, R.raw.camera_fragment));
        if (this.mFragmentShader == 0) {
            return 0;
        }
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"load fragment shader success, id = ", (Object)this.mFragmentShader));
        int program = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)program, (int)this.mVertexShader);
        GLES20.glAttachShader((int)program, (int)this.mFragmentShader);
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"Could not link program, err = ", (Object)linkStatus[0]));
            return 0;
        }
        GLES20.glUseProgram((int)program);
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"create and link program success, id = ", (Object)program));
        return program;
    }

    private final void deInitSurface() {
        if (this.mSurfaceTexture != null) {
            SurfaceTexture surfaceTexture = this.mSurfaceTexture;
            Intrinsics.checkNotNull((Object)surfaceTexture);
            surfaceTexture.setOnFrameAvailableListener(null);
            SurfaceTexture surfaceTexture2 = this.mSurfaceTexture;
            Intrinsics.checkNotNull((Object)surfaceTexture2);
            surfaceTexture2.release();
            this.mSurfaceTexture = null;
        }
    }

    private final void deInitGLESEngine() {
        if (this.mVertexShader != 0) {
            GLES20.glDeleteShader((int)this.mVertexShader);
            this.mVertexShader = 0;
        }
        if (this.mFragmentShader != 0) {
            GLES20.glDeleteShader((int)this.mFragmentShader);
            this.mFragmentShader = 0;
        }
        if (this.mProgram != 0) {
            GLES20.glDeleteProgram((int)this.mProgram);
            this.mProgram = 0;
        }
        Logger.INSTANCE.i(TAG, "release opengl es success");
    }

    private final boolean isGLESStatusError() {
        return GLES20.glGetError() != 0;
    }

    private final int createExternalTexture() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)36197, (int)textures[0]);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"create external texture success, texture id = ", (Object)textures[0]));
        return textures[0];
    }

    public final void setDefaultBufferSize(int width, int height) {
        SurfaceTexture surfaceTexture = this.mSurfaceTexture;
        if (surfaceTexture != null) {
            surfaceTexture.setDefaultBufferSize(width, height);
        }
    }

    @Override
    public void setAspectRatio(int width, int height) {
        int orientation = this.getContext().getResources().getConfiguration().orientation;
        if (orientation == 2) {
            this.setAspectRatio((double)height / (double)width);
            return;
        }
        this.setAspectRatio((double)width / (double)height);
    }

    @Override
    public int getSurfaceWidth() {
        return this.getWidth();
    }

    @Override
    public int getSurfaceHeight() {
        return this.getHeight();
    }

    @Override
    @NotNull
    public Surface getSurface() {
        Surface surface = this.getHolder().getSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"holder.surface");
        return surface;
    }

    @Override
    public void postUITask(@NotNull Function0<Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        this.post(() -> AspectRatioGLSurfaceView.postUITask$lambda-2(task));
    }

    private final void setAspectRatio(double aspectRatio) {
        if (aspectRatio < 0.0 || this.mAspectRatio == aspectRatio) {
            return;
        }
        this.mAspectRatio = aspectRatio;
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"AspectRatio = ", (Object)this.mAspectRatio));
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int initialWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int initialHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int horizontalPadding = this.getPaddingLeft() - this.getPaddingRight();
        int verticalPadding = this.getPaddingTop() - this.getPaddingBottom();
        double viewAspectRatio = (double)(initialWidth -= horizontalPadding) / (double)(initialHeight -= verticalPadding);
        double diff = this.mAspectRatio / viewAspectRatio - 1.0;
        int wMeasureSpec = widthMeasureSpec;
        int hMeasureSpec = heightMeasureSpec;
        if (this.mAspectRatio > 0.0) {
            boolean bl = false;
            if (Math.abs(diff) > 0.01) {
                if (diff > 0.0) {
                    initialHeight = (int)((double)initialWidth / this.mAspectRatio);
                } else {
                    initialWidth = (int)((double)initialHeight * this.mAspectRatio);
                }
                wMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialWidth += horizontalPadding), (int)0x40000000);
                hMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialHeight += verticalPadding), (int)0x40000000);
            }
        }
        super.onMeasure(wMeasureSpec, hMeasureSpec);
    }

    private static final void onSurfaceCreated$lambda-0(AspectRatioGLSurfaceView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.mListener != null) {
            OnSurfaceLifecycleListener onSurfaceLifecycleListener = this$0.mListener;
            Intrinsics.checkNotNull((Object)onSurfaceLifecycleListener);
            onSurfaceLifecycleListener.onSurfaceCreated(this$0.mSurfaceTexture);
        }
    }

    private static final void onDetachedFromWindow$lambda-1(AspectRatioGLSurfaceView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.mListener != null) {
            OnSurfaceLifecycleListener onSurfaceLifecycleListener = this$0.mListener;
            Intrinsics.checkNotNull((Object)onSurfaceLifecycleListener);
            onSurfaceLifecycleListener.onSurfaceDestroyed();
        }
    }

    private static final void postUITask$lambda-2(Function0 $task) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        $task.invoke();
    }

    static {
        float[] fArray = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        VERTEX_DATA = fArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/jiangdg/ausbc/widget/AspectRatioGLSurfaceView$OnSurfaceLifecycleListener;", "", "onSurfaceCreated", "", "surface", "Landroid/graphics/SurfaceTexture;", "onSurfaceDestroyed", "libausbc_release"})
    public static interface OnSurfaceLifecycleListener {
        public void onSurfaceCreated(@Nullable SurfaceTexture var1);

        public void onSurfaceDestroyed();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jiangdg/ausbc/widget/AspectRatioGLSurfaceView$Companion;", "", "()V", "TAG", "", "VERTEX_DATA", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

