/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.camera;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.OrientationEventListener;
import android.view.SurfaceHolder;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.camera.ICameraStrategy;
import com.jiangdg.ausbc.camera.bean.CameraInfo;
import com.jiangdg.ausbc.camera.bean.CameraRequest;
import com.jiangdg.ausbc.camera.bean.CameraStatus;
import com.jiangdg.ausbc.camera.bean.PreviewSize;
import com.jiangdg.ausbc.utils.bus.EventBus;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00af\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0017*\u0001#\b&\u0018\u0000 u2\u00020\u0001:\u0001uB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010B\u001a\u00020C2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010D\u001a\u00020C2\u0006\u0010E\u001a\u000203J\u0018\u0010F\u001a\u00020C2\u0006\u0010E\u001a\u00020\u00172\b\u0010G\u001a\u0004\u0018\u00010\u0006J\u0012\u0010H\u001a\u00020C2\b\u0010G\u001a\u0004\u0018\u00010\u0006H$J!\u0010I\u001a\n\u0012\u0004\u0012\u00020K\u0018\u00010J2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010MH&\u00a2\u0006\u0002\u0010NJ\n\u0010O\u001a\u0004\u0018\u00010\fH\u0004J\n\u0010P\u001a\u0004\u0018\u00010\u0003H\u0004J\b\u0010Q\u001a\u00020\u000fH\u0004J\n\u0010R\u001a\u0004\u0018\u00010\u0015H\u0004J\b\u0010S\u001a\u0004\u0018\u00010=J\b\u0010T\u001a\u0004\u0018\u00010?J\u0010\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XH\u0016J\b\u0010Y\u001a\u00020VH\u0004J\b\u0010Z\u001a\u00020VH\u0004J\u0006\u0010[\u001a\u00020VJ\b\u0010\\\u001a\u00020CH$J\u0010\u0010]\u001a\u00020C2\u0006\u0010^\u001a\u00020_H\u0004J\b\u0010`\u001a\u00020CH\u0016J\u000e\u0010a\u001a\u00020C2\u0006\u0010E\u001a\u000203J\u0010\u0010b\u001a\u00020C2\u0006\u0010c\u001a\u00020=H\u0002J\u0010\u0010d\u001a\u00020C2\u0006\u0010e\u001a\u00020?H\u0002J%\u0010f\u001a\u00020C\"\u0004\b\u0000\u0010g2\b\u0010h\u001a\u0004\u0018\u00010\u00152\b\u0010i\u001a\u0004\u0018\u0001Hg\u00a2\u0006\u0002\u0010jJ\b\u0010k\u001a\u00020CH$J\u0006\u0010l\u001a\u00020CJ\b\u0010m\u001a\u00020CH$J\u0012\u0010n\u001a\u00020C2\n\b\u0002\u0010o\u001a\u0004\u0018\u00010\u0006J\u0012\u0010p\u001a\u00020C2\b\u0010o\u001a\u0004\u0018\u00010\u0006H$J\b\u0010q\u001a\u00020CH\u0016J\u0018\u0010r\u001a\u00020C2\u0006\u0010s\u001a\u00020\u000f2\u0006\u0010t\u001a\u00020\u000fH$R\u001b\u0010\u0005\u001a\u00020\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001d\u001a\u00020\u001e8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\n\u001a\u0004\b\u001f\u0010 R\u0010\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$R\u001a\u0010%\u001a\u00020&X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020&X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R\u0014\u0010.\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R \u00101\u001a\b\u0012\u0004\u0012\u00020302X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0014\u00108\u001a\u000209X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0010\u0010<\u001a\u0004\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u0004\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "Landroid/os/Handler$Callback;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mCameraDir", "", "getMCameraDir", "()Ljava/lang/String;", "mCameraDir$delegate", "Lkotlin/Lazy;", "mCameraHandler", "Landroid/os/Handler;", "mCameraInfoMap", "Ljava/util/HashMap;", "", "Lcom/jiangdg/ausbc/camera/bean/CameraInfo;", "Lkotlin/collections/HashMap;", "getMCameraInfoMap", "()Ljava/util/HashMap;", "mCameraRequest", "Lcom/jiangdg/ausbc/camera/bean/CameraRequest;", "mCaptureDataCb", "Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "getMCaptureDataCb", "()Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "setMCaptureDataCb", "(Lcom/jiangdg/ausbc/callback/ICaptureCallBack;)V", "mContext", "mDateFormat", "Ljava/text/SimpleDateFormat;", "getMDateFormat", "()Ljava/text/SimpleDateFormat;", "mDateFormat$delegate", "mDeviceOrientation", "com/jiangdg/ausbc/camera/ICameraStrategy$mDeviceOrientation$1", "Lcom/jiangdg/ausbc/camera/ICameraStrategy$mDeviceOrientation$1;", "mIsCapturing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMIsCapturing", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "setMIsCapturing", "(Ljava/util/concurrent/atomic/AtomicBoolean;)V", "mIsPreviewing", "getMIsPreviewing", "setMIsPreviewing", "mMainHandler", "getMMainHandler", "()Landroid/os/Handler;", "mPreviewDataCbList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/jiangdg/ausbc/callback/IPreviewDataCallBack;", "getMPreviewDataCbList", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "setMPreviewDataCbList", "(Ljava/util/concurrent/CopyOnWriteArrayList;)V", "mSaveImageExecutor", "Ljava/util/concurrent/ExecutorService;", "getMSaveImageExecutor", "()Ljava/util/concurrent/ExecutorService;", "mSurfaceHolder", "Landroid/view/SurfaceHolder;", "mSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "mThread", "Landroid/os/HandlerThread;", "addLifecycleObserver", "", "addPreviewDataCallBack", "callBack", "captureImage", "savePath", "captureImageInternal", "getAllPreviewSizes", "", "Lcom/jiangdg/ausbc/camera/bean/PreviewSize;", "aspectRatio", "", "(Ljava/lang/Double;)Ljava/util/List;", "getCameraHandler", "getContext", "getDeviceOrientation", "getRequest", "getSurfaceHolder", "getSurfaceTexture", "handleMessage", "", "msg", "Landroid/os/Message;", "hasCameraPermission", "hasStoragePermission", "isCameraOpened", "loadCameraInfo", "postCameraStatus", "status", "Lcom/jiangdg/ausbc/camera/bean/CameraStatus;", "register", "removePreviewDataCallBack", "setSurfaceHolder", "holder", "setSurfaceTexture", "surfaceTexture", "startPreview", "T", "request", "renderSurface", "(Lcom/jiangdg/ausbc/camera/bean/CameraRequest;Ljava/lang/Object;)V", "startPreviewInternal", "stopPreview", "stopPreviewInternal", "switchCamera", "cameraId", "switchCameraInternal", "unRegister", "updateResolutionInternal", "width", "height", "Companion", "libausbc_release"})
public abstract class ICameraStrategy
implements Handler.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private HandlerThread mThread;
    @Nullable
    private Handler mCameraHandler;
    @Nullable
    private SurfaceTexture mSurfaceTexture;
    @Nullable
    private SurfaceHolder mSurfaceHolder;
    @Nullable
    private CameraRequest mCameraRequest;
    @Nullable
    private Context mContext;
    @NotNull
    private CopyOnWriteArrayList<IPreviewDataCallBack> mPreviewDataCbList;
    @Nullable
    private ICaptureCallBack mCaptureDataCb;
    @NotNull
    private final Handler mMainHandler;
    @NotNull
    private final ExecutorService mSaveImageExecutor;
    @NotNull
    private final HashMap<Integer, CameraInfo> mCameraInfoMap;
    @NotNull
    private AtomicBoolean mIsCapturing;
    @NotNull
    private AtomicBoolean mIsPreviewing;
    @NotNull
    private final Lazy mDateFormat$delegate;
    @NotNull
    private final Lazy mCameraDir$delegate;
    @NotNull
    private final mDeviceOrientation.1 mDeviceOrientation;
    @NotNull
    private static final String TAG = "ICameraStrategy";
    @NotNull
    private static final String THREAD_NAME = "camera_manager";
    private static final int MSG_INIT = 0;
    private static final int MSG_START_PREVIEW = 1;
    private static final int MSG_STOP_PREVIEW = 2;
    private static final int MSG_CAPTURE_IMAGE = 3;
    private static final int MSG_SWITCH_CAMERA = 4;
    public static final int TYPE_FRONT = 0;
    public static final int TYPE_BACK = 1;
    public static final int TYPE_OTHER = 2;

    public ICameraStrategy(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mPreviewDataCbList = new CopyOnWriteArrayList();
        this.mMainHandler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.mSaveImageExecutor = executorService;
        boolean bl = false;
        this.mCameraInfoMap = new HashMap();
        this.mIsCapturing = new AtomicBoolean(false);
        this.mIsPreviewing = new AtomicBoolean(false);
        this.mDateFormat$delegate = LazyKt.lazy((Function0)mDateFormat.2.INSTANCE);
        this.mCameraDir$delegate = LazyKt.lazy((Function0)mCameraDir.2.INSTANCE);
        this.mDeviceOrientation = new OrientationEventListener(context){
            private int orientation;
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super($context);
            }

            public final int getOrientation() {
                return this.orientation;
            }

            public void onOrientationChanged(int orientation) {
                this.orientation = orientation;
            }
        };
        this.mContext = context.getApplicationContext();
        this.addLifecycleObserver(context);
    }

    @NotNull
    protected final CopyOnWriteArrayList<IPreviewDataCallBack> getMPreviewDataCbList() {
        return this.mPreviewDataCbList;
    }

    protected final void setMPreviewDataCbList(@NotNull CopyOnWriteArrayList<IPreviewDataCallBack> copyOnWriteArrayList) {
        Intrinsics.checkNotNullParameter(copyOnWriteArrayList, (String)"<set-?>");
        this.mPreviewDataCbList = copyOnWriteArrayList;
    }

    @Nullable
    protected final ICaptureCallBack getMCaptureDataCb() {
        return this.mCaptureDataCb;
    }

    protected final void setMCaptureDataCb(@Nullable ICaptureCallBack iCaptureCallBack) {
        this.mCaptureDataCb = iCaptureCallBack;
    }

    @NotNull
    protected final Handler getMMainHandler() {
        return this.mMainHandler;
    }

    @NotNull
    protected final ExecutorService getMSaveImageExecutor() {
        return this.mSaveImageExecutor;
    }

    @NotNull
    protected final HashMap<Integer, CameraInfo> getMCameraInfoMap() {
        return this.mCameraInfoMap;
    }

    @NotNull
    protected final AtomicBoolean getMIsCapturing() {
        return this.mIsCapturing;
    }

    protected final void setMIsCapturing(@NotNull AtomicBoolean atomicBoolean) {
        Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
        this.mIsCapturing = atomicBoolean;
    }

    @NotNull
    protected final AtomicBoolean getMIsPreviewing() {
        return this.mIsPreviewing;
    }

    protected final void setMIsPreviewing(@NotNull AtomicBoolean atomicBoolean) {
        Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
        this.mIsPreviewing = atomicBoolean;
    }

    @NotNull
    protected final SimpleDateFormat getMDateFormat() {
        Lazy lazy = this.mDateFormat$delegate;
        boolean bl = false;
        return (SimpleDateFormat)lazy.getValue();
    }

    @NotNull
    protected final String getMCameraDir() {
        Lazy lazy = this.mCameraDir$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    public boolean handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        int n = msg.what;
        switch (n) {
            case 0: {
                this.loadCameraInfo();
                break;
            }
            case 1: {
                Object object = msg.obj;
                if (object == null) {
                    return true;
                }
                object = msg.obj;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.jiangdg.ausbc.camera.bean.CameraRequest");
                }
                object = (CameraRequest)object;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$handleMessage_u24lambda_u2d0 = object;
                boolean bl3 = false;
                if (this.getMIsPreviewing().get()) {
                    this.mDeviceOrientation.disable();
                    this.stopPreviewInternal();
                }
                this.mDeviceOrientation.enable();
                this.mCameraRequest = $this$handleMessage_u24lambda_u2d0;
                this.startPreviewInternal();
                break;
            }
            case 2: {
                this.mCameraInfoMap.clear();
                this.mDeviceOrientation.disable();
                this.stopPreviewInternal();
                break;
            }
            case 3: {
                Object object = msg.obj;
                this.captureImageInternal(object instanceof String ? (String)object : null);
                break;
            }
            case 4: {
                Object object = msg.obj;
                this.switchCameraInternal(object instanceof String ? (String)object : null);
            }
        }
        return true;
    }

    public final synchronized <T> void startPreview(@Nullable CameraRequest request, @Nullable T renderSurface) {
        HandlerThread thread;
        CameraRequest cameraRequest;
        Message message;
        Object object;
        if (this.mIsPreviewing.get() || ((object = this.mThread) == null ? false : object.isAlive())) {
            this.stopPreview();
        }
        if (this.mCameraRequest == null && request == null) {
            throw new IllegalStateException("camera request can't be null");
        }
        if (this.mSurfaceHolder == null && this.mSurfaceTexture == null && renderSurface == null) {
            throw new IllegalStateException("render surface can't be null");
        }
        object = renderSurface;
        if (object instanceof SurfaceTexture) {
            this.setSurfaceTexture((SurfaceTexture)renderSurface);
        } else if (object instanceof SurfaceHolder) {
            this.setSurfaceHolder((SurfaceHolder)renderSurface);
        }
        object = Unit.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        HandlerThread handlerThread = new HandlerThread(THREAD_NAME);
        boolean bl4 = false;
        boolean bl5 = false;
        HandlerThread $this$startPreview_u24lambda_u2d3_u24lambda_u2d1 = handlerThread;
        boolean bl6 = false;
        $this$startPreview_u24lambda_u2d3_u24lambda_u2d1.start();
        bl4 = false;
        bl5 = false;
        HandlerThread it2 = handlerThread;
        boolean bl7 = false;
        Handler handler = this.mCameraHandler = new Handler(it2.getLooper(), (Handler.Callback)this);
        if (handler != null && (message = handler.obtainMessage(0)) != null) {
            message.sendToTarget();
        }
        if ((handler = this.mCameraHandler) != null && (message = handler.obtainMessage(1, (Object)((cameraRequest = request) == null ? this.mCameraRequest : cameraRequest))) != null) {
            message.sendToTarget();
        }
        this.mThread = thread = handlerThread;
    }

    public final synchronized void stopPreview() {
        Message message;
        HandlerThread handlerThread = this.mThread;
        if (handlerThread == null) {
            return;
        }
        handlerThread = this.mCameraHandler;
        if (handlerThread == null) {
            return;
        }
        handlerThread = this.mCameraHandler;
        if (handlerThread != null && (message = handlerThread.obtainMessage(2)) != null) {
            message.sendToTarget();
        }
        if ((handlerThread = this.mThread) != null) {
            handlerThread.quitSafely();
        }
        this.mThread = null;
        this.mCameraHandler = null;
    }

    public final synchronized void captureImage(@NotNull ICaptureCallBack callBack, @Nullable String savePath) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        this.mCaptureDataCb = callBack;
        Handler handler = this.mCameraHandler;
        if (handler != null && (message = handler.obtainMessage(3, (Object)savePath)) != null) {
            message.sendToTarget();
        }
    }

    public final synchronized void switchCamera(@Nullable String cameraId) {
        Message message;
        Handler handler = this.mCameraHandler;
        if (handler != null && (message = handler.obtainMessage(4, (Object)cameraId)) != null) {
            message.sendToTarget();
        }
    }

    public static /* synthetic */ void switchCamera$default(ICameraStrategy iCameraStrategy, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: switchCamera");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        iCameraStrategy.switchCamera(string);
    }

    private final void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        this.mSurfaceTexture = surfaceTexture;
    }

    private final void setSurfaceHolder(SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
    }

    @Nullable
    public abstract List<PreviewSize> getAllPreviewSizes(@Nullable Double var1);

    public static /* synthetic */ List getAllPreviewSizes$default(ICameraStrategy iCameraStrategy, Double d, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAllPreviewSizes");
        }
        if ((n & 1) != 0) {
            d = null;
        }
        return iCameraStrategy.getAllPreviewSizes(d);
    }

    @Nullable
    public final SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    @Nullable
    public final SurfaceHolder getSurfaceHolder() {
        return this.mSurfaceHolder;
    }

    @Nullable
    protected final Context getContext() {
        return this.mContext;
    }

    @Nullable
    protected final CameraRequest getRequest() {
        return this.mCameraRequest;
    }

    @Nullable
    protected final Handler getCameraHandler() {
        return this.mCameraHandler;
    }

    protected final int getDeviceOrientation() {
        return this.mDeviceOrientation.getOrientation();
    }

    protected final void postCameraStatus(@NotNull CameraStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        EventBus.INSTANCE.with("camera-status").postMessage(status);
    }

    public void register() {
    }

    public void unRegister() {
    }

    protected abstract void loadCameraInfo();

    protected abstract void startPreviewInternal();

    protected abstract void stopPreviewInternal();

    protected abstract void captureImageInternal(@Nullable String var1);

    protected abstract void switchCameraInternal(@Nullable String var1);

    protected abstract void updateResolutionInternal(int var1, int var2);

    protected final boolean hasCameraPermission() {
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        Context context2 = this.getContext();
        Intrinsics.checkNotNull((Object)context2);
        int locPermission = ContextCompat.checkSelfPermission((Context)context2, (String)"android.permission.CAMERA");
        return locPermission == 0;
    }

    protected final boolean hasStoragePermission() {
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        Context context2 = this.getContext();
        Intrinsics.checkNotNull((Object)context2);
        int locPermission = ContextCompat.checkSelfPermission((Context)context2, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        return locPermission == 0;
    }

    private final void addLifecycleObserver(Context context) {
        if (!(context instanceof LifecycleOwner)) {
            return;
        }
        ((LifecycleOwner)context).getLifecycle().addObserver((LifecycleObserver)new LifecycleEventObserver(this){
            final /* synthetic */ ICameraStrategy this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStateChanged(@NotNull LifecycleOwner source, @NotNull Lifecycle.Event event) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Lifecycle.Event event2 = event;
                int n = addLifecycleObserver.WhenMappings.$EnumSwitchMapping$0[event2.ordinal()];
                switch (n) {
                    case 1: {
                        this.this$0.register();
                        break;
                    }
                    case 2: {
                        this.this$0.stopPreview();
                        this.this$0.unRegister();
                    }
                }
            }
        });
    }

    public final void addPreviewDataCallBack(@NotNull IPreviewDataCallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        if (this.mPreviewDataCbList.contains(callBack)) {
            return;
        }
        this.mPreviewDataCbList.add(callBack);
    }

    public final void removePreviewDataCallBack(@NotNull IPreviewDataCallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        if (!this.mPreviewDataCbList.contains(callBack)) {
            return;
        }
        this.mPreviewDataCbList.remove(callBack);
    }

    public final boolean isCameraOpened() {
        return this.mIsPreviewing.get();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jiangdg/ausbc/camera/ICameraStrategy$Companion;", "", "()V", "MSG_CAPTURE_IMAGE", "", "MSG_INIT", "MSG_START_PREVIEW", "MSG_STOP_PREVIEW", "MSG_SWITCH_CAMERA", "TAG", "", "THREAD_NAME", "TYPE_BACK", "TYPE_FRONT", "TYPE_OTHER", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

