/*
 * Decompiled with CFR 0.152.
 */
package org.easydarwin.sw;

import android.content.Context;
import android.content.res.AssetManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TxtOverlay {
    private static TxtOverlay instance;
    private final Context context;
    private long ctx;

    private TxtOverlay(Context context) {
        this.context = context;
    }

    public static TxtOverlay getInstance() {
        if (instance == null) {
            throw new IllegalArgumentException("please call install in your application!");
        }
        return instance;
    }

    public static void install(Context context) {
        if (instance == null) {
            instance = new TxtOverlay(context.getApplicationContext());
            File youyuan = context.getFileStreamPath("SIMYOU.ttf");
            if (!youyuan.exists()) {
                AssetManager am = context.getAssets();
                try {
                    InputStream is = am.open("zk/SIMYOU.ttf");
                    FileOutputStream os = context.openFileOutput("SIMYOU.ttf", 0);
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = is.read(buffer)) != -1) {
                        os.write(buffer, 0, len);
                    }
                    os.close();
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void init(int width, int height) {
        File youyuan = this.context.getFileStreamPath("SIMYOU.ttf");
        if (!youyuan.exists()) {
            throw new IllegalArgumentException("the font file must be exists,please call install before!");
        }
        this.ctx = TxtOverlay.txtOverlayInit(width, height, youyuan.getAbsolutePath());
    }

    public void overlay(byte[] data, String txt) {
        if (this.ctx == 0L) {
            return;
        }
        TxtOverlay.txtOverlay(this.ctx, data, txt);
    }

    public void release() {
        if (this.ctx == 0L) {
            return;
        }
        TxtOverlay.txtOverlayRelease(this.ctx);
        this.ctx = 0L;
    }

    private static native long txtOverlayInit(int var0, int var1, String var2);

    private static native void txtOverlay(long var0, byte[] var2, String var3);

    private static native void txtOverlayRelease(long var0);

    static {
        System.loadLibrary("TxtOverlay");
    }
}

