/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.encoder.biz;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Build;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Mp4MediaMuxer {
    private static final boolean VERBOSE = false;
    private static final String TAG = Mp4MediaMuxer.class.getSimpleName();
    private String mFilePath;
    private MediaMuxer mMuxer;
    private long durationMillis;
    private int index = 0;
    private int mVideoTrackIndex = -1;
    private int mAudioTrackIndex = -1;
    private long mBeginMillis;
    private MediaFormat mVideoFormat;
    private MediaFormat mAudioFormat;
    private boolean isVoiceClose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mp4MediaMuxer(String path, long durationMillis, boolean isVoiceClose) {
        this.isVoiceClose = isVoiceClose;
        this.durationMillis = durationMillis;
        String mFilePath = durationMillis != 0L ? path + "-" + this.index++ + ".mp4" : path + ".mp4";
        MediaMuxer mux = null;
        try {
            if (Build.VERSION.SDK_INT >= 18) {
                mux = new MediaMuxer(mFilePath, 0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.mMuxer = mux;
        }
    }

    public synchronized void addTrack(MediaFormat format, boolean isVideo) {
        if (!this.isVoiceClose && this.mAudioTrackIndex != -1 && this.mVideoTrackIndex != -1) {
            throw new RuntimeException("already add all tracks");
        }
        if (Build.VERSION.SDK_INT >= 18) {
            int track = this.mMuxer.addTrack(format);
            if (isVideo) {
                this.mVideoFormat = format;
                this.mVideoTrackIndex = track;
                if (this.isVoiceClose || this.mAudioTrackIndex != -1) {
                    this.mMuxer.start();
                    this.mBeginMillis = System.currentTimeMillis();
                }
            } else {
                this.mAudioFormat = format;
                this.mAudioTrackIndex = track;
                if (this.mVideoTrackIndex != -1) {
                    this.mMuxer.start();
                    this.mBeginMillis = System.currentTimeMillis();
                }
            }
        }
    }

    public synchronized void pumpStream(ByteBuffer outputBuffer, MediaCodec.BufferInfo bufferInfo, boolean isVideo) {
        if (!this.isVoiceClose && this.mAudioTrackIndex == -1 || this.mVideoTrackIndex == -1) {
            return;
        }
        if ((bufferInfo.flags & 2) == 0 && bufferInfo.size != 0) {
            if (isVideo && this.mVideoTrackIndex == -1) {
                throw new RuntimeException("muxer hasn't started");
            }
            outputBuffer.position(bufferInfo.offset);
            outputBuffer.limit(bufferInfo.offset + bufferInfo.size);
            if (Build.VERSION.SDK_INT >= 18) {
                this.mMuxer.writeSampleData(isVideo ? this.mVideoTrackIndex : this.mAudioTrackIndex, outputBuffer, bufferInfo);
            }
        }
        if ((bufferInfo.flags & 4) != 0) {
            // empty if block
        }
        if (this.durationMillis != 0L && System.currentTimeMillis() - this.mBeginMillis >= this.durationMillis && Build.VERSION.SDK_INT >= 18) {
            this.mMuxer.stop();
            this.mMuxer.release();
            this.mMuxer = null;
            this.mAudioTrackIndex = -1;
            this.mVideoTrackIndex = -1;
            try {
                this.mMuxer = new MediaMuxer(this.mFilePath + "-" + ++this.index + ".mp4", 0);
                this.addTrack(this.mVideoFormat, true);
                this.addTrack(this.mAudioFormat, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void release() {
        if (Build.VERSION.SDK_INT >= 18 && this.mMuxer != null && this.mVideoTrackIndex != -1) {
            try {
                this.mMuxer.stop();
                this.mMuxer.release();
            }
            catch (IllegalStateException ex) {
                ex.printStackTrace();
            }
            if (System.currentTimeMillis() - this.mBeginMillis <= 1500L) {
                new File(this.mFilePath + "-" + this.index + ".mp4").delete();
            }
            this.mVideoTrackIndex = -1;
            this.mAudioTrackIndex = -1;
        }
    }
}

