/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.encoder;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.serenegiant.usb.encoder.IVideoEncoder;
import com.serenegiant.usb.encoder.MediaEncoder;
import com.serenegiant.usb.encoder.MediaMuxerWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MediaVideoBufferEncoder
extends MediaEncoder
implements IVideoEncoder {
    private static final boolean DEBUG = true;
    private static final String TAG = "MediaVideoBufferEncoder";
    private static final String MIME_TYPE = "video/avc";
    private static final int FRAME_RATE = 15;
    private static final float BPP = 0.5f;
    private final int mWidth;
    private final int mHeight;
    protected int mColorFormat;
    protected static int[] recognizedFormats = new int[]{21, 2141391872};

    public MediaVideoBufferEncoder(MediaMuxerWrapper muxer, int width, int height, MediaEncoder.MediaEncoderListener listener) {
        super(muxer, listener);
        Log.i((String)TAG, (String)"MediaVideoEncoder: ");
        this.mWidth = width;
        this.mHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(ByteBuffer buffer) {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
        }
        this.encode(buffer, buffer.capacity());
    }

    @Override
    protected void prepare() throws IOException {
        Log.i((String)TAG, (String)"prepare: ");
        this.mTrackIndex = -1;
        this.mIsEOS = false;
        this.mMuxerStarted = false;
        MediaCodecInfo videoCodecInfo = this.selectVideoCodec(MIME_TYPE);
        if (videoCodecInfo == null) {
            Log.e((String)TAG, (String)"Unable to find an appropriate codec for video/avc");
            return;
        }
        Log.i((String)TAG, (String)("selected codec: " + videoCodecInfo.getName()));
        MediaFormat format = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)this.mWidth, (int)this.mHeight);
        format.setInteger("color-format", this.mColorFormat);
        format.setInteger("bitrate", this.calcBitRate());
        format.setInteger("frame-rate", 15);
        format.setInteger("i-frame-interval", 10);
        Log.i((String)TAG, (String)("format: " + format));
        this.mMediaCodec = MediaCodec.createEncoderByType((String)MIME_TYPE);
        this.mMediaCodec.configure(format, null, null, 1);
        this.mMediaCodec.start();
        Bundle params = new Bundle();
        params.putInt("request-sync", 0);
        if (Build.VERSION.SDK_INT >= 19) {
            this.mMediaCodec.setParameters(params);
        }
        Log.i((String)TAG, (String)"prepare finishing");
        if (this.mListener != null) {
            try {
                this.mListener.onPrepared(this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"prepare:", (Throwable)e);
            }
        }
    }

    private int calcBitRate() {
        int bitrate = (int)(7.5f * (float)this.mWidth * (float)this.mHeight);
        Log.i((String)TAG, (String)String.format("bitrate=%5.2f[Mbps]", Float.valueOf((float)bitrate / 1024.0f / 1024.0f)));
        return bitrate;
    }

    protected final MediaCodecInfo selectVideoCodec(String mimeType) {
        Log.v((String)TAG, (String)"selectVideoCodec:");
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(mimeType)) continue;
                Log.i((String)TAG, (String)("codec:" + codecInfo.getName() + ",MIME=" + types[j]));
                int format = MediaVideoBufferEncoder.selectColorFormat(codecInfo, mimeType);
                if (format <= 0) continue;
                this.mColorFormat = format;
                return codecInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final int selectColorFormat(MediaCodecInfo codecInfo, String mimeType) {
        MediaCodecInfo.CodecCapabilities caps;
        Log.i((String)TAG, (String)"selectColorFormat: ");
        int result = 0;
        try {
            Thread.currentThread().setPriority(10);
            caps = codecInfo.getCapabilitiesForType(mimeType);
        }
        finally {
            Thread.currentThread().setPriority(5);
        }
        for (int i = 0; i < caps.colorFormats.length; ++i) {
            int colorFormat = caps.colorFormats[i];
            if (!MediaVideoBufferEncoder.isRecognizedViewoFormat(colorFormat)) continue;
            if (result != 0) break;
            result = colorFormat;
            break;
        }
        if (result == 0) {
            Log.e((String)TAG, (String)("couldn't find a good color format for " + codecInfo.getName() + " / " + mimeType));
        }
        return result;
    }

    private static final boolean isRecognizedViewoFormat(int colorFormat) {
        Log.i((String)TAG, (String)("isRecognizedViewoFormat:colorFormat=" + colorFormat));
        int n = recognizedFormats != null ? recognizedFormats.length : 0;
        for (int i = 0; i < n; ++i) {
            if (recognizedFormats[i] != colorFormat) continue;
            return true;
        }
        return false;
    }
}

