/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.usbcamera;

import android.app.Activity;
import android.graphics.SurfaceTexture;
import android.hardware.usb.UsbDevice;
import android.os.Environment;
import com.jiangdg.libusbcamera.R;
import com.serenegiant.usb.DeviceFilter;
import com.serenegiant.usb.Size;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.common.AbstractUVCCameraHandler;
import com.serenegiant.usb.common.UVCCameraHandler;
import com.serenegiant.usb.encoder.RecordParams;
import com.serenegiant.usb.widget.CameraViewInterface;
import java.io.File;
import java.util.List;

public class UVCCameraHelper {
    public static final String ROOT_PATH = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator;
    public static final String SUFFIX_JPEG = ".jpg";
    public static final String SUFFIX_MP4 = ".mp4";
    private static final String TAG = "UVCCameraHelper";
    private int previewWidth = 640;
    private int previewHeight = 480;
    public static final int FRAME_FORMAT_YUYV = 0;
    public static final int FRAME_FORMAT_MJPEG = 1;
    public static final int MODE_BRIGHTNESS = -2147483647;
    public static final int MODE_CONTRAST = -2147483646;
    private int mFrameFormat = 1;
    private static UVCCameraHelper mCameraHelper;
    private USBMonitor mUSBMonitor;
    private UVCCameraHandler mCameraHandler;
    private USBMonitor.UsbControlBlock mCtrlBlock;
    private Activity mActivity;
    private CameraViewInterface mCamView;

    private UVCCameraHelper() {
    }

    public static UVCCameraHelper getInstance() {
        if (mCameraHelper == null) {
            mCameraHelper = new UVCCameraHelper();
        }
        return mCameraHelper;
    }

    public void closeCamera() {
        if (this.mCameraHandler != null) {
            this.mCameraHandler.close();
        }
    }

    public void initUSBMonitor(Activity activity, CameraViewInterface cameraView, final OnMyDevConnectListener listener) {
        this.mActivity = activity;
        this.mCamView = cameraView;
        this.mUSBMonitor = new USBMonitor(activity.getApplicationContext(), new USBMonitor.OnDeviceConnectListener(){

            @Override
            public void onAttach(UsbDevice device) {
                if (listener != null) {
                    listener.onAttachDev(device);
                }
            }

            @Override
            public void onDettach(UsbDevice device) {
                if (listener != null) {
                    listener.onDettachDev(device);
                }
            }

            @Override
            public void onConnect(UsbDevice device, USBMonitor.UsbControlBlock ctrlBlock, boolean createNew) {
                UVCCameraHelper.this.mCtrlBlock = ctrlBlock;
                UVCCameraHelper.this.openCamera(ctrlBlock);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        UVCCameraHelper.this.startPreview(UVCCameraHelper.this.mCamView);
                    }
                }).start();
                if (listener != null) {
                    listener.onConnectDev(device, true);
                }
            }

            @Override
            public void onDisconnect(UsbDevice device, USBMonitor.UsbControlBlock ctrlBlock) {
                if (listener != null) {
                    listener.onDisConnectDev(device);
                }
            }

            @Override
            public void onCancel(UsbDevice device) {
            }
        });
        this.createUVCCamera();
    }

    public void createUVCCamera() {
        if (this.mCamView == null) {
            throw new NullPointerException("CameraViewInterface cannot be null!");
        }
        if (this.mCameraHandler != null) {
            this.mCameraHandler.release();
            this.mCameraHandler = null;
        }
        this.mCamView.setAspectRatio((float)this.previewWidth / (float)this.previewHeight);
        this.mCameraHandler = UVCCameraHandler.createHandler(this.mActivity, this.mCamView, 2, this.previewWidth, this.previewHeight, this.mFrameFormat);
    }

    public void updateResolution(int width, int height) {
        if (this.previewWidth == width && this.previewHeight == height) {
            return;
        }
        this.previewWidth = width;
        this.previewHeight = height;
        if (this.mCameraHandler != null) {
            this.mCameraHandler.release();
            this.mCameraHandler = null;
        }
        this.mCamView.setAspectRatio((float)this.previewWidth / (float)this.previewHeight);
        this.mCameraHandler = UVCCameraHandler.createHandler(this.mActivity, this.mCamView, 2, this.previewWidth, this.previewHeight, this.mFrameFormat);
        this.openCamera(this.mCtrlBlock);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                UVCCameraHelper.this.startPreview(UVCCameraHelper.this.mCamView);
            }
        }).start();
    }

    public void registerUSB() {
        if (this.mUSBMonitor != null) {
            this.mUSBMonitor.register();
        }
    }

    public void unregisterUSB() {
        if (this.mUSBMonitor != null) {
            this.mUSBMonitor.unregister();
        }
    }

    public boolean checkSupportFlag(int flag) {
        return this.mCameraHandler != null && this.mCameraHandler.checkSupportFlag(flag);
    }

    public int getModelValue(int flag) {
        return this.mCameraHandler != null ? this.mCameraHandler.getValue(flag) : 0;
    }

    public int setModelValue(int flag, int value) {
        return this.mCameraHandler != null ? this.mCameraHandler.setValue(flag, value) : 0;
    }

    public int resetModelValue(int flag) {
        return this.mCameraHandler != null ? this.mCameraHandler.resetValue(flag) : 0;
    }

    public void requestPermission(int index) {
        List<UsbDevice> devList = this.getUsbDeviceList();
        if (devList == null || devList.size() == 0) {
            return;
        }
        int count = devList.size();
        if (index >= count) {
            new IllegalArgumentException("index illegal,should be < devList.size()");
        }
        if (this.mUSBMonitor != null) {
            this.mUSBMonitor.requestPermission(this.getUsbDeviceList().get(index));
        }
    }

    public int getUsbDeviceCount() {
        List<UsbDevice> devList = this.getUsbDeviceList();
        if (devList == null || devList.size() == 0) {
            return 0;
        }
        return devList.size();
    }

    public List<UsbDevice> getUsbDeviceList() {
        List<DeviceFilter> deviceFilters = DeviceFilter.getDeviceFilters(this.mActivity.getApplicationContext(), R.xml.device_filter);
        if (this.mUSBMonitor == null || deviceFilters == null) {
            return null;
        }
        return this.mUSBMonitor.getDeviceList(deviceFilters);
    }

    public void capturePicture(String savePath, AbstractUVCCameraHandler.OnCaptureListener listener) {
        if (this.mCameraHandler != null && this.mCameraHandler.isOpened()) {
            this.mCameraHandler.captureStill(savePath, listener);
        }
    }

    public void startPusher(AbstractUVCCameraHandler.OnEncodeResultListener listener) {
        if (this.mCameraHandler != null && !this.isPushing()) {
            this.mCameraHandler.startRecording(null, listener);
        }
    }

    public void startPusher(RecordParams params, AbstractUVCCameraHandler.OnEncodeResultListener listener) {
        if (this.mCameraHandler != null && !this.isPushing()) {
            this.mCameraHandler.startRecording(params, listener);
        }
    }

    public void stopPusher() {
        if (this.mCameraHandler != null && this.isPushing()) {
            this.mCameraHandler.stopRecording();
        }
    }

    public boolean isPushing() {
        if (this.mCameraHandler != null) {
            return this.mCameraHandler.isRecording();
        }
        return false;
    }

    public boolean isCameraOpened() {
        if (this.mCameraHandler != null) {
            return this.mCameraHandler.isOpened();
        }
        return false;
    }

    public void release() {
        if (this.mCameraHandler != null) {
            this.mCameraHandler.release();
            this.mCameraHandler = null;
        }
        if (this.mUSBMonitor != null) {
            this.mUSBMonitor.destroy();
            this.mUSBMonitor = null;
        }
    }

    public USBMonitor getUSBMonitor() {
        return this.mUSBMonitor;
    }

    public void setOnPreviewFrameListener(AbstractUVCCameraHandler.OnPreViewResultListener listener) {
        if (this.mCameraHandler != null) {
            this.mCameraHandler.setOnPreViewResultListener(listener);
        }
    }

    private void openCamera(USBMonitor.UsbControlBlock ctrlBlock) {
        if (this.mCameraHandler != null) {
            this.mCameraHandler.open(ctrlBlock);
        }
    }

    public void startPreview(CameraViewInterface cameraView) {
        SurfaceTexture st = cameraView.getSurfaceTexture();
        if (this.mCameraHandler != null) {
            this.mCameraHandler.startPreview(st);
        }
    }

    public void stopPreview() {
        if (this.mCameraHandler != null) {
            this.mCameraHandler.stopPreview();
        }
    }

    public void startCameraFoucs() {
        if (this.mCameraHandler != null) {
            this.mCameraHandler.startCameraFoucs();
        }
    }

    public List<Size> getSupportedPreviewSizes() {
        if (this.mCameraHandler == null) {
            return null;
        }
        return this.mCameraHandler.getSupportedPreviewSizes();
    }

    public void setDefaultPreviewSize(int defaultWidth, int defaultHeight) {
        if (this.mUSBMonitor != null) {
            throw new IllegalStateException("setDefaultPreviewSize should be call before initMonitor");
        }
        this.previewWidth = defaultWidth;
        this.previewHeight = defaultHeight;
    }

    public void setDefaultFrameFormat(int format) {
        if (this.mUSBMonitor != null) {
            throw new IllegalStateException("setDefaultFrameFormat should be call before initMonitor");
        }
        this.mFrameFormat = format;
    }

    public int getPreviewWidth() {
        return this.previewWidth;
    }

    public int getPreviewHeight() {
        return this.previewHeight;
    }

    public static interface OnMyDevConnectListener {
        public void onAttachDev(UsbDevice var1);

        public void onDettachDev(UsbDevice var1);

        public void onConnectDev(UsbDevice var1, boolean var2);

        public void onDisConnectDev(UsbDevice var1);
    }
}

