/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.ref.PositionUtil;
import com.github.jferard.fastods.util.AutoFilterBuilder;
import com.github.jferard.fastods.util.Filter;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class AutoFilter
implements XMLConvertible {
    private final String rangeName;
    private final String rangeAddress;
    private final boolean displayButtons;
    private final Filter filter;

    public static AutoFilterBuilder builder(String rangeName, Table table, int r1, int c1, int r2, int c2) {
        String rangeAddress = PositionUtil.create().toRangeAddress(table, r1, c1, r2, c2);
        return new AutoFilterBuilder(rangeName, rangeAddress);
    }

    public AutoFilter(String rangeName, String rangeAddress, boolean displayButtons, Filter filter) {
        this.rangeName = rangeName;
        this.rangeAddress = rangeAddress;
        this.displayButtons = displayButtons;
        this.filter = filter;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<table:database-range");
        util.appendAttribute(appendable, (CharSequence)"table:name", this.rangeName);
        util.appendAttribute(appendable, (CharSequence)"table:display-filter-buttons", this.displayButtons);
        util.appendAttribute(appendable, (CharSequence)"table:target-range-address", this.rangeAddress);
        if (this.filter == null) {
            appendable.append("/>");
        } else {
            appendable.append("><table:filter>");
            this.filter.appendXMLContent(util, appendable);
            appendable.append("</table:filter></table:database-range>");
        }
    }
}

