/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.tool;

import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.StringValue;
import com.github.jferard.fastods.TimeValue;
import com.github.jferard.fastods.attribute.CellType;
import com.github.jferard.fastods.attribute.SimpleColor;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.tool.ResultSetDataWrapper;
import com.github.jferard.fastods.tool.SQLToCellValueConverter;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

public class ResultSetDataWrapperBuilder {
    private static final TableCellStyle HEADER_STYLE = TableCellStyle.builder("rs-data-wrapper").backgroundColor(SimpleColor.GRAY64).fontWeightBold().build();
    private final String rangeName;
    private final ResultSet rs;
    private final Map<Integer, CellType> cellTypeByIndex;
    private Charset charset;
    private SQLToCellValueConverter.IntervalConverter converter;
    private String currency;
    private Logger logger;
    private TableCellStyle headerStyle;
    private boolean autoFilter;
    private int max;
    private CellValue nullValue;

    public ResultSetDataWrapperBuilder(String rangeName, ResultSet rs) {
        this.rangeName = rangeName;
        this.rs = rs;
        this.logger = null;
        this.headerStyle = HEADER_STYLE;
        this.autoFilter = true;
        this.max = -1;
        this.cellTypeByIndex = new HashMap<Integer, CellType>();
        this.currency = NumberFormat.getCurrencyInstance(Locale.US).getCurrency().getSymbol();
        this.charset = Charset.forName("US-ASCII");
        this.nullValue = new StringValue("<NULL>");
        this.converter = new SQLToCellValueConverter.IntervalConverter(){

            @Override
            public TimeValue castToInterval(Object o) {
                return null;
            }
        };
    }

    public ResultSetDataWrapperBuilder logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public ResultSetDataWrapperBuilder headerStyle(TableCellStyle headerStyle) {
        this.headerStyle = headerStyle;
        return this;
    }

    public ResultSetDataWrapperBuilder noHeaderStyle() {
        this.headerStyle = null;
        return this;
    }

    public ResultSetDataWrapperBuilder max(int max) {
        this.max = max;
        return this;
    }

    public ResultSetDataWrapperBuilder noAutoFilter() {
        this.autoFilter = false;
        return this;
    }

    public ResultSetDataWrapperBuilder typeValue(int j, CellType cellType) {
        this.cellTypeByIndex.put(j, cellType);
        return this;
    }

    public ResultSetDataWrapperBuilder nullValue(CellValue nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    public ResultSetDataWrapperBuilder currency(String currency) {
        this.currency = currency;
        return this;
    }

    public ResultSetDataWrapperBuilder charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public ResultSetDataWrapperBuilder converter(SQLToCellValueConverter.IntervalConverter converter) {
        this.converter = converter;
        return this;
    }

    public ResultSetDataWrapper build() {
        SQLToCellValueConverter sqlToCellValueConverter = SQLToCellValueConverter.create(this.converter, this.currency, this.charset);
        Map<Integer, CellType> cellTypeByIndexOrNull = this.cellTypeByIndex.isEmpty() ? null : this.cellTypeByIndex;
        return new ResultSetDataWrapper(this.logger, sqlToCellValueConverter, this.rangeName, this.rs, this.headerStyle, this.autoFilter, cellTypeByIndexOrNull, this.nullValue, this.max);
    }
}

