/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.style.TextProperties;
import com.github.jferard.fastods.style.TextPropertiesBuilder;
import com.github.jferard.fastods.style.TextStyle;

public class TextStyleBuilder {
    private final TextPropertiesBuilder propertiesBuilder;
    private final String name;
    private boolean visible;

    TextStyleBuilder(String name) {
        this.name = name;
        this.propertiesBuilder = new TextPropertiesBuilder();
    }

    public TextStyle build() {
        if (this.visible) {
            return this.buildStyle(this.name);
        }
        return this.buildHiddenStyle(this.name);
    }

    private TextStyle buildStyle(String name) {
        return new TextStyle(name, false, this.propertiesBuilder.build());
    }

    private TextStyle buildHiddenStyle(String name) {
        if (this.propertiesBuilder.hasFontSizePercentage()) {
            throw new IllegalArgumentException("20.183 fo:font-size: fontSizePercentage values can be used within visible styles only");
        }
        return new TextStyle(name, true, this.propertiesBuilder.build());
    }

    public TextStyleBuilder fontColor(Color color) {
        this.propertiesBuilder.fontColor(color);
        return this;
    }

    public TextStyleBuilder fontName(String fontName) {
        this.propertiesBuilder.fontName(fontName);
        return this;
    }

    public TextStyleBuilder fontSize(Length fontSize) {
        this.propertiesBuilder.fontSize(fontSize);
        return this;
    }

    public TextStyleBuilder fontSizePercentage(double percentage) {
        this.propertiesBuilder.fontSizePercentage(percentage);
        return this;
    }

    public TextStyleBuilder fontStyleItalic() {
        this.propertiesBuilder.fontStyleItalic();
        return this;
    }

    public TextStyleBuilder fontStyleNormal() {
        this.propertiesBuilder.fontStyleNormal();
        return this;
    }

    public TextStyleBuilder fontUnderlineColor(Color color) {
        this.propertiesBuilder.fontUnderlineColor(color);
        return this;
    }

    public TextStyleBuilder fontUnderlineStyle(TextProperties.Underline style) {
        this.propertiesBuilder.fontUnderlineStyle(style);
        return this;
    }

    public TextStyleBuilder fontWeightBold() {
        this.propertiesBuilder.fontWeightBold();
        return this;
    }

    public TextStyleBuilder fontWeightNormal() {
        this.propertiesBuilder.fontWeightNormal();
        return this;
    }

    public TextStyleBuilder visible() {
        this.visible = true;
        return this;
    }
}

