/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.ref.LocalCellRef;
import com.github.jferard.fastods.ref.LocalCellRefBuilder;
import com.github.jferard.fastods.ref.RangeRef;
import com.github.jferard.fastods.ref.TableNameUtil;
import com.github.jferard.fastods.ref.TableRef;
import com.github.jferard.fastods.ref.TableRefBuilder;
import java.io.File;

public class RangeRefBuilder {
    private final TableRefBuilder tableRefBuilder;
    private final LocalCellRefBuilder fromLocalCellRefBuilder;
    private final LocalCellRefBuilder toLocalCellRefBuilder;

    RangeRefBuilder(TableNameUtil tableNameUtil) {
        this.tableRefBuilder = TableRef.builder(tableNameUtil);
        this.fromLocalCellRefBuilder = LocalCellRef.builder();
        this.toLocalCellRefBuilder = LocalCellRef.builder();
    }

    public RangeRefBuilder fromRow(int r) {
        this.fromLocalCellRefBuilder.row(r);
        return this;
    }

    public RangeRefBuilder fromAbsRow(int r) {
        this.fromLocalCellRefBuilder.absRow(r);
        return this;
    }

    public RangeRefBuilder fromColumn(int c) {
        this.fromLocalCellRefBuilder.column(c);
        return this;
    }

    public RangeRefBuilder fromAbsColumn(int c) {
        this.fromLocalCellRefBuilder.absColumn(c);
        return this;
    }

    public RangeRefBuilder toRow(int r) {
        this.toLocalCellRefBuilder.row(r);
        return this;
    }

    public RangeRefBuilder toAbsRow(int r) {
        this.toLocalCellRefBuilder.absRow(r);
        return this;
    }

    public RangeRefBuilder toColumn(int c) {
        this.toLocalCellRefBuilder.column(c);
        return this;
    }

    public RangeRefBuilder toAbsColumn(int c) {
        this.toLocalCellRefBuilder.absColumn(c);
        return this;
    }

    public RangeRefBuilder table(String tableName) {
        this.tableRefBuilder.table(tableName);
        return this;
    }

    public RangeRefBuilder absTable(String tableName) {
        this.tableRefBuilder.absTable(tableName);
        return this;
    }

    public RangeRefBuilder table(Table table) {
        this.tableRefBuilder.table(table);
        return this;
    }

    public RangeRefBuilder absTable(Table table) {
        this.tableRefBuilder.absTable(table);
        return this;
    }

    public RangeRefBuilder file(String fileName) {
        this.tableRefBuilder.file(fileName);
        return this;
    }

    public RangeRefBuilder file(File file) {
        this.tableRefBuilder.file(file);
        return this;
    }

    public RangeRef build() {
        return new RangeRef(this.tableRefBuilder.build(), this.fromLocalCellRefBuilder.build(), this.toLocalCellRefBuilder.build());
    }
}

