/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import com.github.jferard.fastods.ref.LocalCellRef;
import com.github.jferard.fastods.ref.TableRef;
import com.github.jferard.fastods.util.EqualityUtil;
import java.io.IOException;

public class RangeRef {
    public static final char RANGE_SEP = ':';
    private final TableRef tableRef;
    private final LocalCellRef fromCellRef;
    private final LocalCellRef toCellRef;

    public RangeRef(TableRef tableRef, LocalCellRef fromCellRef, LocalCellRef toCellRef) {
        this.tableRef = tableRef;
        this.fromCellRef = fromCellRef;
        this.toCellRef = toCellRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeRef)) {
            return false;
        }
        RangeRef other = (RangeRef)o;
        return EqualityUtil.equal(this.tableRef, other.tableRef) && EqualityUtil.equal(this.fromCellRef, other.fromCellRef) && EqualityUtil.equal(this.toCellRef, other.toCellRef);
    }

    public int hashCode() {
        return EqualityUtil.hashObjects(this.tableRef, this.fromCellRef, this.toCellRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.write(sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    public void write(Appendable appendable) throws IOException {
        this.appendTableRef(appendable);
        this.fromCellRef.write(appendable);
        appendable.append(':');
        this.toCellRef.write(appendable);
    }

    private void appendTableRef(Appendable appendable) throws IOException {
        if (this.tableRef != null) {
            this.tableRef.write(appendable);
            appendable.append('.');
        }
    }

    public int getFromColumn() {
        return this.fromCellRef.getColumn();
    }

    public int getFromRow() {
        return this.fromCellRef.getRow();
    }

    public int getToColumn() {
        return this.toCellRef.getColumn();
    }

    public int getToRow() {
        return this.toCellRef.getRow();
    }
}

