/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import com.github.jferard.fastods.ref.LocalCellRef;
import com.github.jferard.fastods.ref.TableRef;
import com.github.jferard.fastods.util.EqualityUtil;
import java.io.IOException;

public class CellRef {
    public static final char TABLE_CELL_SEP = '.';
    public static final int RELATIVE = 0;
    public static final int ABSOLUTE_COL = 1;
    public static final int ABSOLUTE_ROW = 2;
    public static final int ABSOLUTE_TABLE = 4;
    private final LocalCellRef localCellRef;
    private final TableRef tableRef;

    public static CellRef create(int r, int c, int status) {
        return new CellRef(null, new LocalCellRef(r, c, status));
    }

    public CellRef(TableRef tableRef, LocalCellRef localCellRef) {
        this.tableRef = tableRef;
        this.localCellRef = localCellRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CellRef)) {
            return false;
        }
        CellRef other = (CellRef)o;
        return EqualityUtil.equal(this.tableRef, other.tableRef) && EqualityUtil.equal(this.localCellRef, other.localCellRef);
    }

    public int hashCode() {
        return EqualityUtil.hashObjects(this.tableRef, this.localCellRef);
    }

    public int getColumn() {
        return this.localCellRef.getColumn();
    }

    public int getRow() {
        return this.localCellRef.getRow();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.write(sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    public void write(Appendable appendable) throws IOException {
        if (this.tableRef != null) {
            this.tableRef.write(appendable);
            appendable.append('.');
        }
        this.localCellRef.write(appendable);
    }
}

