/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.odselement.Settings;
import com.github.jferard.fastods.odselement.StandardOdsEntry;
import com.github.jferard.fastods.odselement.config.ConfigBlock;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SettingsElement
implements OdsElement {
    public static final Map<String, String> SETTINGS_NAMESPACE_BY_PREFIX = new HashMap<String, String>();
    private final Settings settings;
    private List<Table> tables;

    static SettingsElement create() {
        return new SettingsElement(Settings.create());
    }

    SettingsElement(Settings settings) {
        this.settings = settings;
    }

    public void addTableConfig(ConfigItemMapEntry configEntry) {
        this.settings.addTableConfig(configEntry);
    }

    public void setTables(List<Table> tables) {
        this.settings.setTables(tables);
    }

    @Override
    public void write(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        writer.putAndRegisterNextEntry(new StandardOdsEntry("settings.xml", "text/xml", null));
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.append("<office:document-settings");
        for (Map.Entry<String, String> entry : SETTINGS_NAMESPACE_BY_PREFIX.entrySet()) {
            util.appendAttribute((Appendable)writer, (CharSequence)entry.getKey(), entry.getValue());
        }
        util.appendAttribute((Appendable)writer, (CharSequence)"office:version", "1.2");
        writer.append("><office:settings>");
        for (ConfigBlock block : this.settings.getRootBlocks()) {
            block.appendXMLContent(util, writer);
        }
        writer.append("</office:settings>");
        writer.append("</office:document-settings>");
        writer.closeEntry();
    }

    public void setActiveTable(Table table) {
        this.settings.setActiveTable(table);
    }

    public void setViewSetting(String viewId, String item, String value) {
        this.settings.setViewSetting(viewId, item, value);
    }

    static {
        SETTINGS_NAMESPACE_BY_PREFIX.putAll(OdsElements.BASE_NAMESPACE_BY_PREFIX);
        SETTINGS_NAMESPACE_BY_PREFIX.put("xmlns:config", "urn:oasis:names:tc:opendocument:xmlns:config:1.0");
    }
}

