/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.FinalizeFlusher;
import com.github.jferard.fastods.ImmutableElementsFlusher;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.PrepareContentFlusher;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.attribute.CellType;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.odselement.ContentElement;
import com.github.jferard.fastods.odselement.EmptyElement;
import com.github.jferard.fastods.odselement.ExtraElement;
import com.github.jferard.fastods.odselement.ManifestElement;
import com.github.jferard.fastods.odselement.ManifestEntryElement;
import com.github.jferard.fastods.odselement.MetaElement;
import com.github.jferard.fastods.odselement.MimetypeElement;
import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.odselement.ScriptEventListener;
import com.github.jferard.fastods.odselement.SettingsElement;
import com.github.jferard.fastods.odselement.StandardOdsEntry;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.odselement.StylesContainerImpl;
import com.github.jferard.fastods.odselement.StylesElement;
import com.github.jferard.fastods.odselement.config.ConfigElement;
import com.github.jferard.fastods.odselement.config.ConfigItem;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.ref.PositionUtil;
import com.github.jferard.fastods.style.FontFaceContainerStyle;
import com.github.jferard.fastods.style.MasterPageStyle;
import com.github.jferard.fastods.style.ObjectStyle;
import com.github.jferard.fastods.style.PageLayoutStyle;
import com.github.jferard.fastods.style.PageStyle;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.util.AutoFilter;
import com.github.jferard.fastods.util.Container;
import com.github.jferard.fastods.util.IntegerRepresentationCache;
import com.github.jferard.fastods.util.PilotTable;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OdsElements
implements StylesContainer {
    public static final String SC_SPLIT_NORMAL = "0";
    public static final String SC_SPLIT_FIX = "2";
    public static final Map<String, String> BASE_NAMESPACE_BY_PREFIX = new HashMap<String, String>();
    private static final OdsElement[] EMPTY_ELEMENTS = new OdsElement[]{new ManifestEntryElement(new StandardOdsEntry("/", "application/vnd.oasis.opendocument.spreadsheet", "1.2")), new ManifestEntryElement(new StandardOdsEntry("Configurations2/", "application/vnd.sun.xml.ui.configuration", null)), new EmptyElement(new StandardOdsEntry("Configurations2/statusbar/", "", null)), new ManifestEntryElement(new StandardOdsEntry("Configurations2/accelerator/", "", null)), new EmptyElement(new StandardOdsEntry("Configurations2/accelerator/current.xml", "", null)), new EmptyElement(new StandardOdsEntry("Configurations2/floater/", "", null)), new EmptyElement(new StandardOdsEntry("Configurations2/popupmenu/", "", null)), new EmptyElement(new StandardOdsEntry("Configurations2/progressbar/", "", null)), new EmptyElement(new StandardOdsEntry("Configurations2/menubar/", "", null)), new EmptyElement(new StandardOdsEntry("Configurations2/toolbar/", "", null)), new ManifestEntryElement(new StandardOdsEntry("Configurations2/images/", "", null)), new EmptyElement(new StandardOdsEntry("Configurations2/images/Bitmaps/", "", null)), new EmptyElement(new StandardOdsEntry("Thumbnails/", "", null))};
    private final ContentElement contentElement;
    private final Logger logger;
    private final ManifestElement manifestElement;
    private final MetaElement metaElement;
    private final MimetypeElement mimeTypeElement;
    private final SettingsElement settingsElement;
    private final StylesContainerImpl stylesContainer;
    private final StylesElement stylesElement;
    private final Set<OdsElement> extraElements;
    private NamedOdsFileWriter observer;

    public static OdsElements create(PositionUtil positionUtil, XMLUtil xmlUtil, IntegerRepresentationCache cache, DataStyles format, boolean libreOfficeMode, MetaElement metaElement, Map<String, String> additionalNamespaceByPrefix) {
        Logger logger = Logger.getLogger(OdsElements.class.getName());
        MimetypeElement mimetypeElement = new MimetypeElement();
        ManifestElement manifestElement = ManifestElement.create();
        SettingsElement settingsElement = SettingsElement.create();
        StylesContainerImpl stylesContainer = new StylesContainerImpl(logger);
        StylesElement stylesElement = new StylesElement(stylesContainer);
        ContentElement contentElement = new ContentElement(positionUtil, xmlUtil, cache, format, libreOfficeMode, stylesContainer, additionalNamespaceByPrefix);
        return new OdsElements(logger, stylesContainer, mimetypeElement, manifestElement, settingsElement, metaElement, contentElement, stylesElement);
    }

    OdsElements(Logger logger, StylesContainerImpl stylesContainer, MimetypeElement mimeTypeElement, ManifestElement manifestElement, SettingsElement settingsElement, MetaElement metaElement, ContentElement contentElement, StylesElement stylesElement) {
        this.logger = logger;
        this.mimeTypeElement = mimeTypeElement;
        this.manifestElement = manifestElement;
        this.settingsElement = settingsElement;
        this.metaElement = metaElement;
        this.contentElement = contentElement;
        this.stylesElement = stylesElement;
        this.stylesContainer = stylesContainer;
        this.extraElements = new HashSet<OdsElement>();
    }

    public void addObserver(NamedOdsFileWriter o) {
        this.observer = o;
    }

    public void addCellStyle(TableCellStyle style, CellType ... types) {
        this.stylesContainer.addContentStyle(style);
        for (CellType type : types) {
            this.contentElement.addChildCellStyle(style, type);
        }
    }

    @Override
    public boolean addDataStyle(DataStyle dataStyle) {
        return this.stylesContainer.addDataStyle(dataStyle);
    }

    @Override
    public void setDataStylesMode(Container.Mode mode) {
        this.stylesContainer.setDataStylesMode(mode);
    }

    @Override
    public boolean addMasterPageStyle(MasterPageStyle masterPageStyle) {
        return this.stylesContainer.addMasterPageStyle(masterPageStyle);
    }

    @Override
    public void setMasterPageStyleMode(Container.Mode mode) {
        this.stylesContainer.setMasterPageStyleMode(mode);
    }

    @Override
    public boolean addNewDataStyleFromCellStyle(TableCellStyle style) {
        return this.stylesContainer.addNewDataStyleFromCellStyle(style);
    }

    @Override
    public void setPageLayoutStyleMode(Container.Mode mode) {
        this.stylesContainer.setPageLayoutStyleMode(mode);
    }

    @Override
    public boolean addPageLayoutStyle(PageLayoutStyle pageLayoutStyle) {
        return this.stylesContainer.addPageLayoutStyle(pageLayoutStyle);
    }

    @Override
    public void setPageStyleMode(Container.Mode mode) {
        this.stylesContainer.setPageStyleMode(mode);
    }

    @Override
    public boolean addPageStyle(PageStyle ps) {
        return this.stylesContainer.addPageStyle(ps);
    }

    @Override
    public void setObjectStyleMode(Container.Mode mode) {
        this.stylesContainer.setObjectStyleMode(mode);
    }

    @Override
    public boolean addContentStyle(ObjectStyle objectStyle) {
        return this.stylesContainer.addContentStyle(objectStyle);
    }

    @Override
    public boolean addStylesStyle(ObjectStyle objectStyle) {
        return this.stylesContainer.addStylesStyle(objectStyle);
    }

    @Override
    public TableCellStyle addChildCellStyle(TableCellStyle style, DataStyle dataStyle) {
        return this.stylesContainer.addChildCellStyle(style, dataStyle);
    }

    @Override
    public boolean addContentFontFaceContainerStyle(FontFaceContainerStyle objectStyle) {
        return this.stylesContainer.addContentFontFaceContainerStyle(objectStyle);
    }

    @Override
    public boolean addStylesFontFaceContainerStyle(FontFaceContainerStyle ffcStyle) {
        return this.stylesContainer.addContentFontFaceContainerStyle(ffcStyle);
    }

    public void createEmptyElements(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing empty ods elements to zip file");
        for (OdsElement element : EMPTY_ELEMENTS) {
            this.logger.log(Level.FINEST, "Writing ods element: {0} to zip file", element);
            element.write(util, writer);
        }
    }

    public void debugStyles() {
        this.stylesContainer.debug();
    }

    public void freezeStyles() {
        this.stylesContainer.freeze();
    }

    @Deprecated
    public Table addTableToContent(String name, int rowCapacity, int columnCapacity) throws IOException {
        Table table = this.contentElement.createTable(name, rowCapacity, columnCapacity);
        if (this.addTableToContent(table)) {
            return table;
        }
        return null;
    }

    public boolean addTableToContent(Table table) throws IOException {
        Table previousTable = this.contentElement.getLastTable();
        boolean add = this.contentElement.addTable(table);
        if (add) {
            this.settingsElement.addTableConfig(table.getConfigEntry());
            if (this.observer != null) {
                this.asyncFlushPreviousTable(previousTable, table);
            }
        }
        return add;
    }

    public Table createTable(String name, int rowCapacity, int columnCapacity) {
        return this.contentElement.createTable(name, rowCapacity, columnCapacity);
    }

    private void asyncFlushPreviousTable(Table previousTable, Table table) throws IOException {
        table.addObserver(this.observer);
        if (previousTable == null) {
            this.observer.update(new PrepareContentFlusher(this, this.contentElement));
        } else {
            previousTable.asyncFlushEndTable();
        }
    }

    public void prepareAsync() throws IOException {
        this.observer.update(new ImmutableElementsFlusher(this));
    }

    public void saveAsync() throws IOException {
        Table previousTable = this.contentElement.getLastTable();
        if (previousTable == null) {
            this.observer.update(new PrepareContentFlusher(this, this.contentElement));
        } else {
            previousTable.asyncFlushEndTable();
        }
        this.observer.update(new FinalizeFlusher(this, this.contentElement));
    }

    public void writeContent(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: contentElement to zip file");
        this.contentElement.write(xmlUtil, writer);
    }

    public void writeMeta(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: metaElement to zip file");
        this.metaElement.write(xmlUtil, writer);
    }

    public void writeSettings(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.settingsElement.setTables(this.getTables());
        this.logger.log(Level.FINER, "Writing ods element: settingsElement to zip file");
        this.settingsElement.write(xmlUtil, writer);
    }

    public void writeStyles(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: stylesElement to zip file");
        this.stylesElement.write(xmlUtil, writer);
    }

    public void freezeCells(Table table, int rowCount, int colCount) {
        ConfigItemMapEntry tableConfig = table.getConfigEntry();
        tableConfig.put(ConfigItem.create(ConfigElement.HORIZONTAL_SPLIT_MODE, SC_SPLIT_FIX));
        tableConfig.put(ConfigItem.create(ConfigElement.VERTICAL_SPLIT_MODE, SC_SPLIT_FIX));
        tableConfig.put(ConfigItem.create(ConfigElement.HORIZONTAL_SPLIT_POSITION, String.valueOf(colCount)));
        tableConfig.put(ConfigItem.create(ConfigElement.VERTICAL_SPLIT_POSITION, String.valueOf(rowCount)));
    }

    public Table getTable(int tableIndex) {
        return this.contentElement.getTable(tableIndex);
    }

    public Table getTable(String name) {
        return this.contentElement.getTable(name);
    }

    public int getTableCount() {
        return this.contentElement.getTableCount();
    }

    public List<Table> getTables() {
        return this.contentElement.getTables();
    }

    public void setActiveTable(Table table) {
        this.settingsElement.setActiveTable(table);
    }

    public void setViewSetting(String viewId, String item, String value) {
        this.settingsElement.setViewSetting(viewId, item, value);
    }

    public void addAutoFilter(AutoFilter autoFilter) {
        this.contentElement.addAutoFilter(autoFilter);
    }

    public void addExtraFile(String fullPath, String mediaType, byte[] data) {
        ExtraElement element = new ExtraElement(new StandardOdsEntry(fullPath, mediaType, null), data);
        this.extraElements.add(element);
    }

    public void addExtraDir(String fullDirectoryPath) {
        String fullPath = this.pathWithSlash(fullDirectoryPath);
        ManifestEntryElement element = new ManifestEntryElement(new StandardOdsEntry(fullPath, "", null));
        this.extraElements.add(element);
    }

    private String pathWithSlash(String fullDirectoryPath) {
        if (fullDirectoryPath.endsWith("/")) {
            return fullDirectoryPath;
        }
        return fullDirectoryPath + "/";
    }

    public void addExtraObject(String fullDirectoryPath, String mediaType, String version) {
        String fullPath = this.pathWithSlash(fullDirectoryPath);
        ManifestEntryElement element = new ManifestEntryElement(new StandardOdsEntry(fullPath, mediaType, version));
        this.extraElements.add(element);
    }

    public void writeExtras(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing extra elements to zip file");
        for (OdsElement element : this.extraElements) {
            this.logger.log(Level.FINEST, "Writing ods element: {0} to zip file", element);
            element.write(xmlUtil, writer);
        }
    }

    public void writeMimeType(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: mimeTypeEntry to zip file");
        this.mimeTypeElement.write(xmlUtil, writer);
    }

    public void addEvents(ScriptEventListener ... events) {
        this.contentElement.addEvents(events);
    }

    public void addPilotTable(PilotTable pilot) {
        this.contentElement.addPilotTable(pilot);
    }

    static {
        BASE_NAMESPACE_BY_PREFIX.put("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        BASE_NAMESPACE_BY_PREFIX.put("xmlns:xlink", "http://www.w3.org/1999/xlink");
        BASE_NAMESPACE_BY_PREFIX.put("xmlns:ooo", "http://openoffice.org/2004/office");
    }
}

