/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.odselement.EncryptParameters;
import com.github.jferard.fastods.odselement.OdsEntry;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.zip.ZipEntry;

public class EncryptedOdsEntry
implements OdsEntry {
    private final String fullPath;
    private final CharSequence mediaType;
    private final CharSequence version;
    private final EncryptParameters encryptParameters;

    public EncryptedOdsEntry(String fullPath, CharSequence mediaType, CharSequence version, EncryptParameters encryptParameters) {
        this.fullPath = fullPath;
        this.mediaType = mediaType;
        this.version = version;
        this.encryptParameters = encryptParameters;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<manifest:file-entry");
        util.appendAttribute(appendable, (CharSequence)"manifest:full-path", this.fullPath);
        if (this.mediaType != null) {
            util.appendAttribute(appendable, (CharSequence)"manifest:media-type", this.mediaType);
        }
        if (this.version != null) {
            util.appendAttribute(appendable, (CharSequence)"manifest:version", this.version);
        }
        util.appendAttribute(appendable, (CharSequence)"manifest:size", this.encryptParameters.getUncompressedSize());
        appendable.append(">");
        this.encryptParameters.appendXMLContent(util, appendable);
        appendable.append("</manifest:file-entry>");
    }

    @Override
    public OdsEntry encryptParameters(EncryptParameters encryptParameters) {
        throw new IllegalArgumentException();
    }

    @Override
    public ZipEntry asZipEntry() {
        ZipEntry zipEntry = new ZipEntry(this.fullPath);
        zipEntry.setSize(this.encryptParameters.getCompressedSize());
        zipEntry.setCompressedSize(this.encryptParameters.getCompressedSize());
        zipEntry.setCrc(this.encryptParameters.getCrc32());
        zipEntry.setMethod(0);
        return zipEntry;
    }

    @Override
    public boolean neverEncrypt() {
        return true;
    }
}

