/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.attribute.SimpleColor;
import com.github.jferard.fastods.datastyle.CoreDataStyleBuilder;
import com.github.jferard.fastods.datastyle.NumberStyleBuilder;
import com.github.jferard.fastods.datastyle.NumberStyleHelper;
import java.util.Locale;

public final class NumberStyleHelperBuilder
implements NumberStyleBuilder<NumberStyleHelper, NumberStyleHelperBuilder> {
    private final CoreDataStyleBuilder dataStyleBuilder;
    private boolean grouping;
    private int minIntegerDigits;
    private Color negativeValueColor;

    NumberStyleHelperBuilder(String name, Locale locale) {
        this.dataStyleBuilder = new CoreDataStyleBuilder(name, locale);
        this.minIntegerDigits = 1;
        this.grouping = false;
    }

    @Override
    public NumberStyleHelperBuilder groupThousands(boolean grouping) {
        this.grouping = grouping;
        return this;
    }

    @Override
    public NumberStyleHelperBuilder minIntegerDigits(int minIntegerDigits) {
        this.minIntegerDigits = minIntegerDigits;
        return this;
    }

    @Override
    public NumberStyleHelperBuilder negativeValueColor(Color negativeValueColor) {
        this.negativeValueColor = negativeValueColor;
        return this;
    }

    @Override
    public NumberStyleHelperBuilder negativeValueRed() {
        this.negativeValueColor = SimpleColor.RED;
        return this;
    }

    @Override
    public NumberStyleHelperBuilder country(String countryCode) {
        this.dataStyleBuilder.country(countryCode);
        return this;
    }

    @Override
    public NumberStyleHelperBuilder language(String languageCode) {
        this.dataStyleBuilder.language(languageCode);
        return this;
    }

    @Override
    public NumberStyleHelperBuilder locale(Locale locale) {
        this.dataStyleBuilder.locale(locale);
        return this;
    }

    @Override
    public NumberStyleHelperBuilder volatileStyle(boolean volatileStyle) {
        this.dataStyleBuilder.volatileStyle(volatileStyle);
        return this;
    }

    @Override
    public NumberStyleHelperBuilder visible() {
        this.dataStyleBuilder.visible();
        return this;
    }

    @Override
    public NumberStyleHelper build() {
        return new NumberStyleHelper(this.dataStyleBuilder.build(), this.grouping, this.minIntegerDigits, this.negativeValueColor);
    }
}

