/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.datastyle.DataStyleBuilder;
import com.github.jferard.fastods.datastyle.FractionStyle;
import com.github.jferard.fastods.datastyle.NumberStyleBuilder;
import com.github.jferard.fastods.datastyle.NumberStyleHelperBuilder;
import com.github.jferard.fastods.util.NameChecker;
import java.util.Locale;

public class FractionStyleBuilder
implements DataStyleBuilder<FractionStyle, FractionStyleBuilder>,
NumberStyleBuilder<FractionStyle, FractionStyleBuilder> {
    private static final NameChecker checker = new NameChecker();
    private final NumberStyleHelperBuilder numberStyleHelperBuilder;
    private int minDenominatorDigits;
    private int minNumeratorDigits;

    public static FractionStyleBuilder create(String name, Locale locale) {
        checker.checkStyleName(name);
        return new FractionStyleBuilder(name, locale);
    }

    public FractionStyleBuilder(String name, Locale locale) {
        this.numberStyleHelperBuilder = new NumberStyleHelperBuilder(name, locale);
        this.minNumeratorDigits = 0;
        this.minDenominatorDigits = 0;
    }

    @Override
    public FractionStyle build() {
        return new FractionStyle(this.numberStyleHelperBuilder.build(), this.minNumeratorDigits, this.minDenominatorDigits);
    }

    public FractionStyleBuilder fractionValues(int numerator, int denominator) {
        this.minNumeratorDigits = numerator;
        this.minDenominatorDigits = denominator;
        return this;
    }

    @Override
    public FractionStyleBuilder groupThousands(boolean grouping) {
        this.numberStyleHelperBuilder.groupThousands(grouping);
        return this;
    }

    @Override
    public FractionStyleBuilder minIntegerDigits(int minIntegerDigits) {
        this.numberStyleHelperBuilder.minIntegerDigits(minIntegerDigits);
        return this;
    }

    @Override
    public FractionStyleBuilder negativeValueColor(Color negativeValueColor) {
        this.numberStyleHelperBuilder.negativeValueColor(negativeValueColor);
        return this;
    }

    @Override
    public FractionStyleBuilder negativeValueRed() {
        this.numberStyleHelperBuilder.negativeValueRed();
        return this;
    }

    @Override
    public FractionStyleBuilder country(String countryCode) {
        this.numberStyleHelperBuilder.country(countryCode);
        return this;
    }

    @Override
    public FractionStyleBuilder language(String languageCode) {
        this.numberStyleHelperBuilder.language(languageCode);
        return this;
    }

    @Override
    public FractionStyleBuilder locale(Locale locale) {
        this.numberStyleHelperBuilder.locale(locale);
        return this;
    }

    @Override
    public FractionStyleBuilder volatileStyle(boolean volatileStyle) {
        this.numberStyleHelperBuilder.volatileStyle(volatileStyle);
        return this;
    }

    @Override
    public FractionStyleBuilder visible() {
        this.numberStyleHelperBuilder.visible();
        return this;
    }
}

