/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.ElementWithEmbeddedStyles;
import com.github.jferard.fastods.TooltipBuilder;
import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.GraphicStyle;
import com.github.jferard.fastods.util.SVGRectangle;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class Tooltip
implements XMLConvertible,
ElementWithEmbeddedStyles {
    private final boolean visible;
    private final GraphicStyle graphicStyle;
    private final String text;
    private final SVGRectangle rectangle;

    public static TooltipBuilder builder(XMLUtil xmlUtil, String text) {
        String escapedXMLContent = xmlUtil.escapeXMLContent(text);
        if (escapedXMLContent.contains("\n")) {
            escapedXMLContent = escapedXMLContent.replaceAll("\r?\n", "</text:p><text:p>");
        }
        return new TooltipBuilder(escapedXMLContent);
    }

    Tooltip(String text, SVGRectangle rectangle, boolean visible, GraphicStyle graphicStyle) {
        this.text = text;
        this.rectangle = rectangle;
        this.visible = visible;
        this.graphicStyle = graphicStyle;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<office:annotation");
        if (this.visible) {
            util.appendAttribute(appendable, (CharSequence)"office:display", this.visible);
        }
        if (this.rectangle != null) {
            this.rectangle.appendXMLContent(util, appendable);
        }
        if (this.graphicStyle != null) {
            util.appendAttribute(appendable, (CharSequence)"draw:style-name", this.graphicStyle.getName());
        }
        appendable.append("><text:p>").append(this.text).append("</text:p></office:annotation>");
    }

    @Override
    public void addEmbeddedStyles(StylesContainer stylesContainer) {
        if (this.graphicStyle != null) {
            this.graphicStyle.addEmbeddedStyles(stylesContainer);
            stylesContainer.addContentStyle(this.graphicStyle);
        }
    }
}

