/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.PreambleAppender;
import com.github.jferard.fastods.TableBuilder;
import com.github.jferard.fastods.TableRowImpl;
import com.github.jferard.fastods.util.Protection;
import com.github.jferard.fastods.util.StringUtil;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class TableAppender {
    private final TableBuilder builder;
    private boolean preambleWritten = false;
    private int nullFieldCounter;
    private boolean atLeastOneRow;

    TableAppender(TableBuilder builder) {
        this.builder = builder;
        this.atLeastOneRow = false;
    }

    public void appendXMLToContentEntry(XMLUtil util, Appendable appendable) throws IOException {
        this.appendOpenTagAndPreamble(util, appendable);
        this.appendRows(util, appendable);
        this.appendPostamble(appendable);
    }

    public void appendOpenTagAndPreamble(XMLUtil util, Appendable appendable) throws IOException {
        this.appendTableOpenTag(util, appendable);
        PreambleAppender preambleAppender = new PreambleAppender(this.builder);
        preambleAppender.appendForms(util, appendable);
        preambleAppender.appendShapes(util, appendable);
        preambleAppender.appendColumns(util, appendable);
    }

    private void appendTableOpenTag(XMLUtil util, Appendable appendable) throws IOException {
        Map<String, CharSequence> customValueByAttribute;
        Protection protection;
        appendable.append("<table:table");
        util.appendEAttribute(appendable, "table:name", this.builder.getName());
        util.appendEAttribute(appendable, "table:style-name", this.builder.getStyleName());
        util.appendAttribute(appendable, (CharSequence)"table:print", false);
        List<String> printRanges = this.builder.getPrintRanges();
        if (!printRanges.isEmpty()) {
            String printRangesAddresses = StringUtil.join(" ", printRanges);
            util.appendEAttribute(appendable, "table:print-ranges", printRangesAddresses);
        }
        if ((protection = this.builder.getProtection()) != null) {
            protection.appendAttributes(util, appendable);
        }
        if ((customValueByAttribute = this.builder.getCustomValueByAttribute()) != null) {
            for (Map.Entry<String, CharSequence> entry : customValueByAttribute.entrySet()) {
                util.appendAttribute(appendable, (CharSequence)entry.getKey(), entry.getValue());
            }
        }
        appendable.append(">");
    }

    private void appendRows(XMLUtil util, Appendable appendable) throws IOException {
        this.appendRows(util, appendable, 0);
    }

    private void appendRows(XMLUtil util, Appendable appendable, int firstRowIndex) throws IOException {
        int headerRowsCount = this.builder.getHeaderRowsCount();
        if (headerRowsCount == 0) {
            this.appendRowsWithoutHeaderRows(util, appendable, firstRowIndex);
        } else {
            if (firstRowIndex == 0) {
                appendable.append("<table:table-header-rows>");
            }
            if (firstRowIndex < headerRowsCount) {
                this.appendRowsWithHeaderRows(util, appendable, firstRowIndex, headerRowsCount);
            } else if (firstRowIndex == headerRowsCount) {
                appendable.append("</table:table-header-rows>");
                this.appendRowsWithoutHeaderRows(util, appendable, firstRowIndex);
            } else {
                this.appendRowsWithoutHeaderRows(util, appendable, firstRowIndex);
            }
        }
    }

    private void appendRowsWithoutHeaderRows(XMLUtil util, Appendable appendable, int firstRowIndex) throws IOException {
        int size = this.builder.getTableRowsUsedSize();
        if (firstRowIndex == 0) {
            this.nullFieldCounter = 0;
        }
        for (int r = firstRowIndex; r < size; ++r) {
            TableRowImpl tr = this.builder.getTableRow(r);
            if (tr == null) {
                ++this.nullFieldCounter;
                continue;
            }
            this.flushNullRows(util, appendable);
            tr.appendXMLToTable(util, appendable);
            this.atLeastOneRow = true;
            this.nullFieldCounter = 0;
        }
    }

    private void appendRowsWithHeaderRows(XMLUtil util, Appendable appendable, int firstRowIndex, int headerRowsCount) throws IOException {
        int size = this.builder.getTableRowsUsedSize();
        if (firstRowIndex == 0) {
            this.nullFieldCounter = 0;
        }
        for (int r = firstRowIndex; r < size; ++r) {
            TableRowImpl tr = this.builder.getTableRow(r);
            if (r == headerRowsCount) {
                this.flushNullRows(util, appendable);
                appendable.append("</table:table-header-rows>");
                if (tr == null) {
                    this.nullFieldCounter = 1;
                } else {
                    tr.appendXMLToTable(util, appendable);
                    this.nullFieldCounter = 0;
                }
                this.atLeastOneRow = true;
                continue;
            }
            if (tr == null) {
                ++this.nullFieldCounter;
                continue;
            }
            this.flushNullRows(util, appendable);
            tr.appendXMLToTable(util, appendable);
            this.atLeastOneRow = true;
            this.nullFieldCounter = 0;
        }
    }

    private void flushNullRows(XMLUtil util, Appendable appendable) throws IOException {
        if (this.nullFieldCounter <= 0) {
            return;
        }
        appendable.append("<table:table-row");
        if (this.nullFieldCounter > 1) {
            util.appendAttribute(appendable, (CharSequence)"table:number-rows-repeated", this.nullFieldCounter);
        }
        util.appendAttribute(appendable, (CharSequence)"table:style-name", "ro1");
        appendable.append(">");
        appendable.append("<table:table-cell/>");
        appendable.append("</table:table-row>");
        this.atLeastOneRow = true;
        this.nullFieldCounter = 0;
    }

    public void appendPostamble(Appendable appendable) throws IOException {
        if (!this.atLeastOneRow) {
            appendable.append("<table:table-row><table:table-cell/></table:table-row>");
        }
        appendable.append("</table:table>");
    }

    public void appendOpenTagAndPreambleOnce(XMLUtil util, Appendable appendable) throws IOException {
        if (!this.preambleWritten) {
            this.appendOpenTagAndPreamble(util, appendable);
            this.preambleWritten = true;
        }
    }

    public void appendRemainingRowsFrom(XMLUtil util, Appendable appendable, int rowIndex) throws IOException {
        if (rowIndex == 0) {
            this.appendOpenTagAndPreamble(util, appendable);
        }
        this.appendRows(util, appendable, rowIndex);
        this.appendPostamble(appendable);
    }

    public void appendSomeAvailableRowsFrom(XMLUtil util, Appendable appendable, int rowIndex) throws IOException {
        if (rowIndex == 0) {
            this.appendOpenTagAndPreamble(util, appendable);
        }
        this.appendRows(util, appendable, rowIndex);
    }

    public void appendAllAvailableRows(XMLUtil util, Appendable appendable) throws IOException {
        this.appendOpenTagAndPreambleOnce(util, appendable);
        this.appendRows(util, appendable, 0);
    }

    public void flushRows(XMLUtil xmlUtil, ZipUTF8Writer writer, List<TableRowImpl> rows) throws IOException {
        for (TableRowImpl row : rows) {
            TableRowImpl.appendXMLToTable(row, xmlUtil, writer);
            this.atLeastOneRow = true;
        }
        Collections.fill(rows, null);
    }
}

