/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.FrameContent;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.Shape;
import com.github.jferard.fastods.TableAppender;
import com.github.jferard.fastods.TableBuilder;
import com.github.jferard.fastods.TableCellWalker;
import com.github.jferard.fastods.TableRowImpl;
import com.github.jferard.fastods.ValidationsContainer;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.odselement.ContentElement;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.odselement.config.ConfigElement;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.ref.PositionUtil;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableColumnStyle;
import com.github.jferard.fastods.style.TableStyle;
import com.github.jferard.fastods.util.AutoFilter;
import com.github.jferard.fastods.util.IntegerRepresentationCache;
import com.github.jferard.fastods.util.NamedObject;
import com.github.jferard.fastods.util.Protection;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;

public class Table
implements NamedObject,
FrameContent {
    private final ContentElement contentElement;
    private final TableBuilder builder;
    private final TableAppender appender;
    private final String name;

    public static Table create(ContentElement contentElement, PositionUtil positionUtil, IntegerRepresentationCache cache, XMLUtil xmlUtil, String name, int rowCapacity, int columnCapacity, StylesContainer stylesContainer, DataStyles format, boolean libreOfficeMode, ValidationsContainer validationsContainer) {
        positionUtil.checkTableName(name);
        TableBuilder builder = TableBuilder.create(positionUtil, cache, xmlUtil, stylesContainer, format, libreOfficeMode, name, rowCapacity, columnCapacity, validationsContainer);
        return new Table(name, contentElement, builder, new TableAppender(builder));
    }

    Table(String name, ContentElement contentElement, TableBuilder builder, TableAppender tableAppender) {
        this.name = name;
        this.contentElement = contentElement;
        this.builder = builder;
        this.appender = tableAppender;
    }

    public void addObserver(NamedOdsFileWriter observer) {
        this.builder.addObserver(observer);
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        this.appender.appendXMLToContentEntry(util, appendable);
    }

    @Deprecated
    public void asyncFlush() throws IOException {
        this.builder.asyncFlushBeginTable(this.appender);
        this.builder.asyncFlushEndTable(this.appender);
    }

    public void asyncFlushBeginTable() throws IOException {
        this.builder.asyncFlushBeginTable(this.appender);
    }

    public void asyncFlushEndTable() throws IOException {
        this.builder.asyncFlushEndTable(this.appender);
    }

    public void flushAllAvailableRows(XMLUtil util, Appendable appendable) throws IOException {
        this.appender.appendAllAvailableRows(util, appendable);
    }

    public void flushRemainingRowsFrom(XMLUtil util, Appendable appendable, int rowIndex) throws IOException {
        this.appender.appendRemainingRowsFrom(util, appendable, rowIndex);
    }

    public void flushSomeAvailableRowsFrom(XMLUtil util, Appendable appendable, int rowIndex) throws IOException {
        this.appender.appendSomeAvailableRowsFrom(util, appendable, rowIndex);
    }

    public ConfigItemMapEntry getConfigEntry() {
        return this.builder.getConfigEntry();
    }

    public int getRowCount() {
        return this.builder.getRowCount();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TableRowImpl getRow(int rowIndex) throws IOException {
        return this.builder.getRow(this, this.appender, rowIndex);
    }

    public String getStyleName() {
        return this.builder.getStyleName();
    }

    @Deprecated
    public TableRowImpl nextRow() throws IOException {
        return this.builder.nextRow(this, this.appender);
    }

    public TableCellWalker getWalker() throws IOException {
        return new TableCellWalker(this);
    }

    public void setCellMerge(int rowIndex, int colIndex, int rowMerge, int columnMerge) throws IOException {
        this.builder.setCellMerge(this, this.appender, rowIndex, colIndex, rowMerge, columnMerge);
    }

    @Deprecated
    public void setCellMerge(String address, int rowMerge, int columnMerge) throws IOException, ParseException {
        this.builder.setCellMerge(this, this.appender, address, rowMerge, columnMerge);
    }

    public void setColumnStyle(int col, TableColumnStyle ts) {
        this.builder.setColumnStyle(col, ts);
    }

    public void setColumnAttribute(int col, String attribute, CharSequence value) {
        this.builder.setColumnAttribute(col, attribute, value);
    }

    public void setColumnDefaultCellStyle(int col, TableCellStyle cellStyle) {
        this.builder.setColumnDefaultCellStyle(col, cellStyle);
    }

    public void setAttribute(String attribute, CharSequence value) {
        this.builder.setAttribute(attribute, value);
    }

    public void setConfigItem(String name, String type, String value) {
        this.builder.setConfigItem(name, type, value);
    }

    public void updateConfigItem(ConfigElement element, String value) {
        this.builder.updateConfigItem(element.getName(), value);
    }

    public void setStyle(TableStyle style) {
        this.builder.setStyle(style);
    }

    public void setRowsSpanned(int rowIndex, int colIndex, int n) throws IOException {
        this.builder.setRowsSpanned(this, this.appender, rowIndex, colIndex, n);
    }

    public TableCellStyle findDefaultCellStyle(int columnIndex) {
        return this.builder.findDefaultCellStyle(columnIndex);
    }

    public void addAutoFilter(String rangeName, int r1, int c1, int r2, int c2) {
        this.contentElement.addAutoFilter(AutoFilter.builder(rangeName, this, r1, c1, r2, c2).build());
    }

    public void addShape(Shape shape) {
        this.builder.addShape(shape);
    }

    public void protect(Protection protection) throws NoSuchAlgorithmException {
        this.builder.protect(protection);
    }

    public void addPrintRange(int r1, int c1, int r2, int c2) {
        this.builder.addPrintRange(r1, c1, r2, c2);
    }

    public void setHeaderRowsCount(int headerRowsCount) {
        this.builder.setHeaderRowsCount(headerRowsCount);
    }

    public void setHeaderColumnsCount(int headerColumnsCount) {
        this.builder.setHeaderColumnsCount(headerColumnsCount);
    }
}

