/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.ParagraphBuilder;
import com.github.jferard.fastods.ParagraphElement;
import com.github.jferard.fastods.TagParameters;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.TextStyle;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.List;

public class Paragraph
implements TagParameters,
ParagraphElement {
    private final List<ParagraphElement> paragraphElements;
    private final TextStyle style;

    public static ParagraphBuilder builder() {
        return new ParagraphBuilder();
    }

    Paragraph(List<ParagraphElement> paragraphElements, TextStyle style) {
        this.paragraphElements = paragraphElements;
        this.style = style;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        if (this.paragraphElements.isEmpty()) {
            appendable.append("<text:p/>");
        } else {
            appendable.append("<text:p");
            if (this.style != null) {
                util.appendEAttribute(appendable, "text:style-name", this.style.getName());
            }
            appendable.append('>');
            for (ParagraphElement paragraphElement : this.paragraphElements) {
                paragraphElement.appendXMLContent(util, appendable);
            }
            appendable.append("</text:p>");
        }
    }

    @Override
    public void addEmbeddedStylesFromFooterHeader(StylesContainer stylesContainer) {
        if (this.style != null) {
            stylesContainer.addStylesFontFaceContainerStyle(this.style);
        }
        for (ParagraphElement element : this.paragraphElements) {
            element.addEmbeddedStylesFromFooterHeader(stylesContainer);
        }
    }

    @Override
    public void addEmbeddedStylesFromCell(StylesContainer stylesContainer) {
        if (this.style != null) {
            stylesContainer.addContentFontFaceContainerStyle(this.style);
        }
        for (ParagraphElement element : this.paragraphElements) {
            element.addEmbeddedStylesFromCell(stylesContainer);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Paragraph)) {
            return false;
        }
        Paragraph other = (Paragraph)o;
        return this.paragraphElements.equals(other.paragraphElements);
    }

    public final int hashCode() {
        return this.paragraphElements.hashCode();
    }
}

