/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.text.TextUtils;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.king.logx.LogX;
import com.king.zxing.DecodeFormatManager;
import java.util.HashMap;
import java.util.Map;

public final class CodeUtils {
    public static final int DEFAULT_REQ_WIDTH = 480;
    public static final int DEFAULT_REQ_HEIGHT = 640;

    private CodeUtils() {
        throw new AssertionError();
    }

    public static Bitmap createQRCode(@NonNull String content, int size) {
        return CodeUtils.createQRCode(content, size, null);
    }

    public static Bitmap createQRCode(@NonNull String content, int size, @ColorInt int codeColor) {
        return CodeUtils.createQRCode(content, size, null, codeColor);
    }

    public static Bitmap createQRCode(@NonNull String content, int size, @Nullable Bitmap logo) {
        return CodeUtils.createQRCode(content, size, logo, -16777216);
    }

    public static Bitmap createQRCode(@NonNull String content, int size, @Nullable Bitmap logo, @ColorInt int codeColor) {
        return CodeUtils.createQRCode(content, size, logo, 0.2f, codeColor);
    }

    public static Bitmap createQRCode(@NonNull String content, int size, @Nullable Bitmap logo, @FloatRange(from=0.0, to=1.0) float ratio) {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.MARGIN, 1);
        return CodeUtils.createQRCode(content, size, logo, ratio, hints);
    }

    public static Bitmap createQRCode(@NonNull String content, int size, @Nullable Bitmap logo, @FloatRange(from=0.0, to=1.0) float ratio, @ColorInt int codeColor) {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.MARGIN, 1);
        return CodeUtils.createQRCode(content, size, logo, ratio, hints, codeColor);
    }

    public static Bitmap createQRCode(@NonNull String content, int size, @Nullable Bitmap logo, @FloatRange(from=0.0, to=1.0) float ratio, @Nullable Map<EncodeHintType, ?> hints) {
        return CodeUtils.createQRCode(content, size, logo, ratio, hints, -16777216);
    }

    public static Bitmap createQRCode(@NonNull String content, int size, @Nullable Bitmap logo, @FloatRange(from=0.0, to=1.0) float ratio, @Nullable Map<EncodeHintType, ?> hints, @ColorInt int codeColor) {
        try {
            BitMatrix bitMatrix = new QRCodeWriter().encode(content, BarcodeFormat.QR_CODE, size, size, hints);
            int[] pixels = new int[size * size];
            for (int y = 0; y < size; ++y) {
                for (int x = 0; x < size; ++x) {
                    pixels[y * size + x] = bitMatrix.get(x, y) ? codeColor : -1;
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, size, 0, 0, size, size);
            if (logo != null) {
                bitmap = CodeUtils.addLogo(bitmap, logo, ratio);
            }
            return bitmap;
        }
        catch (Exception e) {
            LogX.w((Throwable)e);
            return null;
        }
    }

    private static Bitmap addLogo(@Nullable Bitmap src, @Nullable Bitmap logo, @FloatRange(from=0.0, to=1.0) float ratio) {
        Bitmap bitmap;
        if (src == null) {
            return null;
        }
        if (logo == null) {
            return src;
        }
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int logoWidth = logo.getWidth();
        int logoHeight = logo.getHeight();
        if (srcWidth == 0 || srcHeight == 0) {
            return null;
        }
        if (logoWidth == 0 || logoHeight == 0) {
            return src;
        }
        float scaleFactor = (float)srcWidth * ratio / (float)logoWidth;
        try {
            bitmap = Bitmap.createBitmap((int)srcWidth, (int)srcHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawBitmap(src, 0.0f, 0.0f, null);
            canvas.scale(scaleFactor, scaleFactor, (float)srcWidth / 2.0f, (float)srcHeight / 2.0f);
            canvas.drawBitmap(logo, (float)(srcWidth - logoWidth) / 2.0f, (float)(srcHeight - logoHeight) / 2.0f, null);
            canvas.save();
            canvas.restore();
        }
        catch (Exception e) {
            bitmap = null;
            LogX.w((Throwable)e);
        }
        return bitmap;
    }

    @Nullable
    public static String parseQRCode(@NonNull String bitmapPath) {
        Result result = CodeUtils.parseQRCodeResult(bitmapPath);
        if (result != null) {
            return result.getText();
        }
        return null;
    }

    @Nullable
    public static Result parseQRCodeResult(@NonNull String bitmapPath) {
        return CodeUtils.parseQRCodeResult(bitmapPath, 480, 640);
    }

    @Nullable
    public static Result parseQRCodeResult(@NonNull String bitmapPath, int reqWidth, int reqHeight) {
        return CodeUtils.parseCodeResult(bitmapPath, reqWidth, reqHeight, DecodeFormatManager.QR_CODE_HINTS);
    }

    @Nullable
    public static String parseCode(@NonNull String bitmapPath) {
        return CodeUtils.parseCode(bitmapPath, DecodeFormatManager.ALL_HINTS);
    }

    @Nullable
    public static String parseCode(@NonNull String bitmapPath, @Nullable Map<DecodeHintType, Object> hints) {
        Result result = CodeUtils.parseCodeResult(bitmapPath, hints);
        if (result != null) {
            return result.getText();
        }
        return null;
    }

    @Nullable
    public static String parseQRCode(@NonNull Bitmap bitmap) {
        return CodeUtils.parseCode(bitmap, DecodeFormatManager.QR_CODE_HINTS);
    }

    @Nullable
    public static String parseCode(@NonNull Bitmap bitmap) {
        return CodeUtils.parseCode(bitmap, DecodeFormatManager.ALL_HINTS);
    }

    @Nullable
    public static String parseCode(@NonNull Bitmap bitmap, @Nullable Map<DecodeHintType, Object> hints) {
        Result result = CodeUtils.parseCodeResult(bitmap, hints);
        if (result != null) {
            return result.getText();
        }
        return null;
    }

    @Nullable
    public static Result parseCodeResult(@NonNull String bitmapPath, @Nullable Map<DecodeHintType, Object> hints) {
        return CodeUtils.parseCodeResult(bitmapPath, 480, 640, hints);
    }

    @Nullable
    public static Result parseCodeResult(@NonNull String bitmapPath, int reqWidth, int reqHeight, @Nullable Map<DecodeHintType, Object> hints) {
        return CodeUtils.parseCodeResult(CodeUtils.compressBitmap(bitmapPath, reqWidth, reqHeight), hints);
    }

    @Nullable
    public static Result parseCodeResult(@NonNull Bitmap bitmap) {
        return CodeUtils.parseCodeResult((LuminanceSource)CodeUtils.getRGBLuminanceSource(bitmap), DecodeFormatManager.ALL_HINTS);
    }

    @Nullable
    public static Result parseCodeResult(@NonNull Bitmap bitmap, @Nullable Map<DecodeHintType, Object> hints) {
        return CodeUtils.parseCodeResult((LuminanceSource)CodeUtils.getRGBLuminanceSource(bitmap), hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Result parseCodeResult(LuminanceSource source, @Nullable Map<DecodeHintType, Object> hints) {
        Result result = null;
        MultiFormatReader reader = new MultiFormatReader();
        try {
            reader.setHints(hints);
            if (source != null) {
                result = CodeUtils.decodeInternal(reader, source);
                if (result == null) {
                    result = CodeUtils.decodeInternal(reader, source.invert());
                }
                if (result == null && source.isRotateSupported()) {
                    result = CodeUtils.decodeInternal(reader, source.rotateCounterClockwise());
                }
            }
        }
        catch (Exception e) {
            LogX.w((Throwable)e);
        }
        finally {
            reader.reset();
        }
        return result;
    }

    @Nullable
    private static Result decodeInternal(MultiFormatReader reader, LuminanceSource source) {
        Result result = null;
        try {
            try {
                result = reader.decodeWithState(new BinaryBitmap((Binarizer)new HybridBinarizer(source)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                result = reader.decodeWithState(new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer(source)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static Bitmap compressBitmap(@NonNull String path, int reqWidth, int reqHeight) {
        if (reqWidth > 0 && reqHeight > 0) {
            BitmapFactory.Options newOpts = new BitmapFactory.Options();
            newOpts.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)newOpts);
            newOpts.inSampleSize = CodeUtils.getSampleSize(reqWidth, reqHeight, newOpts);
            newOpts.inJustDecodeBounds = false;
            return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)newOpts);
        }
        return BitmapFactory.decodeFile((String)path);
    }

    private static int getSampleSize(int reqWidth, int reqHeight, @NonNull BitmapFactory.Options newOpts) {
        int size;
        float width = newOpts.outWidth;
        float height = newOpts.outHeight;
        int wSize = 1;
        if (width > (float)reqWidth) {
            wSize = (int)(width / (float)reqWidth);
        }
        int hSize = 1;
        if (height > (float)reqHeight) {
            hSize = (int)(height / (float)reqHeight);
        }
        if ((size = Math.max(wSize, hSize)) <= 0) {
            size = 1;
        }
        return size;
    }

    private static RGBLuminanceSource getRGBLuminanceSource(@NonNull Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        return new RGBLuminanceSource(width, height, pixels);
    }

    public static Bitmap createBarCode(@NonNull String content, int desiredWidth, int desiredHeight) {
        return CodeUtils.createBarCode(content, BarcodeFormat.CODE_128, desiredWidth, desiredHeight, null);
    }

    public static Bitmap createBarCode(@NonNull String content, @NonNull BarcodeFormat format, int desiredWidth, int desiredHeight) {
        return CodeUtils.createBarCode(content, format, desiredWidth, desiredHeight, null);
    }

    public static Bitmap createBarCode(@NonNull String content, int desiredWidth, int desiredHeight, boolean isShowText) {
        return CodeUtils.createBarCode(content, BarcodeFormat.CODE_128, desiredWidth, desiredHeight, null, isShowText, 40, -16777216);
    }

    public static Bitmap createBarCode(@NonNull String content, int desiredWidth, int desiredHeight, boolean isShowText, @ColorInt int codeColor) {
        return CodeUtils.createBarCode(content, BarcodeFormat.CODE_128, desiredWidth, desiredHeight, null, isShowText, 40, codeColor);
    }

    public static Bitmap createBarCode(@NonNull String content, @NonNull BarcodeFormat format, int desiredWidth, int desiredHeight, @Nullable Map<EncodeHintType, ?> hints) {
        return CodeUtils.createBarCode(content, format, desiredWidth, desiredHeight, hints, false, 40, -16777216);
    }

    public static Bitmap createBarCode(@NonNull String content, @NonNull BarcodeFormat format, int desiredWidth, int desiredHeight, @Nullable Map<EncodeHintType, ?> hints, boolean isShowText) {
        return CodeUtils.createBarCode(content, format, desiredWidth, desiredHeight, hints, isShowText, 40, -16777216);
    }

    public static Bitmap createBarCode(@NonNull String content, @NonNull BarcodeFormat format, int desiredWidth, int desiredHeight, boolean isShowText, @ColorInt int codeColor) {
        return CodeUtils.createBarCode(content, format, desiredWidth, desiredHeight, null, isShowText, 40, codeColor);
    }

    public static Bitmap createBarCode(@NonNull String content, @NonNull BarcodeFormat format, int desiredWidth, int desiredHeight, @Nullable Map<EncodeHintType, ?> hints, boolean isShowText, @ColorInt int codeColor) {
        return CodeUtils.createBarCode(content, format, desiredWidth, desiredHeight, hints, isShowText, 40, codeColor);
    }

    public static Bitmap createBarCode(@NonNull String content, @NonNull BarcodeFormat format, int desiredWidth, int desiredHeight, @Nullable Map<EncodeHintType, ?> hints, boolean isShowText, int textSize, @ColorInt int codeColor) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        int WHITE = -1;
        MultiFormatWriter writer = new MultiFormatWriter();
        try {
            BitMatrix result = writer.encode(content, format, desiredWidth, desiredHeight, hints);
            int width = result.getWidth();
            int height = result.getHeight();
            int[] pixels = new int[width * height];
            for (int y = 0; y < height; ++y) {
                int offset = y * width;
                for (int x = 0; x < width; ++x) {
                    pixels[offset + x] = result.get(x, y) ? codeColor : -1;
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            if (isShowText) {
                return CodeUtils.addCode(bitmap, content, textSize, codeColor, textSize / 2);
            }
            return bitmap;
        }
        catch (Exception e) {
            LogX.w((Throwable)e);
            return null;
        }
    }

    private static Bitmap addCode(@Nullable Bitmap src, @Nullable String code, int textSize, @ColorInt int textColor, int offset) {
        Bitmap bitmap;
        if (src == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)code)) {
            return src;
        }
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        if (srcWidth <= 0 || srcHeight <= 0) {
            return null;
        }
        try {
            bitmap = Bitmap.createBitmap((int)srcWidth, (int)(srcHeight + textSize + offset * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawBitmap(src, 0.0f, 0.0f, null);
            TextPaint paint = new TextPaint();
            paint.setTextSize((float)textSize);
            paint.setColor(textColor);
            paint.setTextAlign(Paint.Align.CENTER);
            canvas.drawText(code, (float)srcWidth / 2.0f, (float)srcHeight + (float)textSize / 2.0f + (float)offset, (Paint)paint);
            canvas.save();
            canvas.restore();
        }
        catch (Exception e) {
            bitmap = null;
            LogX.w((Throwable)e);
        }
        return bitmap;
    }
}

