/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing.analyze;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageProxy;
import com.google.zxing.Result;
import com.king.camera.scan.AnalyzeResult;
import com.king.camera.scan.FrameMetadata;
import com.king.camera.scan.analyze.Analyzer;
import com.king.camera.scan.util.ImageUtils;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ImageAnalyzer
implements Analyzer<Result> {
    private final Queue<byte[]> queue = new ConcurrentLinkedQueue<byte[]>();
    private final AtomicBoolean joinQueue = new AtomicBoolean(false);

    @Nullable
    public abstract Result analyze(byte[] var1, int var2, int var3);

    public void analyze(@NonNull ImageProxy imageProxy, @NonNull Analyzer.OnAnalyzeListener<Result> listener) {
        byte[] nv21Data;
        if (!this.joinQueue.get()) {
            int imageSize = imageProxy.getWidth() * imageProxy.getHeight();
            byte[] bytes = new byte[imageSize + 2 * (imageSize / 4)];
            this.queue.add(bytes);
            this.joinQueue.set(true);
        }
        if ((nv21Data = this.queue.poll()) == null) {
            return;
        }
        try {
            Result result;
            int rotation = imageProxy.getImageInfo().getRotationDegrees();
            int width = imageProxy.getWidth();
            int height = imageProxy.getHeight();
            ImageUtils.yuv_420_888toNv21((ImageProxy)imageProxy, (byte[])nv21Data);
            if (rotation == 90 || rotation == 270) {
                byte[] rotatedData = new byte[nv21Data.length];
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        rotatedData[x * height + height - y - 1] = nv21Data[x + y * width];
                    }
                }
                result = this.analyze(rotatedData, height, width);
            } else {
                result = this.analyze(nv21Data, width, height);
            }
            if (result != null) {
                FrameMetadata frameMetadata = new FrameMetadata(width, height, rotation);
                this.joinQueue.set(false);
                listener.onSuccess(new AnalyzeResult(nv21Data, 17, frameMetadata, (Object)result));
            } else {
                this.queue.add(nv21Data);
                listener.onFailure(null);
            }
        }
        catch (Exception e) {
            this.queue.add(nv21Data);
            listener.onFailure(null);
        }
    }
}

