/*
 * Decompiled with CFR 0.152.
 */
package com.king.view.arcseekbar;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.king.view.arcseekbar.R;

public class ArcSeekBar
extends View {
    private Paint mPaint;
    private TextPaint mTextPaint;
    private float mStrokeWidth;
    private Paint.Cap mStrokeCap = Paint.Cap.ROUND;
    private int mStartAngle = 270;
    private int mSweepAngle = 360;
    private float mCircleCenterX;
    private float mCircleCenterY;
    private int mNormalColor = -3618616;
    private int mProgressColor = -11539796;
    private boolean isShader = true;
    private Shader mShader;
    private int[] mShaderColors = new int[]{-11539796, -5710511, -1518833, -5710511, -11539796};
    private float mRadius;
    private float mTickPadding;
    private float mTickSplitAngle = 5.0f;
    private float mBlockAngle = 1.0f;
    private float mTickOffsetAngle = 0.0f;
    private int mTotalTickCount;
    private float mTickStrokeWidth;
    private int mMax = 100;
    private int mProgress = 0;
    private int mDuration = 500;
    private String mLabelText;
    private float mLabelTextSize;
    private int mLabelTextColor = -13421773;
    private float mLabelPaddingTop;
    private float mLabelPaddingBottom;
    private float mLabelPaddingLeft;
    private float mLabelPaddingRight;
    private int mProgressPercent;
    private boolean isShowLabel = true;
    private boolean isShowPercentText = true;
    private boolean isShowTick = false;
    private float mThumbStrokeWidth;
    private int mThumbColor = -1518833;
    private float mThumbRadius;
    private float mThumbCenterX;
    private float mThumbCenterY;
    private float mAllowableOffsets;
    private float mThumbRadiusEnlarges;
    private boolean isShowThumb = true;
    private GestureDetector mDetector;
    private boolean isCanDrag = false;
    private boolean isEnabledDrag = true;
    private boolean isEnabledSingle = true;
    private boolean isMeasureCircle = false;
    private OnChangeListener mOnChangeListener;

    public ArcSeekBar(Context context) {
        this(context, null);
    }

    public ArcSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ArcSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ArcSeekBar);
        DisplayMetrics displayMetrics = this.getDisplayMetrics();
        this.mStrokeWidth = TypedValue.applyDimension((int)1, (float)12.0f, (DisplayMetrics)displayMetrics);
        this.mLabelTextSize = TypedValue.applyDimension((int)2, (float)30.0f, (DisplayMetrics)displayMetrics);
        this.mTickPadding = TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics);
        this.mTickStrokeWidth = TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)displayMetrics);
        this.mThumbStrokeWidth = this.mThumbRadius = TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)displayMetrics);
        this.mAllowableOffsets = TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)displayMetrics);
        this.mThumbRadiusEnlarges = TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics);
        int size = a.getIndexCount();
        for (int i = 0; i < size; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.ArcSeekBar_arcStrokeWidth) {
                this.mStrokeWidth = a.getDimension(attr, this.mStrokeWidth);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcStrokeCap) {
                this.mStrokeCap = this.getStrokeCap(a.getInt(attr, 3));
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcNormalColor) {
                this.mNormalColor = a.getColor(attr, this.mNormalColor);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcProgressColor) {
                this.mProgressColor = a.getColor(attr, this.mProgressColor);
                this.isShader = false;
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcStartAngle) {
                this.mStartAngle = a.getInt(attr, this.mStartAngle);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcSweepAngle) {
                this.mSweepAngle = a.getInt(attr, this.mSweepAngle);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcMax) {
                int max = a.getInt(attr, this.mMax);
                if (max <= 0) continue;
                this.mMax = max;
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcProgress) {
                this.mProgress = a.getInt(attr, this.mProgress);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcDuration) {
                this.mDuration = a.getInt(attr, this.mDuration);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcLabelText) {
                this.mLabelText = a.getString(attr);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcLabelTextSize) {
                this.mLabelTextSize = a.getDimension(attr, this.mLabelTextSize);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcLabelTextColor) {
                this.mLabelTextColor = a.getColor(attr, this.mLabelTextColor);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcLabelPaddingTop) {
                this.mLabelPaddingTop = a.getDimension(attr, 0.0f);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcLabelPaddingBottom) {
                this.mLabelPaddingBottom = a.getDimension(attr, 0.0f);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcLabelPaddingLeft) {
                this.mLabelPaddingLeft = a.getDimension(attr, 0.0f);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcLabelPaddingRight) {
                this.mLabelPaddingRight = a.getDimension(attr, 0.0f);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcShowLabel) {
                this.isShowLabel = a.getBoolean(attr, true);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcShowTick) {
                this.isShowTick = a.getBoolean(attr, true);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcTickStrokeWidth) {
                this.mTickStrokeWidth = a.getDimension(attr, this.mTickStrokeWidth);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcTickPadding) {
                this.mTickPadding = a.getDimension(attr, this.mTickPadding);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcTickSplitAngle) {
                this.mTickSplitAngle = a.getInt(attr, 5);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcBlockAngle) {
                this.mBlockAngle = a.getInt(attr, 1);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcTickOffsetAngle) {
                this.mTickOffsetAngle = a.getInt(attr, 0);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcThumbStrokeWidth) {
                this.mThumbStrokeWidth = a.getDimension(attr, this.mThumbStrokeWidth);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcThumbColor) {
                this.mThumbColor = a.getColor(attr, this.mThumbColor);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcThumbRadius) {
                this.mThumbRadius = a.getDimension(attr, this.mThumbRadius);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcThumbRadiusEnlarges) {
                this.mThumbRadiusEnlarges = a.getDimension(attr, this.mThumbRadiusEnlarges);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcShowThumb) {
                this.isShowThumb = a.getBoolean(attr, this.isShowThumb);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcAllowableOffsets) {
                this.mAllowableOffsets = a.getDimension(attr, this.mAllowableOffsets);
                continue;
            }
            if (attr == R.styleable.ArcSeekBar_arcEnabledDrag) {
                this.isEnabledDrag = a.getBoolean(attr, true);
                continue;
            }
            if (attr != R.styleable.ArcSeekBar_arcEnabledSingle) continue;
            this.isEnabledSingle = a.getBoolean(attr, true);
        }
        this.isShowPercentText = TextUtils.isEmpty((CharSequence)this.mLabelText);
        a.recycle();
        this.mProgressPercent = (int)((float)this.mProgress * 100.0f / (float)this.mMax);
        this.mPaint = new Paint();
        this.mTextPaint = new TextPaint();
        this.mTotalTickCount = (int)((float)this.mSweepAngle / (this.mTickSplitAngle + this.mBlockAngle));
        this.mDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent event) {
                if (ArcSeekBar.this.isInArc(event.getX(), event.getY())) {
                    ArcSeekBar.this.updateDragThumb(event.getX(), event.getY(), true);
                    if (ArcSeekBar.this.mOnChangeListener != null) {
                        ArcSeekBar.this.mOnChangeListener.onSingleTapUp();
                    }
                    return true;
                }
                return super.onSingleTapUp(event);
            }
        });
    }

    private Paint.Cap getStrokeCap(int value) {
        switch (value) {
            case 1: {
                return Paint.Cap.BUTT;
            }
            case 2: {
                return Paint.Cap.SQUARE;
            }
        }
        return Paint.Cap.ROUND;
    }

    private DisplayMetrics getDisplayMetrics() {
        return this.getResources().getDisplayMetrics();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int defaultValue = (int)TypedValue.applyDimension((int)1, (float)200.0f, (DisplayMetrics)this.getDisplayMetrics());
        int width = this.measureHandler(widthMeasureSpec, defaultValue);
        int height = this.measureHandler(heightMeasureSpec, defaultValue);
        this.mCircleCenterX = (float)(width + this.getPaddingLeft() - this.getPaddingRight()) / 2.0f;
        this.mCircleCenterY = (float)(height + this.getPaddingTop() - this.getPaddingBottom()) / 2.0f;
        int padding = Math.max(this.getPaddingLeft() + this.getPaddingRight(), this.getPaddingTop() + this.getPaddingBottom());
        this.mRadius = ((float)(width - padding) - Math.max(this.mStrokeWidth, this.mThumbStrokeWidth)) / 2.0f - this.mThumbRadius;
        this.mShader = new SweepGradient(this.mCircleCenterX, this.mCircleCenterX, this.mShaderColors, null);
        this.isMeasureCircle = true;
        this.setMeasuredDimension(width, height);
    }

    private int measureHandler(int measureSpec, int defaultSize) {
        int result = defaultSize;
        int measureMode = View.MeasureSpec.getMode((int)measureSpec);
        int measureSize = View.MeasureSpec.getSize((int)measureSpec);
        if (measureMode == 0x40000000) {
            result = measureSize;
        } else if (measureMode == Integer.MIN_VALUE) {
            result = Math.min(defaultSize, measureSize);
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawArc(canvas);
        this.drawThumb(canvas);
        this.drawText(canvas);
    }

    private void drawArc(Canvas canvas) {
        this.mPaint.reset();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        if (this.isShowTick) {
            this.mPaint.setStrokeWidth(this.mTickStrokeWidth);
            float circleRadius = this.mRadius - this.mTickPadding - this.mStrokeWidth;
            float tickDiameter = circleRadius * 2.0f;
            float tickStartX = this.mCircleCenterX - circleRadius;
            float tickStartY = this.mCircleCenterY - circleRadius;
            RectF rectF = new RectF(tickStartX, tickStartY, tickStartX + tickDiameter, tickStartY + tickDiameter);
            int currentBlockIndex = (int)((float)this.mProgressPercent / 100.0f * (float)this.mTotalTickCount);
            for (int i = 0; i < this.mTotalTickCount; ++i) {
                if (i < currentBlockIndex) {
                    if (this.isShader && this.mShader != null) {
                        this.mPaint.setShader(this.mShader);
                    } else {
                        this.mPaint.setColor(this.mProgressColor);
                    }
                    canvas.drawArc(rectF, (float)i * (this.mBlockAngle + this.mTickSplitAngle) + (float)this.mStartAngle + this.mTickOffsetAngle, this.mBlockAngle, false, this.mPaint);
                    continue;
                }
                if (this.mNormalColor == 0) continue;
                this.mPaint.setShader(null);
                this.mPaint.setColor(this.mNormalColor);
                canvas.drawArc(rectF, (float)i * (this.mBlockAngle + this.mTickSplitAngle) + (float)this.mStartAngle + this.mTickOffsetAngle, this.mBlockAngle, false, this.mPaint);
            }
        }
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setShader(null);
        this.mPaint.setStrokeCap(this.mStrokeCap);
        float diameter = this.mRadius * 2.0f;
        float startX = this.mCircleCenterX - this.mRadius;
        float startY = this.mCircleCenterY - this.mRadius;
        RectF rectF1 = new RectF(startX, startY, startX + diameter, startY + diameter);
        if (this.mNormalColor != 0) {
            this.mPaint.setColor(this.mNormalColor);
            canvas.drawArc(rectF1, (float)this.mStartAngle, (float)this.mSweepAngle, false, this.mPaint);
        }
        if (this.isShader && this.mShader != null) {
            this.mPaint.setShader(this.mShader);
        } else {
            this.mPaint.setColor(this.mProgressColor);
        }
        float ratio = this.getRatio();
        if (ratio != 0.0f) {
            canvas.drawArc(rectF1, (float)this.mStartAngle, (float)this.mSweepAngle * ratio, false, this.mPaint);
        }
    }

    private void drawThumb(Canvas canvas) {
        if (this.isShowThumb) {
            this.mPaint.reset();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            this.mPaint.setStrokeWidth(this.mThumbStrokeWidth);
            this.mPaint.setColor(this.mThumbColor);
            float thumbAngle = (float)this.mStartAngle + (float)this.mSweepAngle * this.getRatio();
            this.mThumbCenterX = (float)((double)this.mCircleCenterX + (double)this.mRadius * Math.cos(Math.toRadians(thumbAngle)));
            this.mThumbCenterY = (float)((double)this.mCircleCenterY + (double)this.mRadius * Math.sin(Math.toRadians(thumbAngle)));
            if (this.isCanDrag) {
                canvas.drawCircle(this.mThumbCenterX, this.mThumbCenterY, this.mThumbRadius + this.mThumbRadiusEnlarges, this.mPaint);
            } else {
                canvas.drawCircle(this.mThumbCenterX, this.mThumbCenterY, this.mThumbRadius, this.mPaint);
            }
        }
    }

    private void drawText(Canvas canvas) {
        if (!this.isShowLabel) {
            return;
        }
        this.mTextPaint.reset();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mTextPaint.setTextSize(this.mLabelTextSize);
        this.mTextPaint.setColor(this.mLabelTextColor);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        float fontHeight = fontMetrics.bottom - fontMetrics.top;
        float textBaseX = (float)(this.getWidth() / 2) + this.mLabelPaddingLeft - this.mLabelPaddingRight;
        float textBaseY = (float)this.getHeight() - ((float)this.getHeight() - fontHeight) / 2.0f - fontMetrics.bottom + this.mLabelPaddingTop - this.mLabelPaddingBottom;
        if (this.isShowPercentText) {
            canvas.drawText(this.mProgressPercent + "%", textBaseX, textBaseY, (Paint)this.mTextPaint);
        } else if (!TextUtils.isEmpty((CharSequence)this.mLabelText)) {
            canvas.drawText(this.mLabelText, textBaseX, textBaseY, (Paint)this.mTextPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isEnabledDrag) {
            switch (event.getAction()) {
                case 0: {
                    this.checkCanDrag(event.getX(), event.getY());
                    break;
                }
                case 2: {
                    if (!this.isCanDrag) break;
                    this.updateDragThumb(event.getX(), event.getY(), false);
                    break;
                }
                case 1: 
                case 3: {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                    if (this.mOnChangeListener != null) {
                        this.mOnChangeListener.onStopTrackingTouch(this.isCanDrag);
                    }
                    this.isCanDrag = false;
                    this.invalidate();
                }
            }
        }
        if (this.isEnabledSingle) {
            this.mDetector.onTouchEvent(event);
        }
        return this.isEnabledSingle || this.isEnabledDrag || super.onTouchEvent(event);
    }

    private boolean isInArc(float x, float y) {
        float distance = this.getDistance(this.mCircleCenterX, this.mCircleCenterY, x, y);
        if (Math.abs(distance - this.mRadius) <= this.mStrokeWidth / 2.0f + this.mAllowableOffsets) {
            if (this.mSweepAngle < 360) {
                float angle = (this.getTouchDegrees(x, y) + (float)this.mStartAngle) % 360.0f;
                if (this.mStartAngle + this.mSweepAngle <= 360) {
                    return angle >= (float)this.mStartAngle && angle <= (float)(this.mStartAngle + this.mSweepAngle);
                }
                return angle >= (float)this.mStartAngle || angle <= (float)((this.mStartAngle + this.mSweepAngle) % 360);
            }
            return true;
        }
        return false;
    }

    private float getDistance(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    private void updateDragThumb(float x, float y, boolean isSingle) {
        int progress = this.getProgressForAngle(this.getTouchDegrees(x, y));
        if (!isSingle) {
            int tempProgressPercent = (int)((float)progress * 100.0f / (float)this.mMax);
            if (this.mProgressPercent < 10 && tempProgressPercent > 90) {
                progress = 0;
            } else if (this.mProgressPercent > 90 && tempProgressPercent < 10) {
                progress = this.mMax;
            }
            int progressPercent = (int)((float)progress * 100.0f / (float)this.mMax);
            if (Math.abs(progressPercent - this.mProgressPercent) > 30) {
                return;
            }
        }
        this.setProgress(progress, true);
    }

    private int getProgressForAngle(float angle) {
        int touchProgress = Math.round(1.0f * (float)this.mMax / (float)this.mSweepAngle * angle);
        return touchProgress;
    }

    private float getTouchDegrees(float x, float y) {
        float x1 = x - this.mCircleCenterX;
        float y1 = y - this.mCircleCenterY;
        float angle = (float)(Math.atan2(y1, x1) * 180.0 / Math.PI);
        angle -= (float)this.mStartAngle;
        while (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private void checkCanDrag(float x, float y) {
        float distance = this.getDistance(this.mThumbCenterX, this.mThumbCenterY, x, y);
        boolean bl = this.isCanDrag = distance <= this.mThumbRadius + this.mAllowableOffsets;
        if (this.mOnChangeListener != null) {
            this.mOnChangeListener.onStartTrackingTouch(this.isCanDrag);
        }
        this.invalidate();
    }

    public void showAppendAnimation(int progress) {
        this.showAnimation(this.mProgress, progress, this.mDuration);
    }

    public void showAnimation(int progress) {
        this.showAnimation(progress, this.mDuration);
    }

    public void showAnimation(int progress, int duration) {
        this.showAnimation(0, progress, duration);
    }

    public void showAnimation(int from, int to, int duration) {
        this.showAnimation(from, to, duration, null);
    }

    public void showAnimation(int from, int to, int duration, Animator.AnimatorListener listener) {
        this.mDuration = duration;
        this.mProgress = from;
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{from, to});
        valueAnimator.setDuration((long)duration);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ArcSeekBar.this.setProgress((Integer)animation.getAnimatedValue());
            }
        });
        if (listener != null) {
            valueAnimator.removeAllUpdateListeners();
            valueAnimator.addListener(listener);
        }
        valueAnimator.start();
    }

    private float getRatio() {
        return (float)this.mProgress * 1.0f / (float)this.mMax;
    }

    public void setMax(int max) {
        if (max > 0) {
            this.mMax = max;
            this.invalidate();
        }
    }

    public void setProgress(int progress) {
        this.setProgress(progress, false);
    }

    private void setProgress(int progress, boolean fromUser) {
        if (progress < 0) {
            progress = 0;
        } else if (progress > this.mMax) {
            progress = this.mMax;
        }
        this.mProgress = progress;
        this.mProgressPercent = (int)((float)this.mProgress * 100.0f / (float)this.mMax);
        this.invalidate();
        if (this.mOnChangeListener != null) {
            this.mOnChangeListener.onProgressChanged(this.mProgress, this.mMax, fromUser);
        }
    }

    public void setNormalColor(int color) {
        this.mNormalColor = color;
        this.invalidate();
    }

    public void setShader(Shader shader) {
        this.isShader = true;
        this.mShader = shader;
        this.invalidate();
    }

    public void setProgressColor(int ... colors) {
        if (this.isMeasureCircle) {
            SweepGradient shader = new SweepGradient(this.mCircleCenterX, this.mCircleCenterX, colors, null);
            this.setShader((Shader)shader);
        } else {
            this.mShaderColors = colors;
            this.isShader = true;
        }
    }

    public void setProgressColor(int color) {
        this.isShader = false;
        this.mProgressColor = color;
        this.invalidate();
    }

    public void setProgressColorResource(int resId) {
        int color = this.getResources().getColor(resId);
        this.setProgressColor(color);
    }

    public void setShowTick(boolean isShowTick) {
        this.isShowTick = isShowTick;
        this.invalidate();
    }

    public int getStartAngle() {
        return this.mStartAngle;
    }

    public int getSweepAngle() {
        return this.mSweepAngle;
    }

    public float getCircleCenterX() {
        return this.mCircleCenterX;
    }

    public float getCircleCenterY() {
        return this.mCircleCenterY;
    }

    public float getRadius() {
        return this.mRadius;
    }

    public int getMax() {
        return this.mMax;
    }

    public int getProgress() {
        return this.mProgress;
    }

    public String getLabelText() {
        return this.mLabelText;
    }

    public float getThumbRadius() {
        return this.mThumbRadius;
    }

    public float getThumbCenterX() {
        return this.mThumbCenterX;
    }

    public float getThumbCenterY() {
        return this.mThumbCenterY;
    }

    public float getAllowableOffsets() {
        return this.mAllowableOffsets;
    }

    public boolean isEnabledDrag() {
        return this.isEnabledDrag;
    }

    public boolean isEnabledSingle() {
        return this.isEnabledSingle;
    }

    public boolean isShowPercentText() {
        return this.isShowPercentText;
    }

    public boolean isShowTick() {
        return this.isShowTick;
    }

    public boolean isShowThumb() {
        return this.isShowThumb;
    }

    public float getThumbRadiusEnlarges() {
        return this.mThumbRadiusEnlarges;
    }

    public void setThumbRadiusEnlarges(float thumbRadiusEnlarges) {
        this.mThumbRadiusEnlarges = thumbRadiusEnlarges;
    }

    public void setShowPercentText(boolean showPercentText) {
        this.isShowPercentText = showPercentText;
        this.invalidate();
    }

    public void setShowThumb(boolean showThumb) {
        this.isShowThumb = showThumb;
        this.invalidate();
    }

    public void setAllowableOffsets(float allowableOffsets) {
        this.mAllowableOffsets = allowableOffsets;
    }

    public void setEnabledDrag(boolean enabledDrag) {
        this.isEnabledDrag = enabledDrag;
    }

    public void setEnabledSingle(boolean enabledSingle) {
        this.isEnabledSingle = enabledSingle;
    }

    public void setLabelPadding(float left, float top, float right, float bottom) {
        this.mLabelPaddingLeft = left;
        this.mLabelPaddingTop = top;
        this.mLabelPaddingRight = right;
        this.mLabelPaddingBottom = bottom;
        this.invalidate();
    }

    public void setLabelText(String labelText) {
        this.mLabelText = labelText;
        this.isShowPercentText = TextUtils.isEmpty((CharSequence)labelText);
        this.invalidate();
    }

    public int getProgressPercent() {
        return this.mProgressPercent;
    }

    public String getText() {
        if (this.isShowPercentText) {
            return this.mProgressPercent + "%";
        }
        return this.mLabelText;
    }

    public int getLabelTextColor() {
        return this.mLabelTextColor;
    }

    public void setLabelTextColor(int color) {
        this.mLabelTextColor = color;
        this.invalidate();
    }

    public void setLabelTextColorResource(int resId) {
        int color = this.getResources().getColor(resId);
        this.setLabelTextColor(color);
    }

    public void setLabelTextSize(float textSize) {
        this.setLabelTextSize(2, textSize);
    }

    public void setLabelTextSize(int unit, float textSize) {
        float size = TypedValue.applyDimension((int)unit, (float)textSize, (DisplayMetrics)this.getDisplayMetrics());
        if (this.mLabelTextSize != size) {
            this.mLabelTextSize = size;
            this.invalidate();
        }
    }

    public void setOnChangeListener(OnChangeListener onChangeListener) {
        this.mOnChangeListener = onChangeListener;
    }

    public abstract class OnSimpleChangeListener
    implements OnChangeListener {
        @Override
        public void onStartTrackingTouch(boolean isCanDrag) {
        }

        @Override
        public void onStopTrackingTouch(boolean isCanDrag) {
        }

        @Override
        public void onSingleTapUp() {
        }
    }

    public static interface OnChangeListener {
        public void onStartTrackingTouch(boolean var1);

        public void onProgressChanged(float var1, float var2, boolean var3);

        public void onStopTrackingTouch(boolean var1);

        public void onSingleTapUp();
    }
}

