/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.util;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import androidx.annotation.DrawableRes;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.king.app.updater.UpdateConfig;
import com.king.app.updater.service.DownloadService;
import com.king.app.updater.util.AppUtils;
import java.io.File;

public class NotificationUtils {
    private NotificationUtils() {
        throw new AssertionError();
    }

    public static void showStartNotification(Context context, int notifyId, String channelId, String channelName, @DrawableRes int smallIcon, CharSequence title, CharSequence content, boolean isVibrate, boolean isSound, boolean isSupportCancelDownload) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationUtils.createNotificationChannel(context, channelId, channelName, isVibrate, isSound);
        }
        NotificationCompat.Builder builder = NotificationUtils.buildNotification(context, channelId, smallIcon, title, content);
        builder.setPriority(0);
        if (isVibrate && isSound) {
            builder.setDefaults(3);
        } else if (isVibrate) {
            builder.setDefaults(2);
        } else if (isSound) {
            builder.setDefaults(1);
        }
        if (isSupportCancelDownload) {
            Intent intent = new Intent(context, DownloadService.class);
            intent.putExtra("stop_download_service", true);
            PendingIntent deleteIntent = PendingIntent.getService((Context)context, (int)notifyId, (Intent)intent, (int)NotificationUtils.getPendingIntentFlags(0x10000000));
            builder.setDeleteIntent(deleteIntent);
        }
        Notification notification = builder.build();
        notification.flags = isSupportCancelDownload ? 8 : 40;
        NotificationUtils.notifyNotification(context, notifyId, notification);
    }

    public static void showProgressNotification(Context context, int notifyId, String channelId, @DrawableRes int smallIcon, CharSequence title, CharSequence content, int progress, int size, boolean isSupportCancelDownload) {
        NotificationCompat.Builder builder = NotificationUtils.buildNotification(context, channelId, smallIcon, title, content, progress, size);
        if (isSupportCancelDownload) {
            Intent intent = new Intent(context, DownloadService.class);
            intent.putExtra("stop_download_service", true);
            PendingIntent deleteIntent = PendingIntent.getService((Context)context, (int)notifyId, (Intent)intent, (int)NotificationUtils.getPendingIntentFlags(0x10000000));
            builder.setDeleteIntent(deleteIntent);
        }
        Notification notification = builder.build();
        notification.flags = isSupportCancelDownload ? 8 : 40;
        NotificationUtils.notifyNotification(context, notifyId, notification);
    }

    public static void showFinishNotification(Context context, int notifyId, String channelId, @DrawableRes int smallIcon, CharSequence title, CharSequence content, File file, String authority) {
        NotificationUtils.cancelNotification(context, notifyId);
        NotificationCompat.Builder builder = NotificationUtils.buildNotification(context, channelId, smallIcon, title, content);
        builder.setAutoCancel(true);
        Intent intent = AppUtils.getInstallIntent(context, file, authority);
        PendingIntent clickIntent = PendingIntent.getActivity((Context)context, (int)notifyId, (Intent)intent, (int)NotificationUtils.getPendingIntentFlags(0x8000000));
        builder.setContentIntent(clickIntent);
        Notification notification = builder.build();
        notification.flags = 16;
        NotificationUtils.notifyNotification(context, notifyId, notification);
    }

    public static void showErrorNotification(Context context, int notifyId, String channelId, @DrawableRes int smallIcon, CharSequence title, CharSequence content, boolean isReDownload, UpdateConfig config) {
        NotificationCompat.Builder builder = NotificationUtils.buildNotification(context, channelId, smallIcon, title, content);
        builder.setAutoCancel(true);
        int flag = NotificationUtils.getPendingIntentFlags(0x8000000);
        if (isReDownload) {
            Intent intent = new Intent(context, DownloadService.class);
            intent.putExtra("app_update_re_download", true);
            intent.putExtra("app_update_config", (Parcelable)config);
            PendingIntent clickIntent = PendingIntent.getService((Context)context, (int)notifyId, (Intent)intent, (int)flag);
            builder.setContentIntent(clickIntent);
        } else {
            PendingIntent clickIntent = PendingIntent.getService((Context)context, (int)notifyId, (Intent)new Intent(), (int)flag);
            builder.setContentIntent(clickIntent);
        }
        Notification notification = builder.build();
        notification.flags = 16;
        NotificationUtils.notifyNotification(context, notifyId, notification);
    }

    public static void showNotification(Context context, int notifyId, String channelId, @DrawableRes int smallIcon, CharSequence title, CharSequence content, boolean isAutoCancel) {
        NotificationCompat.Builder builder = NotificationUtils.buildNotification(context, channelId, smallIcon, title, content);
        builder.setAutoCancel(isAutoCancel);
        Notification notification = builder.build();
        notification.flags = 16;
        NotificationUtils.notifyNotification(context, notifyId, notification);
    }

    public static void cancelNotification(Context context, int notifyId) {
        NotificationUtils.getNotificationManager(context).cancel(notifyId);
    }

    public static NotificationManagerCompat getNotificationManager(Context context) {
        return NotificationManagerCompat.from((Context)context);
    }

    @RequiresApi(api=26)
    public static void createNotificationChannel(Context context, String channelId, String channelName, boolean isVibrate, boolean isSound) {
        NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelName, 4);
        channel.setShowBadge(true);
        channel.enableVibration(isVibrate);
        if (!isSound) {
            channel.setSound(null, null);
        }
        NotificationUtils.getNotificationManager(context).createNotificationChannel(channel);
    }

    private static NotificationCompat.Builder buildNotification(Context context, String channelId, @DrawableRes int smallIcon, CharSequence title, CharSequence content) {
        return NotificationUtils.buildNotification(context, channelId, smallIcon, title, content, -1, -1);
    }

    private static NotificationCompat.Builder buildNotification(Context context, String channelId, @DrawableRes int smallIcon, CharSequence title, CharSequence content, int progress, int size) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, channelId);
        builder.setSmallIcon(smallIcon);
        builder.setContentTitle(title);
        builder.setContentText(content);
        builder.setOngoing(true);
        if (progress != -1) {
            builder.setProgress(size, progress, size <= 0);
        }
        return builder;
    }

    private static void notifyNotification(Context context, int id, Notification notification) {
        NotificationUtils.getNotificationManager(context).notify(id, notification);
    }

    private static int getPendingIntentFlags(int flag) {
        if (Build.VERSION.SDK_INT >= 23) {
            return flag | 0x4000000;
        }
        return flag;
    }
}

