/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.core.content.pm.PackageInfoCompat;
import com.king.app.updater.util.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Locale;

public final class AppUtils {
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private AppUtils() {
        throw new AssertionError();
    }

    public static String getAppFullName(Context context, String url, String defaultName) {
        String apkName;
        if (url.endsWith(".apk") && (apkName = url.substring(url.lastIndexOf("/") + 1)).length() <= 64) {
            return apkName;
        }
        String filename = AppUtils.getAppName(context);
        LogUtils.d("AppName: " + filename);
        if (TextUtils.isEmpty((CharSequence)filename)) {
            filename = defaultName;
        }
        if (filename.endsWith(".apk")) {
            return filename;
        }
        return String.format("%s.apk", filename);
    }

    public static PackageInfo getPackageInfo(Context context) throws PackageManager.NameNotFoundException {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
        return packageInfo;
    }

    public static PackageInfo getPackageInfo(Context context, String archiveFilePath) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = packageManager.getPackageArchiveInfo(archiveFilePath, 1);
        return packageInfo;
    }

    public static String getAppName(Context context) {
        try {
            int labelRes = AppUtils.getPackageInfo((Context)context).applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getAppIcon(Context context) {
        try {
            return AppUtils.getPackageInfo((Context)context).applicationInfo.icon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void installApk(Context context, File file, String authority) {
        Intent intent = AppUtils.getInstallIntent(context, file, authority);
        context.startActivity(intent);
    }

    public static Intent getInstallIntent(Context context, File file, String authority) {
        Uri uriData;
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        intent.addCategory("android.intent.category.DEFAULT");
        String type = "application/vnd.android.package-archive";
        if (Build.VERSION.SDK_INT >= 24) {
            intent.addFlags(1);
            uriData = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
        } else {
            uriData = Uri.fromFile((File)file);
        }
        intent.setDataAndType(uriData, type);
        return intent;
    }

    public static boolean apkExists(Context context, long versionCode, File file) {
        if (file != null && file.exists()) {
            String packageName = context.getPackageName();
            PackageInfo packageInfo = AppUtils.getPackageInfo(context, file.getAbsolutePath());
            if (packageInfo != null) {
                ApplicationInfo applicationInfo;
                long apkVersionCode = PackageInfoCompat.getLongVersionCode((PackageInfo)packageInfo);
                LogUtils.d(String.format(Locale.getDefault(), "ApkVersionCode: %d", apkVersionCode));
                if (versionCode == apkVersionCode && (applicationInfo = packageInfo.applicationInfo) != null && packageName.equals(applicationInfo.packageName)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isAndroidQFileExists(Context context, String path) {
        return AppUtils.isAndroidQFileExists(context, new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAndroidQFileExists(Context context, File file) {
        boolean bl;
        AssetFileDescriptor descriptor;
        block5: {
            descriptor = null;
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = Uri.fromFile((File)file);
            descriptor = contentResolver.openAssetFileDescriptor(uri, "r");
            if (descriptor != null) break block5;
            boolean bl2 = false;
            AppUtils.close(descriptor);
            return bl2;
        }
        try {
            AppUtils.close(descriptor);
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                LogUtils.w(e.getMessage());
            }
            catch (Throwable throwable) {
                AppUtils.close(descriptor);
                throw throwable;
            }
            AppUtils.close(descriptor);
            return false;
        }
        AppUtils.close(descriptor);
        return bl;
    }

    public static boolean verifyFileMD5(File file, String md5) {
        String fileMD5 = AppUtils.getFileMD5(file);
        LogUtils.d("FileMD5: " + fileMD5);
        if (!TextUtils.isEmpty((CharSequence)md5)) {
            return md5.equalsIgnoreCase(fileMD5);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5(File file) {
        FileInputStream fileInputStream = null;
        try {
            int length;
            fileInputStream = new FileInputStream(file);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((length = fileInputStream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, length);
            }
            String string2 = AppUtils.byteArrayToHexString(messageDigest.digest());
            return string2;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string3 = null;
            return string3;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String byteArrayToHexString(byte[] bytes) {
        String hexString = null;
        if (bytes != null) {
            int length = bytes.length;
            StringBuilder out = new StringBuilder(length * 2);
            for (int x = 0; x < length; ++x) {
                int nybble = bytes[x] & 0xF0;
                out.append(hexChars[nybble >>>= 4]);
                out.append(hexChars[bytes[x] & 0xF]);
            }
            hexString = out.toString();
        }
        return hexString;
    }

    public static String getFileProviderAuthority(Context context) {
        return context.getPackageName() + ".AppUpdaterFileProvider";
    }

    private static void close(AssetFileDescriptor descriptor) {
        if (descriptor != null) {
            try {
                descriptor.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean deleteFile(File file) {
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (f.isFile()) {
                    f.delete();
                    continue;
                }
                if (!f.isDirectory()) continue;
                AppUtils.deleteFile(f);
            }
            return file.delete();
        }
        return false;
    }

    public static String getApkCacheFilesDir(Context context) {
        File[] files = ContextCompat.getExternalFilesDirs((Context)context, (String)"apk");
        if (files != null && files.length > 0) {
            return files[0].getAbsolutePath();
        }
        return new File(context.getFilesDir(), "apk").getAbsolutePath();
    }
}

