/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.king.app.updater.R;
import com.king.app.updater.UpdateConfig;
import com.king.app.updater.callback.UpdateCallback;
import com.king.app.updater.http.HttpManager;
import com.king.app.updater.http.IHttpManager;
import com.king.app.updater.notify.INotification;
import com.king.app.updater.notify.NotificationImpl;
import com.king.app.updater.util.AppUtils;
import com.king.app.updater.util.LogUtils;
import java.io.File;
import java.util.Locale;

public class DownloadService
extends Service {
    private DownloadBinder mDownloadBinder = new DownloadBinder();
    private boolean isDownloading;
    private int mCount = 0;
    private IHttpManager mHttpManager;
    private UpdateCallback mUpdateCallback;
    private INotification mNotification;
    private File mApkFile;

    private Context getContext() {
        return this;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            boolean isStop = intent.getBooleanExtra("stop_download_service", false);
            if (isStop) {
                this.stopDownload();
            } else if (!this.isDownloading) {
                boolean isReDownload = intent.getBooleanExtra("app_update_re_download", false);
                if (isReDownload) {
                    ++this.mCount;
                }
                UpdateConfig config = (UpdateConfig)intent.getParcelableExtra("app_update_config");
                this.startDownload(config);
            } else {
                LogUtils.w("Please do not repeat the download.");
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    private void startDownload(@NonNull UpdateConfig config) {
        this.startDownload(config, this.mHttpManager, this.mUpdateCallback, this.mNotification);
    }

    private void startDownload(@NonNull UpdateConfig config, @Nullable IHttpManager httpManager, @Nullable UpdateCallback callback, @Nullable INotification notification) {
        File dirFile;
        if (callback != null) {
            callback.onDownloading(this.isDownloading);
        }
        if (this.isDownloading) {
            LogUtils.w("Please do not repeat the download.");
            return;
        }
        String url = config.getUrl();
        String path = config.getPath();
        String filename = config.getFilename();
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = AppUtils.getApkCacheFilesDir(this.getContext());
        }
        if (!(dirFile = new File(path)).exists()) {
            dirFile.mkdirs();
        }
        if (TextUtils.isEmpty((CharSequence)filename)) {
            filename = AppUtils.getAppFullName(this.getContext(), url, this.getResources().getString(R.string.app_name));
        }
        this.mApkFile = new File(path, filename);
        if (this.mApkFile.exists()) {
            long versionCode = config.getVersionCode();
            String apkMD5 = config.getApkMD5();
            boolean isExistApk = false;
            if (!TextUtils.isEmpty((CharSequence)apkMD5)) {
                LogUtils.d(String.format(Locale.getDefault(), "UpdateConfig.apkMD5: %s", apkMD5));
                isExistApk = AppUtils.verifyFileMD5(this.mApkFile, apkMD5);
            } else if (versionCode > 0L) {
                LogUtils.d(String.format(Locale.getDefault(), "UpdateConfig.versionCode: %d", versionCode));
                isExistApk = AppUtils.apkExists(this.getContext(), versionCode, this.mApkFile);
            }
            if (isExistApk) {
                LogUtils.d("CacheFile: " + this.mApkFile);
                if (config.isInstallApk()) {
                    String authority = config.getAuthority();
                    if (TextUtils.isEmpty((CharSequence)authority)) {
                        authority = AppUtils.getFileProviderAuthority(this.getContext());
                    }
                    AppUtils.installApk(this.getContext(), this.mApkFile, authority);
                }
                if (callback != null) {
                    callback.onFinish(this.mApkFile);
                }
                this.stopService();
                return;
            }
            this.mApkFile.delete();
        }
        LogUtils.d("File: " + this.mApkFile);
        this.mUpdateCallback = callback;
        AppDownloadCallback downloadCallback = new AppDownloadCallback(this.getContext(), this, config, this.mApkFile, callback, this.getNotification(notification));
        this.getHttpManager(httpManager).download(url, this.mApkFile.getAbsolutePath(), config.getRequestProperty(), downloadCallback);
    }

    @NonNull
    private IHttpManager getHttpManager(@Nullable IHttpManager httpManager) {
        if (httpManager != null) {
            this.mHttpManager = httpManager;
        }
        if (this.mHttpManager == null) {
            this.mHttpManager = HttpManager.getInstance();
        }
        return this.mHttpManager;
    }

    @NonNull
    private INotification getNotification(@Nullable INotification notification) {
        if (notification != null) {
            this.mNotification = notification;
        }
        if (this.mNotification == null) {
            this.mNotification = new NotificationImpl();
        }
        return this.mNotification;
    }

    private void stopDownload() {
        if (this.mHttpManager != null) {
            this.mHttpManager.cancel();
        }
    }

    private void stopService() {
        this.mCount = 0;
        this.stopSelf();
    }

    public void onDestroy() {
        this.isDownloading = false;
        this.mHttpManager = null;
        this.mUpdateCallback = null;
        this.mNotification = null;
        super.onDestroy();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.mDownloadBinder;
    }

    public class DownloadBinder
    extends Binder {
        public void start(@NonNull UpdateConfig config) {
            this.start(config, null);
        }

        public void start(@NonNull UpdateConfig config, @Nullable UpdateCallback callback) {
            this.start(config, null, callback);
        }

        public void start(@NonNull UpdateConfig config, @Nullable IHttpManager httpManager, @Nullable UpdateCallback callback) {
            this.start(config, httpManager, callback, null);
        }

        public void start(@NonNull UpdateConfig config, @Nullable IHttpManager httpManager, @Nullable UpdateCallback callback, @Nullable INotification notification) {
            DownloadService.this.startDownload(config, httpManager, callback, notification);
        }
    }

    public static class AppDownloadCallback
    implements IHttpManager.DownloadCallback {
        private Context context;
        private DownloadService downloadService;
        public UpdateConfig config;
        private boolean isShowNotification;
        private int notifyId;
        private String channelId;
        private String channelName;
        private int notificationIcon;
        private boolean isInstallApk;
        private String authority;
        private boolean isShowPercentage;
        private boolean isReDownload;
        private boolean isDeleteCancelFile;
        private boolean isSupportCancelDownload;
        private UpdateCallback callback;
        private INotification notification;
        private int lastProgress;
        private long lastTime;
        private File apkFile;

        private AppDownloadCallback(Context context, DownloadService downloadService, UpdateConfig config, File apkFile, UpdateCallback callback, INotification notification) {
            this.context = context;
            this.downloadService = downloadService;
            this.config = config;
            this.apkFile = apkFile;
            this.callback = callback;
            this.notification = notification;
            this.isShowNotification = config.isShowNotification();
            this.notifyId = config.getNotificationId();
            if (Build.VERSION.SDK_INT >= 26) {
                this.channelId = TextUtils.isEmpty((CharSequence)config.getChannelId()) ? "0x66" : config.getChannelId();
                this.channelName = TextUtils.isEmpty((CharSequence)config.getChannelName()) ? "AppUpdater" : config.getChannelName();
            }
            this.notificationIcon = config.getNotificationIcon() <= 0 ? AppUtils.getAppIcon(context) : config.getNotificationIcon();
            this.isInstallApk = config.isInstallApk();
            this.authority = config.getAuthority();
            if (TextUtils.isEmpty((CharSequence)config.getAuthority())) {
                this.authority = AppUtils.getFileProviderAuthority(context);
            }
            this.isShowPercentage = config.isShowPercentage();
            this.isDeleteCancelFile = config.isDeleteCancelFile();
            this.isSupportCancelDownload = config.isSupportCancelDownload();
            this.isReDownload = config.isReDownload() && downloadService.mCount < config.getReDownloads();
        }

        @Override
        public void onStart(String url) {
            LogUtils.i("url: " + url);
            this.downloadService.isDownloading = true;
            this.lastProgress = 0;
            if (this.isShowNotification && this.notification != null) {
                this.notification.onStart(this.context, this.notifyId, this.channelId, this.channelName, this.notificationIcon, this.getString(R.string.app_updater_start_notification_title), this.getString(R.string.app_updater_start_notification_content), this.config.isVibrate(), this.config.isSound(), this.isSupportCancelDownload);
            }
            if (this.callback != null) {
                this.callback.onStart(url);
            }
        }

        @Override
        public void onProgress(long progress, long total) {
            boolean isChanged = false;
            long curTime = System.currentTimeMillis();
            if (this.lastTime + 200L < curTime || progress == total) {
                this.lastTime = curTime;
                int progressPercentage = 0;
                if (total > 0L) {
                    progressPercentage = Math.round((float)progress * 1.0f / (float)total * 100.0f);
                    if (progressPercentage != this.lastProgress) {
                        isChanged = true;
                        this.lastProgress = progressPercentage;
                    }
                    LogUtils.i(String.format(Locale.getDefault(), "%d%%\t| %d/%d", progressPercentage, progress, total));
                } else {
                    LogUtils.i(String.format(Locale.getDefault(), "%d/%d", progress, total));
                }
                if (this.isShowNotification && this.notification != null) {
                    String content = this.context.getString(R.string.app_updater_progress_notification_content);
                    if (total > 0L) {
                        if (this.isShowPercentage) {
                            content = String.format(Locale.getDefault(), "%s%d%%", content, progressPercentage);
                        }
                        this.notification.onProgress(this.context, this.notifyId, this.channelId, this.notificationIcon, this.context.getString(R.string.app_updater_progress_notification_title), content, progressPercentage, 100, this.isSupportCancelDownload);
                    } else {
                        this.notification.onProgress(this.context, this.notifyId, this.channelId, this.notificationIcon, this.context.getString(R.string.app_updater_progress_notification_title), content, (int)progress, -1, this.isSupportCancelDownload);
                    }
                }
            }
            if (this.callback != null && total > 0L) {
                this.callback.onProgress(progress, total, isChanged);
            }
        }

        @Override
        public void onFinish(File file) {
            LogUtils.d("File: " + file);
            this.downloadService.isDownloading = false;
            if (this.isShowNotification && this.notification != null) {
                this.notification.onFinish(this.context, this.notifyId, this.channelId, this.notificationIcon, this.getString(R.string.app_updater_finish_notification_title), this.getString(R.string.app_updater_finish_notification_content), file, this.authority);
            }
            if (this.isInstallApk) {
                AppUtils.installApk(this.context, file, this.authority);
            }
            if (this.callback != null) {
                this.callback.onFinish(file);
            }
            this.downloadService.stopService();
        }

        @Override
        public void onError(Exception e) {
            LogUtils.w(e.getMessage());
            this.downloadService.isDownloading = false;
            if (this.isShowNotification && this.notification != null) {
                String content = this.isReDownload ? this.getString(R.string.app_updater_error_notification_content_re_download) : this.getString(R.string.app_updater_error_notification_content);
                this.notification.onError(this.context, this.notifyId, this.channelId, this.notificationIcon, this.getString(R.string.app_updater_error_notification_title), content, this.isReDownload, this.config);
            }
            if (this.callback != null) {
                this.callback.onError(e);
            }
            if (!this.isReDownload) {
                this.downloadService.stopService();
            }
        }

        @Override
        public void onCancel() {
            LogUtils.d("Cancel download.");
            this.downloadService.isDownloading = false;
            if (this.isShowNotification && this.notification != null) {
                this.notification.onCancel(this.context, this.notifyId);
            }
            if (this.callback != null) {
                this.callback.onCancel();
            }
            if (this.isDeleteCancelFile && this.apkFile != null) {
                this.apkFile.delete();
            }
            this.downloadService.stopService();
        }

        private String getString(@StringRes int resId) {
            return this.context.getString(resId);
        }
    }
}

