/*
 * Decompiled with CFR 0.152.
 */
package com.like;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import com.like.Utils;

public class DotsView
extends View {
    private static final int DOTS_COUNT = 7;
    private static final int OUTER_DOTS_POSITION_ANGLE = 51;
    private int COLOR_1 = -16121;
    private int COLOR_2 = -26624;
    private int COLOR_3 = -43230;
    private int COLOR_4 = -769226;
    private int width = 0;
    private int height = 0;
    private final Paint[] circlePaints = new Paint[4];
    private int centerX;
    private int centerY;
    private float maxOuterDotsRadius;
    private float maxInnerDotsRadius;
    private float maxDotSize;
    private float currentProgress = 0.0f;
    private float currentRadius1 = 0.0f;
    private float currentDotSize1 = 0.0f;
    private float currentDotSize2 = 0.0f;
    private float currentRadius2 = 0.0f;
    private ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    public static final Property<DotsView, Float> DOTS_PROGRESS = new Property<DotsView, Float>(Float.class, "dotsProgress"){

        public Float get(DotsView object) {
            return Float.valueOf(object.getCurrentProgress());
        }

        public void set(DotsView object, Float value) {
            object.setCurrentProgress(value.floatValue());
        }
    };

    public DotsView(Context context) {
        super(context);
        this.init();
    }

    public DotsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DotsView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.circlePaints.length; ++i) {
            this.circlePaints[i] = new Paint();
            this.circlePaints[i].setStyle(Paint.Style.FILL);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.centerX = w / 2;
        this.centerY = h / 2;
        this.maxDotSize = 5.0f;
        this.maxOuterDotsRadius = (float)(w / 2) - this.maxDotSize * 2.0f;
        this.maxInnerDotsRadius = 0.8f * this.maxOuterDotsRadius;
    }

    protected void onDraw(Canvas canvas) {
        this.drawOuterDotsFrame(canvas);
        this.drawInnerDotsFrame(canvas);
    }

    private void drawOuterDotsFrame(Canvas canvas) {
        for (int i = 0; i < 7; ++i) {
            int cX = (int)((double)this.centerX + (double)this.currentRadius1 * Math.cos((double)(i * 51) * Math.PI / 180.0));
            int cY = (int)((double)this.centerY + (double)this.currentRadius1 * Math.sin((double)(i * 51) * Math.PI / 180.0));
            canvas.drawCircle((float)cX, (float)cY, this.currentDotSize1, this.circlePaints[i % this.circlePaints.length]);
        }
    }

    private void drawInnerDotsFrame(Canvas canvas) {
        for (int i = 0; i < 7; ++i) {
            int cX = (int)((double)this.centerX + (double)this.currentRadius2 * Math.cos((double)(i * 51 - 10) * Math.PI / 180.0));
            int cY = (int)((double)this.centerY + (double)this.currentRadius2 * Math.sin((double)(i * 51 - 10) * Math.PI / 180.0));
            canvas.drawCircle((float)cX, (float)cY, this.currentDotSize2, this.circlePaints[(i + 1) % this.circlePaints.length]);
        }
    }

    public void setCurrentProgress(float currentProgress) {
        this.currentProgress = currentProgress;
        this.updateInnerDotsPosition();
        this.updateOuterDotsPosition();
        this.updateDotsPaints();
        this.updateDotsAlpha();
        this.postInvalidate();
    }

    public float getCurrentProgress() {
        return this.currentProgress;
    }

    private void updateInnerDotsPosition() {
        this.currentRadius2 = this.currentProgress < 0.3f ? (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.0, 0.3f, 0.0, this.maxInnerDotsRadius) : this.maxInnerDotsRadius;
        this.currentDotSize2 = this.currentProgress == 0.0f ? 0.0f : ((double)this.currentProgress < 0.2 ? this.maxDotSize : ((double)this.currentProgress < 0.5 ? (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.2f, 0.5, this.maxDotSize, 0.3 * (double)this.maxDotSize) : (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.5, 1.0, this.maxDotSize * 0.3f, 0.0)));
    }

    private void updateOuterDotsPosition() {
        this.currentRadius1 = this.currentProgress < 0.3f ? (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.0, 0.3f, 0.0, this.maxOuterDotsRadius * 0.8f) : (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.3f, 1.0, 0.8f * this.maxOuterDotsRadius, this.maxOuterDotsRadius);
        this.currentDotSize1 = this.currentProgress == 0.0f ? 0.0f : ((double)this.currentProgress < 0.7 ? this.maxDotSize : (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.7f, 1.0, this.maxDotSize, 0.0));
    }

    private void updateDotsPaints() {
        if (this.currentProgress < 0.5f) {
            float progress = (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.0, 0.5, 0.0, 1.0);
            this.circlePaints[0].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_1, (Object)this.COLOR_2)).intValue());
            this.circlePaints[1].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_2, (Object)this.COLOR_3)).intValue());
            this.circlePaints[2].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_3, (Object)this.COLOR_4)).intValue());
            this.circlePaints[3].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_4, (Object)this.COLOR_1)).intValue());
        } else {
            float progress = (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.5, 1.0, 0.0, 1.0);
            this.circlePaints[0].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_2, (Object)this.COLOR_3)).intValue());
            this.circlePaints[1].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_3, (Object)this.COLOR_4)).intValue());
            this.circlePaints[2].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_4, (Object)this.COLOR_1)).intValue());
            this.circlePaints[3].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_1, (Object)this.COLOR_2)).intValue());
        }
    }

    public void setColors(@ColorInt int primaryColor, @ColorInt int secondaryColor) {
        this.COLOR_1 = primaryColor;
        this.COLOR_2 = secondaryColor;
        this.COLOR_3 = primaryColor;
        this.COLOR_4 = secondaryColor;
        this.invalidate();
    }

    private void updateDotsAlpha() {
        float progress = (float)Utils.clamp(this.currentProgress, 0.6f, 1.0);
        int alpha = (int)Utils.mapValueFromRangeToRange(progress, 0.6f, 1.0, 255.0, 0.0);
        this.circlePaints[0].setAlpha(alpha);
        this.circlePaints[1].setAlpha(alpha);
        this.circlePaints[2].setAlpha(alpha);
        this.circlePaints[3].setAlpha(alpha);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.width != 0 && this.height != 0) {
            this.setMeasuredDimension(this.width, this.height);
        }
    }
}

