/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.EvalUtil;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.NonHashException;
import freemarker.core.NonStringException;
import freemarker.core.ParameterRole;
import freemarker.core.Range;
import freemarker.core.RangeModel;
import freemarker.core.UnexpectedTypeException;
import freemarker.core._MiscTemplateException;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template._TemplateAPI;
import freemarker.template.utility.Constants;
import java.util.ArrayList;
import java.util.Collections;

final class DynamicKeyName
extends Expression {
    private final Expression keyExpression;
    private final Expression target;
    private static Class[] NUMERICAL_KEY_LHO_EXPECTED_TYPES = new Class[1 + NonStringException.STRING_COERCABLE_TYPES.length];

    DynamicKeyName(Expression target, Expression keyExpression) {
        this.target = target;
        this.keyExpression = keyExpression;
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        TemplateModel targetModel = this.target.eval(env);
        if (targetModel == null) {
            if (env.isClassicCompatible()) {
                return null;
            }
            throw InvalidReferenceException.getInstance(this.target, env);
        }
        TemplateModel keyModel = this.keyExpression.eval(env);
        if (keyModel == null) {
            if (env.isClassicCompatible()) {
                keyModel = TemplateScalarModel.EMPTY_STRING;
            } else {
                this.keyExpression.assertNonNull(null, env);
            }
        }
        if (keyModel instanceof TemplateNumberModel) {
            int index = this.keyExpression.modelToNumber(keyModel, env).intValue();
            return this.dealWithNumericalKey(targetModel, index, env);
        }
        if (keyModel instanceof TemplateScalarModel) {
            String key = EvalUtil.modelToString((TemplateScalarModel)keyModel, this.keyExpression, env);
            return this.dealWithStringKey(targetModel, key, env);
        }
        if (keyModel instanceof RangeModel) {
            return this.dealWithRangeKey(targetModel, (RangeModel)keyModel, env);
        }
        throw new UnexpectedTypeException(this.keyExpression, keyModel, "number, range, or string", new Class[]{TemplateNumberModel.class, TemplateScalarModel.class, Range.class}, env);
    }

    private TemplateModel dealWithNumericalKey(TemplateModel targetModel, int index, Environment env) throws TemplateException {
        if (targetModel instanceof TemplateSequenceModel) {
            int size;
            TemplateSequenceModel tsm = (TemplateSequenceModel)targetModel;
            try {
                size = tsm.size();
            }
            catch (Exception e) {
                size = Integer.MAX_VALUE;
            }
            return index < size ? tsm.get(index) : null;
        }
        try {
            String s2 = this.target.evalAndCoerceToPlainText(env);
            try {
                return new SimpleScalar(s2.substring(index, index + 1));
            }
            catch (IndexOutOfBoundsException e) {
                if (index < 0) {
                    throw new _MiscTemplateException("Negative index not allowed: ", index);
                }
                if (index >= s2.length()) {
                    throw new _MiscTemplateException("String index out of range: The index was ", index, " (0-based), but the length of the string is only ", s2.length(), ".");
                }
                throw new RuntimeException("Can't explain exception", e);
            }
        }
        catch (NonStringException e) {
            throw new UnexpectedTypeException(this.target, targetModel, "sequence or string or something automatically convertible to string (number, date or boolean)", NUMERICAL_KEY_LHO_EXPECTED_TYPES, targetModel instanceof TemplateHashModel ? "You had a numberical value inside the []. Currently that's only supported for sequences (lists) and strings. To get a Map item with a non-string key, use myMap?api.get(myKey)." : null, env);
        }
    }

    private TemplateModel dealWithStringKey(TemplateModel targetModel, String key, Environment env) throws TemplateException {
        if (targetModel instanceof TemplateHashModel) {
            return ((TemplateHashModel)targetModel).get(key);
        }
        throw new NonHashException(this.target, targetModel, env);
    }

    private TemplateModel dealWithRangeKey(TemplateModel targetModel, RangeModel range, Environment env) throws UnexpectedTypeException, InvalidReferenceException, TemplateException {
        int exclEndIdx;
        int resultSize;
        String targetStr;
        TemplateSequenceModel targetSeq;
        if (targetModel instanceof TemplateSequenceModel) {
            targetSeq = (TemplateSequenceModel)targetModel;
            targetStr = null;
        } else {
            targetSeq = null;
            try {
                targetStr = this.target.evalAndCoerceToPlainText(env);
            }
            catch (NonStringException e) {
                throw new UnexpectedTypeException(this.target, this.target.eval(env), "sequence or string or something automatically convertible to string (number, date or boolean)", NUMERICAL_KEY_LHO_EXPECTED_TYPES, env);
            }
        }
        int size = range.size();
        boolean rightUnbounded = range.isRightUnbounded();
        boolean rightAdaptive = range.isRightAdaptive();
        if (!rightUnbounded && size == 0) {
            return this.emptyResult(targetSeq != null);
        }
        int firstIdx = range.getBegining();
        if (firstIdx < 0) {
            throw new _MiscTemplateException(this.keyExpression, "Negative range start index (", firstIdx, ") isn't allowed for a range used for slicing.");
        }
        int targetSize = targetStr != null ? targetStr.length() : targetSeq.size();
        int step = range.getStep();
        if (rightAdaptive && step == 1 ? firstIdx > targetSize : firstIdx >= targetSize) {
            throw new _MiscTemplateException(this.keyExpression, "Range start index ", firstIdx, " is out of bounds, because the sliced ", targetStr != null ? "string" : "sequence", " has only ", targetSize, " ", targetStr != null ? "character(s)" : "element(s)", ". ", "(Note that indices are 0-based).");
        }
        if (!rightUnbounded) {
            int lastIdx = firstIdx + (size - 1) * step;
            if (lastIdx < 0) {
                if (!rightAdaptive) {
                    throw new _MiscTemplateException(this.keyExpression, "Negative range end index (", lastIdx, ") isn't allowed for a range used for slicing.");
                }
                resultSize = firstIdx + 1;
            } else if (lastIdx >= targetSize) {
                if (!rightAdaptive) {
                    throw new _MiscTemplateException(this.keyExpression, "Range end index ", lastIdx, " is out of bounds, because the sliced ", targetStr != null ? "string" : "sequence", " has only ", targetSize, " ", targetStr != null ? "character(s)" : "element(s)", ". (Note that indices are 0-based).");
                }
                resultSize = Math.abs(targetSize - firstIdx);
            } else {
                resultSize = size;
            }
        } else {
            resultSize = targetSize - firstIdx;
        }
        if (resultSize == 0) {
            return this.emptyResult(targetSeq != null);
        }
        if (targetSeq != null) {
            ArrayList<TemplateModel> list = new ArrayList<TemplateModel>(resultSize);
            int srcIdx = firstIdx;
            for (int i = 0; i < resultSize; ++i) {
                list.add(targetSeq.get(srcIdx));
                srcIdx += step;
            }
            return new SimpleSequence(list, null);
        }
        if (step < 0 && resultSize > 1) {
            if (!range.isAffactedByStringSlicingBug() || resultSize != 2) {
                throw new _MiscTemplateException(this.keyExpression, "Decreasing ranges aren't allowed for slicing strings (as it would give reversed text). The index range was: first = ", firstIdx, ", last = ", firstIdx + (resultSize - 1) * step);
            }
            exclEndIdx = firstIdx;
        } else {
            exclEndIdx = firstIdx + resultSize;
        }
        return new SimpleScalar(targetStr.substring(firstIdx, exclEndIdx));
    }

    private TemplateModel emptyResult(boolean seq) {
        return seq ? (_TemplateAPI.getTemplateLanguageVersionAsInt(this) < _TemplateAPI.VERSION_INT_2_3_21 ? new SimpleSequence(Collections.EMPTY_LIST, null) : Constants.EMPTY_SEQUENCE) : TemplateScalarModel.EMPTY_STRING;
    }

    public String getCanonicalForm() {
        return this.target.getCanonicalForm() + "[" + this.keyExpression.getCanonicalForm() + "]";
    }

    String getNodeTypeSymbol() {
        return "...[...]";
    }

    boolean isLiteral() {
        return this.constantValue != null || this.target.isLiteral() && this.keyExpression.isLiteral();
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        return idx == 0 ? this.target : this.keyExpression;
    }

    ParameterRole getParameterRole(int idx) {
        return idx == 0 ? ParameterRole.LEFT_HAND_OPERAND : ParameterRole.ENCLOSED_OPERAND;
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        return new DynamicKeyName(this.target.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState), this.keyExpression.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState));
    }

    static {
        DynamicKeyName.NUMERICAL_KEY_LHO_EXPECTED_TYPES[0] = TemplateSequenceModel.class;
        for (int i = 0; i < NonStringException.STRING_COERCABLE_TYPES.length; ++i) {
            DynamicKeyName.NUMERICAL_KEY_LHO_EXPECTED_TYPES[i + 1] = NonStringException.STRING_COERCABLE_TYPES[i];
        }
    }
}

