/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data.type;

import com.github.jcustenborder.kafka.connect.utils.data.type.TypeParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.fasterxml.jackson.databind.JsonNode;
import shaded.com.google.common.base.Preconditions;

public abstract class BaseDateTypeParser
implements TypeParser {
    static final Logger log = LoggerFactory.getLogger(BaseDateTypeParser.class);
    protected final TimeZone timeZone;
    final SimpleDateFormat[] dateFormats;

    public BaseDateTypeParser(TimeZone timeZone, SimpleDateFormat ... dateFormats) {
        this.dateFormats = dateFormats;
        this.timeZone = timeZone;
    }

    abstract Date process(Date var1);

    @Override
    public Object parseString(String s2, Schema schema) {
        Date date = null;
        for (SimpleDateFormat dateFormat : this.dateFormats) {
            try {
                date = dateFormat.parse(s2);
                break;
            }
            catch (ParseException e) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Could not parse '{}' to java.util.Date", (Object)s2, (Object)e);
            }
        }
        Preconditions.checkState(null != date, "Could not parse '%s' to java.util.Date", (Object)s2);
        return this.process(date);
    }

    @Override
    public Object parseJsonNode(JsonNode input, Schema schema) {
        Date result;
        if (input.isNumber()) {
            result = new Date(input.longValue());
        } else if (input.isTextual()) {
            result = (Date)this.parseString(input.textValue(), schema);
        } else {
            throw new IllegalStateException(String.format("NodeType:%s '%s' could not be converted to %s", new Object[]{input.getNodeType(), input.textValue(), this.expectedClass().getSimpleName()}));
        }
        return this.process(result);
    }

    @Override
    public Class<?> expectedClass() {
        return Date.class;
    }
}

