/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;

public class ValidPattern
implements ConfigDef.Validator {
    final Pattern pattern;

    public static ValidPattern of(String pattern) {
        Pattern regexPattern = Pattern.compile(pattern);
        return ValidPattern.of(regexPattern);
    }

    public static ValidPattern of(Pattern pattern) {
        return new ValidPattern(pattern);
    }

    private ValidPattern(Pattern pattern) {
        Preconditions.checkNotNull((Object)pattern, (Object)"pattern cannot be null");
        this.pattern = pattern;
    }

    public void ensureValid(String s, Object o) {
        Preconditions.checkNotNull((Object)o, (String)"%s: Cannot be null.", (Object)s);
        Preconditions.checkState((boolean)(o instanceof String), (String)"%s: '%s' is not a String.", (Object)s, (Object)o);
        Matcher matcher = this.pattern.matcher((String)o);
        Preconditions.checkState((boolean)matcher.matches(), (String)"%s: '%s' does not match pattern '%s'.", (Object)s, (Object)o, (Object)this.pattern.pattern());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pattern", (Object)this.pattern.pattern()).toString();
    }
}

