/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.jcustenborder.kafka.connect.utils.data.type.TypeParser;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;

public class DecimalTypeParser
implements TypeParser {
    final Cache<Schema, Integer> schemaCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();
    static final String NOT_FOUND_MESSAGE = String.format("Invalid Decimal schema: %s parameter not found.", "scale");
    static final String NOT_PARSABLE_MESSAGE = String.format("Invalid Decimal schema: %s parameter could not be converted to an integer.", "scale");

    private static int scaleInternal(Schema schema) {
        if (null == schema.parameters()) {
            throw new DataException(NOT_FOUND_MESSAGE);
        }
        String scaleString = (String)schema.parameters().get("scale");
        if (scaleString == null) {
            throw new DataException(NOT_FOUND_MESSAGE);
        }
        try {
            return Integer.parseInt(scaleString);
        }
        catch (NumberFormatException var3) {
            throw new DataException(NOT_PARSABLE_MESSAGE, (Throwable)var3);
        }
    }

    int scale(Schema schema) {
        int scale;
        try {
            scale = (Integer)this.schemaCache.get((Object)schema, () -> DecimalTypeParser.scaleInternal(schema));
        }
        catch (Exception e) {
            throw new DataException((Throwable)e);
        }
        return scale;
    }

    @Override
    public Object parseString(String s, Schema schema) {
        int scale = this.scale(schema);
        return new BigDecimal(s).setScale(scale);
    }

    @Override
    public Class<?> expectedClass() {
        return BigDecimal.class;
    }

    @Override
    public Object parseJsonNode(JsonNode input, Schema schema) {
        Preconditions.checkState((boolean)input.isBigDecimal(), (String)"'%s' is not a '%s'", (Object[])new Object[]{input.textValue(), this.expectedClass().getSimpleName()});
        int scale = this.scale(schema);
        return input.decimalValue().setScale(scale);
    }
}

