/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.ConverterExampleInput", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableConverterExampleInput
implements Plugin.ConverterExampleInput {
    @Nullable
    private final String config;
    private final Plugin.ConverterExample example;
    private final String workerKeyConfig;
    private final String workerValueConfig;
    private final String connectorKeyConfig;
    private final String connectorValueConfig;

    private ImmutableConverterExampleInput(@Nullable String config, Plugin.ConverterExample example, String workerKeyConfig, String workerValueConfig, String connectorKeyConfig, String connectorValueConfig) {
        this.config = config;
        this.example = example;
        this.workerKeyConfig = workerKeyConfig;
        this.workerValueConfig = workerValueConfig;
        this.connectorKeyConfig = connectorKeyConfig;
        this.connectorValueConfig = connectorValueConfig;
    }

    @Override
    @Nullable
    public String getConfig() {
        return this.config;
    }

    @Override
    public Plugin.ConverterExample getExample() {
        return this.example;
    }

    @Override
    public String getWorkerKeyConfig() {
        return this.workerKeyConfig;
    }

    @Override
    public String getWorkerValueConfig() {
        return this.workerValueConfig;
    }

    @Override
    public String getConnectorKeyConfig() {
        return this.connectorKeyConfig;
    }

    @Override
    public String getConnectorValueConfig() {
        return this.connectorValueConfig;
    }

    public final ImmutableConverterExampleInput withConfig(@Nullable String value) {
        if (Objects.equals(this.config, value)) {
            return this;
        }
        return new ImmutableConverterExampleInput(value, this.example, this.workerKeyConfig, this.workerValueConfig, this.connectorKeyConfig, this.connectorValueConfig);
    }

    public final ImmutableConverterExampleInput withExample(Plugin.ConverterExample value) {
        if (this.example == value) {
            return this;
        }
        Plugin.ConverterExample newValue = Objects.requireNonNull(value, "example");
        return new ImmutableConverterExampleInput(this.config, newValue, this.workerKeyConfig, this.workerValueConfig, this.connectorKeyConfig, this.connectorValueConfig);
    }

    public final ImmutableConverterExampleInput withWorkerKeyConfig(String value) {
        String newValue = Objects.requireNonNull(value, "workerKeyConfig");
        if (this.workerKeyConfig.equals(newValue)) {
            return this;
        }
        return new ImmutableConverterExampleInput(this.config, this.example, newValue, this.workerValueConfig, this.connectorKeyConfig, this.connectorValueConfig);
    }

    public final ImmutableConverterExampleInput withWorkerValueConfig(String value) {
        String newValue = Objects.requireNonNull(value, "workerValueConfig");
        if (this.workerValueConfig.equals(newValue)) {
            return this;
        }
        return new ImmutableConverterExampleInput(this.config, this.example, this.workerKeyConfig, newValue, this.connectorKeyConfig, this.connectorValueConfig);
    }

    public final ImmutableConverterExampleInput withConnectorKeyConfig(String value) {
        String newValue = Objects.requireNonNull(value, "connectorKeyConfig");
        if (this.connectorKeyConfig.equals(newValue)) {
            return this;
        }
        return new ImmutableConverterExampleInput(this.config, this.example, this.workerKeyConfig, this.workerValueConfig, newValue, this.connectorValueConfig);
    }

    public final ImmutableConverterExampleInput withConnectorValueConfig(String value) {
        String newValue = Objects.requireNonNull(value, "connectorValueConfig");
        if (this.connectorValueConfig.equals(newValue)) {
            return this;
        }
        return new ImmutableConverterExampleInput(this.config, this.example, this.workerKeyConfig, this.workerValueConfig, this.connectorKeyConfig, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConverterExampleInput && this.equalTo((ImmutableConverterExampleInput)another);
    }

    private boolean equalTo(ImmutableConverterExampleInput another) {
        return Objects.equals(this.config, another.config) && this.example.equals(another.example) && this.workerKeyConfig.equals(another.workerKeyConfig) && this.workerValueConfig.equals(another.workerValueConfig) && this.connectorKeyConfig.equals(another.connectorKeyConfig) && this.connectorValueConfig.equals(another.connectorValueConfig);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.config);
        h += (h << 5) + this.example.hashCode();
        h += (h << 5) + this.workerKeyConfig.hashCode();
        h += (h << 5) + this.workerValueConfig.hashCode();
        h += (h << 5) + this.connectorKeyConfig.hashCode();
        h += (h << 5) + this.connectorValueConfig.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConverterExampleInput").omitNullValues().add("config", (Object)this.config).add("example", (Object)this.example).add("workerKeyConfig", (Object)this.workerKeyConfig).add("workerValueConfig", (Object)this.workerValueConfig).add("connectorKeyConfig", (Object)this.connectorKeyConfig).add("connectorValueConfig", (Object)this.connectorValueConfig).toString();
    }

    public static ImmutableConverterExampleInput copyOf(Plugin.ConverterExampleInput instance) {
        if (instance instanceof ImmutableConverterExampleInput) {
            return (ImmutableConverterExampleInput)instance;
        }
        return ImmutableConverterExampleInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.ConverterExampleInput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXAMPLE = 1L;
        private static final long INIT_BIT_WORKER_KEY_CONFIG = 2L;
        private static final long INIT_BIT_WORKER_VALUE_CONFIG = 4L;
        private static final long INIT_BIT_CONNECTOR_KEY_CONFIG = 8L;
        private static final long INIT_BIT_CONNECTOR_VALUE_CONFIG = 16L;
        private long initBits = 31L;
        @Nullable
        private String config;
        @Nullable
        private Plugin.ConverterExample example;
        @Nullable
        private String workerKeyConfig;
        @Nullable
        private String workerValueConfig;
        @Nullable
        private String connectorKeyConfig;
        @Nullable
        private String connectorValueConfig;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.ConverterExampleInput instance) {
            Objects.requireNonNull(instance, "instance");
            String configValue = instance.getConfig();
            if (configValue != null) {
                this.config(configValue);
            }
            this.example((Plugin.ConverterExample)instance.getExample());
            this.workerKeyConfig(instance.getWorkerKeyConfig());
            this.workerValueConfig(instance.getWorkerValueConfig());
            this.connectorKeyConfig(instance.getConnectorKeyConfig());
            this.connectorValueConfig(instance.getConnectorValueConfig());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(@Nullable String config) {
            this.config = config;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder example(Plugin.ConverterExample example) {
            this.example = Objects.requireNonNull(example, "example");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workerKeyConfig(String workerKeyConfig) {
            this.workerKeyConfig = Objects.requireNonNull(workerKeyConfig, "workerKeyConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workerValueConfig(String workerValueConfig) {
            this.workerValueConfig = Objects.requireNonNull(workerValueConfig, "workerValueConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectorKeyConfig(String connectorKeyConfig) {
            this.connectorKeyConfig = Objects.requireNonNull(connectorKeyConfig, "connectorKeyConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectorValueConfig(String connectorValueConfig) {
            this.connectorValueConfig = Objects.requireNonNull(connectorValueConfig, "connectorValueConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableConverterExampleInput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConverterExampleInput(this.config, this.example, this.workerKeyConfig, this.workerValueConfig, this.connectorKeyConfig, this.connectorValueConfig);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("example");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("workerKeyConfig");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("workerValueConfig");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("connectorKeyConfig");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("connectorValueConfig");
            }
            return "Cannot build ConverterExampleInput, some of required attributes are not set " + attributes;
        }
    }
}

