/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.Configuration", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableConfiguration
implements Plugin.Configuration {
    private final ImmutableList<Plugin.Group> groups;
    private final ImmutableList<Plugin.Item> requiredConfigs;

    private ImmutableConfiguration(ImmutableList<Plugin.Group> groups, ImmutableList<Plugin.Item> requiredConfigs) {
        this.groups = groups;
        this.requiredConfigs = requiredConfigs;
    }

    public ImmutableList<Plugin.Group> getGroups() {
        return this.groups;
    }

    public ImmutableList<Plugin.Item> getRequiredConfigs() {
        return this.requiredConfigs;
    }

    public final ImmutableConfiguration withGroups(Plugin.Group ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableConfiguration((ImmutableList<Plugin.Group>)newValue, this.requiredConfigs);
    }

    public final ImmutableConfiguration withGroups(Iterable<? extends Plugin.Group> elements) {
        if (this.groups == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableConfiguration((ImmutableList<Plugin.Group>)newValue, this.requiredConfigs);
    }

    public final ImmutableConfiguration withRequiredConfigs(Plugin.Item ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableConfiguration(this.groups, (ImmutableList<Plugin.Item>)newValue);
    }

    public final ImmutableConfiguration withRequiredConfigs(Iterable<? extends Plugin.Item> elements) {
        if (this.requiredConfigs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableConfiguration(this.groups, (ImmutableList<Plugin.Item>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfiguration && this.equalTo((ImmutableConfiguration)another);
    }

    private boolean equalTo(ImmutableConfiguration another) {
        return this.groups.equals(another.groups) && this.requiredConfigs.equals(another.requiredConfigs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.groups.hashCode();
        h += (h << 5) + this.requiredConfigs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Configuration").omitNullValues().add("groups", this.groups).add("requiredConfigs", this.requiredConfigs).toString();
    }

    public static ImmutableConfiguration copyOf(Plugin.Configuration instance) {
        if (instance instanceof ImmutableConfiguration) {
            return (ImmutableConfiguration)instance;
        }
        return ImmutableConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.Configuration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Plugin.Group> groups = ImmutableList.builder();
        private ImmutableList.Builder<Plugin.Item> requiredConfigs = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.Configuration instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllGroups(instance.getGroups());
            this.addAllRequiredConfigs(instance.getRequiredConfigs());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGroups(Plugin.Group element) {
            this.groups.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGroups(Plugin.Group ... elements) {
            this.groups.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder groups(Iterable<? extends Plugin.Group> elements) {
            this.groups = ImmutableList.builder();
            return this.addAllGroups(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGroups(Iterable<? extends Plugin.Group> elements) {
            this.groups.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequiredConfigs(Plugin.Item element) {
            this.requiredConfigs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequiredConfigs(Plugin.Item ... elements) {
            this.requiredConfigs.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder requiredConfigs(Iterable<? extends Plugin.Item> elements) {
            this.requiredConfigs = ImmutableList.builder();
            return this.addAllRequiredConfigs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRequiredConfigs(Iterable<? extends Plugin.Item> elements) {
            this.requiredConfigs.addAll(elements);
            return this;
        }

        public ImmutableConfiguration build() {
            return new ImmutableConfiguration(this.groups.build(), this.requiredConfigs.build());
        }
    }
}

