/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Notes;
import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.SinkConnector", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSinkConnector
implements Plugin.SinkConnector {
    @Nullable
    private final String warning;
    @Nullable
    private final String tip;
    @Nullable
    private final String important;
    @Nullable
    private final String danger;
    @Nullable
    private final String note;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final String icon;
    @Nullable
    private final String introduction;
    private final Class cls;
    private final Plugin.Configuration configuration;
    private final ImmutableList<String> examples;

    private ImmutableSinkConnector(@Nullable String warning, @Nullable String tip, @Nullable String important, @Nullable String danger, @Nullable String note, @Nullable String title, @Nullable String description, @Nullable String icon, @Nullable String introduction, Class cls, Plugin.Configuration configuration, ImmutableList<String> examples) {
        this.warning = warning;
        this.tip = tip;
        this.important = important;
        this.danger = danger;
        this.note = note;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.introduction = introduction;
        this.cls = cls;
        this.configuration = configuration;
        this.examples = examples;
    }

    @Override
    @Nullable
    public String getWarning() {
        return this.warning;
    }

    @Override
    @Nullable
    public String getTip() {
        return this.tip;
    }

    @Override
    @Nullable
    public String getImportant() {
        return this.important;
    }

    @Override
    @Nullable
    public String getDanger() {
        return this.danger;
    }

    @Override
    @Nullable
    public String getNote() {
        return this.note;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public String getIntroduction() {
        return this.introduction;
    }

    @Override
    public Class getCls() {
        return this.cls;
    }

    @Override
    public Plugin.Configuration getConfiguration() {
        return this.configuration;
    }

    public ImmutableList<String> getExamples() {
        return this.examples;
    }

    public final ImmutableSinkConnector withWarning(@Nullable String value) {
        if (Objects.equals(this.warning, value)) {
            return this;
        }
        return new ImmutableSinkConnector(value, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.cls, this.configuration, this.examples);
    }

    public final ImmutableSinkConnector withTip(@Nullable String value) {
        if (Objects.equals(this.tip, value)) {
            return this;
        }
        return new ImmutableSinkConnector(this.warning, value, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.cls, this.configuration, this.examples);
    }

    public final ImmutableSinkConnector withImportant(@Nullable String value) {
        if (Objects.equals(this.important, value)) {
            return this;
        }
        return new ImmutableSinkConnector(this.warning, this.tip, value, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.cls, this.configuration, this.examples);
    }

    public final ImmutableSinkConnector withDanger(@Nullable String value) {
        if (Objects.equals(this.danger, value)) {
            return this;
        }
        return new ImmutableSinkConnector(this.warning, this.tip, this.important, value, this.note, this.title, this.description, this.icon, this.introduction, this.cls, this.configuration, this.examples);
    }

    public final ImmutableSinkConnector withNote(@Nullable String value) {
        if (Objects.equals(this.note, value)) {
            return this;
        }
        return new ImmutableSinkConnector(this.warning, this.tip, this.important, this.danger, value, this.title, this.description, this.icon, this.introduction, this.cls, this.configuration, this.examples);
    }

    public final ImmutableSinkConnector withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableSinkConnector(this.warning, this.tip, this.important, this.danger, this.note, value, this.description, this.icon, this.introduction, this.cls, this.configuration, this.examples);
    }

    public final ImmutableSinkConnector withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableSinkConnector(this.warning, this.tip, this.important, this.danger, this.note, this.title, value, this.icon, this.introduction, this.cls, this.configuration, this.examples);
    }

    public final ImmutableSinkConnector withIcon(@Nullable String value) {
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableSinkConnector(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, value, this.introduction, this.cls, this.configuration, this.examples);
    }

    public final ImmutableSinkConnector withIntroduction(@Nullable String value) {
        if (Objects.equals(this.introduction, value)) {
            return this;
        }
        return new ImmutableSinkConnector(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, value, this.cls, this.configuration, this.examples);
    }

    public final ImmutableSinkConnector withCls(Class value) {
        if (this.cls == value) {
            return this;
        }
        Class newValue = Objects.requireNonNull(value, "cls");
        return new ImmutableSinkConnector(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, newValue, this.configuration, this.examples);
    }

    public final ImmutableSinkConnector withConfiguration(Plugin.Configuration value) {
        if (this.configuration == value) {
            return this;
        }
        Plugin.Configuration newValue = Objects.requireNonNull(value, "configuration");
        return new ImmutableSinkConnector(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.cls, newValue, this.examples);
    }

    public final ImmutableSinkConnector withExamples(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSinkConnector(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.cls, this.configuration, (ImmutableList<String>)newValue);
    }

    public final ImmutableSinkConnector withExamples(Iterable<String> elements) {
        if (this.examples == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSinkConnector(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.cls, this.configuration, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSinkConnector && this.equalTo((ImmutableSinkConnector)another);
    }

    private boolean equalTo(ImmutableSinkConnector another) {
        return Objects.equals(this.warning, another.warning) && Objects.equals(this.tip, another.tip) && Objects.equals(this.important, another.important) && Objects.equals(this.danger, another.danger) && Objects.equals(this.note, another.note) && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.icon, another.icon) && Objects.equals(this.introduction, another.introduction) && this.cls.equals(another.cls) && this.configuration.equals(another.configuration) && this.examples.equals(another.examples);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.warning);
        h += (h << 5) + Objects.hashCode(this.tip);
        h += (h << 5) + Objects.hashCode(this.important);
        h += (h << 5) + Objects.hashCode(this.danger);
        h += (h << 5) + Objects.hashCode(this.note);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.icon);
        h += (h << 5) + Objects.hashCode(this.introduction);
        h += (h << 5) + this.cls.hashCode();
        h += (h << 5) + this.configuration.hashCode();
        h += (h << 5) + this.examples.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SinkConnector").omitNullValues().add("warning", (Object)this.warning).add("tip", (Object)this.tip).add("important", (Object)this.important).add("danger", (Object)this.danger).add("note", (Object)this.note).add("title", (Object)this.title).add("description", (Object)this.description).add("icon", (Object)this.icon).add("introduction", (Object)this.introduction).add("cls", (Object)this.cls).add("configuration", (Object)this.configuration).add("examples", this.examples).toString();
    }

    public static ImmutableSinkConnector copyOf(Plugin.SinkConnector instance) {
        if (instance instanceof ImmutableSinkConnector) {
            return (ImmutableSinkConnector)instance;
        }
        return ImmutableSinkConnector.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.SinkConnector", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLS = 1L;
        private static final long INIT_BIT_CONFIGURATION = 2L;
        private long initBits = 3L;
        @Nullable
        private String warning;
        @Nullable
        private String tip;
        @Nullable
        private String important;
        @Nullable
        private String danger;
        @Nullable
        private String note;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private String icon;
        @Nullable
        private String introduction;
        @Nullable
        private Class cls;
        @Nullable
        private Plugin.Configuration configuration;
        private ImmutableList.Builder<String> examples = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Notes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.Configurable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.SinkConnector instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Notes instance;
            if (object instanceof Notes) {
                String introductionValue;
                String titleValue;
                String dangerValue;
                String tipValue;
                String descriptionValue;
                String warningValue;
                String iconValue;
                String noteValue;
                instance = (Notes)object;
                String importantValue = instance.getImportant();
                if (importantValue != null) {
                    this.important(importantValue);
                }
                if ((noteValue = instance.getNote()) != null) {
                    this.note(noteValue);
                }
                if ((iconValue = instance.getIcon()) != null) {
                    this.icon(iconValue);
                }
                if ((warningValue = instance.getWarning()) != null) {
                    this.warning(warningValue);
                }
                if ((descriptionValue = instance.getDescription()) != null) {
                    this.description(descriptionValue);
                }
                if ((tipValue = instance.getTip()) != null) {
                    this.tip(tipValue);
                }
                if ((dangerValue = instance.getDanger()) != null) {
                    this.danger(dangerValue);
                }
                if ((titleValue = instance.getTitle()) != null) {
                    this.title(titleValue);
                }
                if ((introductionValue = instance.getIntroduction()) != null) {
                    this.introduction(introductionValue);
                }
            }
            if (object instanceof Plugin.Configurable) {
                instance = (Plugin.Configurable)object;
                this.addAllExamples(instance.getExamples());
                this.configuration(instance.getConfiguration());
                this.cls(instance.getCls());
            }
        }

        @CanIgnoreReturnValue
        public final Builder warning(@Nullable String warning) {
            this.warning = warning;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tip(@Nullable String tip) {
            this.tip = tip;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder important(@Nullable String important) {
            this.important = important;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder danger(@Nullable String danger) {
            this.danger = danger;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder note(@Nullable String note) {
            this.note = note;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder icon(@Nullable String icon) {
            this.icon = icon;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder introduction(@Nullable String introduction) {
            this.introduction = introduction;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cls(Class cls) {
            this.cls = Objects.requireNonNull(cls, "cls");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder configuration(Plugin.Configuration configuration) {
            this.configuration = Objects.requireNonNull(configuration, "configuration");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExamples(String element) {
            this.examples.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExamples(String ... elements) {
            this.examples.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder examples(Iterable<String> elements) {
            this.examples = ImmutableList.builder();
            return this.addAllExamples(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExamples(Iterable<String> elements) {
            this.examples.addAll(elements);
            return this;
        }

        public ImmutableSinkConnector build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSinkConnector(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.cls, this.configuration, this.examples.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("cls");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("configuration");
            }
            return "Cannot build SinkConnector, some of required attributes are not set " + attributes;
        }
    }
}

