/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.Group", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGroup
implements Plugin.Group {
    private final String name;
    private final ImmutableList<Plugin.Item> items;

    private ImmutableGroup(String name, ImmutableList<Plugin.Item> items) {
        this.name = name;
        this.items = items;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<Plugin.Item> getItems() {
        return this.items;
    }

    public final ImmutableGroup withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableGroup(newValue, this.items);
    }

    public final ImmutableGroup withItems(Plugin.Item ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableGroup(this.name, (ImmutableList<Plugin.Item>)newValue);
    }

    public final ImmutableGroup withItems(Iterable<? extends Plugin.Item> elements) {
        if (this.items == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableGroup(this.name, (ImmutableList<Plugin.Item>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroup && this.equalTo((ImmutableGroup)another);
    }

    private boolean equalTo(ImmutableGroup another) {
        return this.name.equals(another.name) && this.items.equals(another.items);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.items.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Group").omitNullValues().add("name", (Object)this.name).add("items", this.items).toString();
    }

    public static ImmutableGroup copyOf(Plugin.Group instance) {
        if (instance instanceof ImmutableGroup) {
            return (ImmutableGroup)instance;
        }
        return ImmutableGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.Group", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        private ImmutableList.Builder<Plugin.Item> items = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.Group instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.addAllItems(instance.getItems());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(Plugin.Item element) {
            this.items.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(Plugin.Item ... elements) {
            this.items.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder items(Iterable<? extends Plugin.Item> elements) {
            this.items = ImmutableList.builder();
            return this.addAllItems(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllItems(Iterable<? extends Plugin.Item> elements) {
            this.items.addAll(elements);
            return this;
        }

        public ImmutableGroup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroup(this.name, this.items.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Group, some of required attributes are not set " + attributes;
        }
    }
}

