/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates.markdown;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.jcustenborder.kafka.connect.utils.templates.TemplateHelper;
import com.github.jcustenborder.kafka.connect.utils.templates.model.Configurable;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;

public class MarkdownTemplateHelper
extends TemplateHelper {
    static void lengths(List<Integer> lengths, List<List<String>> rows) {
        if (lengths.isEmpty()) {
            for (int i = 0; i < rows.get(0).size(); ++i) {
                lengths.add(0);
            }
        }
        for (List<String> row : rows) {
            for (int i = 0; i < row.size(); ++i) {
                int previous = lengths.get(i);
                int current = Strings.isNullOrEmpty((String)row.get(i)) ? 0 : row.get(i).length();
                int value = Math.max(current, previous);
                lengths.set(i, value);
            }
        }
    }

    public String jsonExample(Configurable template) {
        ObjectNode outputNode = this.createJsonNode(template);
        StringWriter writer = new StringWriter();
        writer.write("```json");
        writer.write(10);
        try {
            this.objectMapper.writeValue((Writer)writer, (Object)outputNode);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        writer.write(10);
        writer.write("```");
        return writer.toString();
    }

    public String propertiesExample(Configurable template) {
        StringWriter writer = new StringWriter();
        writer.write("```properties");
        writer.write(10);
        Properties properties = this.createProperties(template);
        try {
            properties.store(writer, "");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        writer.write("```");
        String result = writer.toString();
        result = result.replaceAll("#.*\\n", "");
        return result.trim();
    }
}

