/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.github.jcustenborder.kafka.connect.utils.templates.markdown.MarkdownTemplateHelper;
import com.github.jcustenborder.kafka.connect.utils.templates.model.Configurable;
import com.github.jcustenborder.kafka.connect.utils.templates.model.Example;
import com.github.jcustenborder.kafka.connect.utils.templates.model.PluginData;
import com.github.jcustenborder.kafka.connect.utils.templates.model.SchemaData;
import com.github.jcustenborder.kafka.connect.utils.templates.model.SourceConnectorData;
import com.github.jcustenborder.kafka.connect.utils.templates.model.TransformationData;
import com.github.jcustenborder.kafka.connect.utils.templates.rst.RstTemplateHelper;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.RankDir;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.Label;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.Node;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.transforms.Transformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDocumentationTest {
    private static final Logger log = LoggerFactory.getLogger(BaseDocumentationTest.class);
    static Configuration configuration;
    static ClassTemplateLoader loader;
    PluginData pluginData;
    static Map<Class, PluginData> pluginTemplateLookup;
    final File outputDirectory = new File("target/docs");

    protected List<Schema> schemas() {
        return Arrays.asList(new Schema[0]);
    }

    @Deprecated
    protected abstract String[] packages();

    protected Package getPackage() {
        return this.getClass().getPackage();
    }

    @BeforeAll
    public static void loadTemplates() {
        loader = new ClassTemplateLoader(BaseDocumentationTest.class, "templates");
        configuration = new Configuration(Configuration.getVersion());
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateLoader((TemplateLoader)loader);
        configuration.setObjectWrapper((ObjectWrapper)new BeansWrapper(Configuration.getVersion()));
    }

    static <T> List<Class<? extends T>> list(Reflections reflections, Package pkg, Class<? extends T> cls) {
        List<Class<T>> classes = reflections.getSubTypesOf(cls).stream().filter(c -> c.getName().startsWith(pkg.getName())).filter(c -> Modifier.isPublic(c.getModifiers())).filter(c -> !Modifier.isAbstract(c.getModifiers())).collect(Collectors.toList());
        classes.sort(Comparator.comparing(Class::getName));
        return classes;
    }

    @BeforeEach
    public void before() throws MalformedURLException {
        log.info("before() - {}", this.getClass());
        Package pkg = this.getPackage();
        if (!this.outputDirectory.isDirectory()) {
            this.outputDirectory.mkdirs();
        }
        this.pluginData = pluginTemplateLookup.computeIfAbsent(this.getClass(), c -> {
            Reflections reflections = new Reflections((org.reflections.Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()).forPackages(new String[]{pkg.getName()}).addScanners(new Scanner[]{new ResourcesScanner()}));
            Set resources = reflections.getResources(p -> p.endsWith(".json"));
            List<Class<? extends Transformation>> transformClasses = BaseDocumentationTest.list(reflections, pkg, Transformation.class);
            List<Class<? extends SourceConnector>> sourceConnectorClasses = BaseDocumentationTest.list(reflections, pkg, SourceConnector.class);
            List<Class<? extends SinkConnector>> sinkConnectorClasses = BaseDocumentationTest.list(reflections, pkg, SinkConnector.class);
            return PluginData.from(pkg, resources, sourceConnectorClasses, sinkConnectorClasses, transformClasses);
        });
    }

    protected List<Map.Entry<String, ConfigDef.ConfigKey>> required(ConfigDef configDef) {
        ArrayList entries = new ArrayList();
        for (Map.Entry kvp : configDef.configKeys().entrySet()) {
            if (((ConfigDef.ConfigKey)kvp.getValue()).hasDefault()) continue;
            entries.add(kvp);
        }
        return ImmutableList.copyOf(entries);
    }

    DynamicTest connectorRstTest(Configurable configurable, String templateName, File parentDirectory) {
        if (!parentDirectory.isDirectory()) {
            parentDirectory.mkdirs();
        }
        return DynamicTest.dynamicTest((String)configurable.getSimpleName(), () -> {
            File graphOutputFile = new File(parentDirectory, configurable.getDiagramFileName());
            Graph g = configurable instanceof SourceConnectorData ? ((Graph)Factory.graph().graphAttr().with((Attributes)RankDir.LEFT_TO_RIGHT)).directed().with(new LinkSource[]{((Node)Factory.node((String)configurable.getSimpleName()).with((Attributes)Shape.RECTANGLE)).link(new LinkTarget[]{Factory.to((Node)((Node)Factory.node((String)"Kafka Connect").with((Attributes)Shape.RECTANGLE)).link(new LinkTarget[]{Factory.to((Node)((Node)Factory.node((String)"Kafka").with((Attributes)Shape.RECTANGLE))).with((Attributes)Label.of((String)"Writes messages to"))})).with((Attributes)Label.of((String)"Hosted by"))})}) : ((Graph)Factory.graph().graphAttr().with((Attributes)RankDir.LEFT_TO_RIGHT)).directed().with(new LinkSource[]{((Node)Factory.node((String)"Kafka").with((Attributes)Shape.RECTANGLE)).link(new LinkTarget[]{Factory.to((Node)((Node)Factory.node((String)"Kafka Connect").with((Attributes)Shape.RECTANGLE)).link(new LinkTarget[]{Factory.to((Node)((Node)Factory.node((String)configurable.getSimpleName()).with((Attributes)Shape.RECTANGLE))).with((Attributes)Label.of((String)"Writes data to"))})).with((Attributes)Label.of((String)"Pulls Data from"))})});
            Graphviz.fromGraph((Graph)g).width(350).render(Format.SVG_STANDALONE).toFile(graphOutputFile);
            File outputFile = new File(parentDirectory, configurable.getSimpleName() + ".rst");
            Template template = configuration.getTemplate(templateName);
            log.info("Writing {}", (Object)outputFile);
            try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                this.process(writer, template, configurable);
            }
            for (Example example : configurable.getExamples()) {
                example.writeJsonExample(parentDirectory);
                example.writePropertiesExample(parentDirectory);
            }
        });
    }

    DynamicTest transformRstTest(TransformationData transformationTemplate, String templateName, File parentDirectory) {
        if (!parentDirectory.isDirectory()) {
            parentDirectory.mkdirs();
        }
        String testName = transformationTemplate.getTestName();
        return DynamicTest.dynamicTest((String)testName, () -> {
            File outputFile = new File(parentDirectory, testName.toLowerCase() + ".rst");
            for (Example example : transformationTemplate.getExamples()) {
                example.writeJsonExample(parentDirectory);
                example.writePropertiesExample(parentDirectory);
            }
            Template template = configuration.getTemplate(templateName);
            log.info("Writing {}", (Object)outputFile);
            try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                this.process(writer, template, transformationTemplate);
            }
        });
    }

    @TestFactory
    public Stream<DynamicTest> rstSources() {
        File parentDirectory = new File(this.outputDirectory, "sources");
        String templateName = "rst/source.rst.ftl";
        return this.pluginData.getSourceConnectors().stream().map(connectorTemplate -> this.connectorRstTest((Configurable)connectorTemplate, "rst/source.rst.ftl", parentDirectory));
    }

    @TestFactory
    public Stream<DynamicTest> rstSinks() {
        File parentDirectory = new File(this.outputDirectory, "sinks");
        String templateName = "rst/sink.rst.ftl";
        return this.pluginData.getSinkConnectors().stream().map(connectorTemplate -> this.connectorRstTest((Configurable)connectorTemplate, "rst/sink.rst.ftl", parentDirectory));
    }

    void process(Writer writer, Template template, Object input) throws IOException, TemplateException {
        ImmutableMap variables = ImmutableMap.of((Object)"input", (Object)input, (Object)"rstHelper", (Object)new RstTemplateHelper(), (Object)"markdownHelper", (Object)new MarkdownTemplateHelper());
        template.process((Object)variables, writer);
    }

    @TestFactory
    public Stream<DynamicTest> validateExamples() {
        ArrayList examples = new ArrayList();
        this.pluginData.all().stream().forEach(p -> examples.addAll(p.getExamples()));
        return examples.stream().map(e -> DynamicTest.dynamicTest((String)e.validateTestCaseName(), () -> {
            ConfigDef configDef;
            Object instance = e.className().newInstance();
            if (instance instanceof SourceConnector) {
                configDef = ((SourceConnector)instance).config();
            } else if (instance instanceof SinkConnector) {
                configDef = ((SinkConnector)instance).config();
            } else if (instance instanceof Transformation) {
                configDef = ((Transformation)instance).config();
            } else {
                throw new UnsupportedOperationException();
            }
            int errorCount = 0;
            List values = configDef.validate(e.getConfig());
            for (ConfigValue value : values) {
                errorCount += value.errorMessages().size();
            }
            Assertions.assertEquals((int)0, (int)errorCount, () -> {
                StringBuilder builder = new StringBuilder();
                builder.append("Example validation was not successful.");
                builder.append('\n');
                for (ConfigValue value : values) {
                    for (String s : value.errorMessages()) {
                        builder.append(value.name());
                        builder.append(": ");
                        builder.append(s);
                        builder.append('\n');
                    }
                }
                return builder.toString();
            });
        }));
    }

    @TestFactory
    public Stream<DynamicTest> rstTransformations() throws IOException, TemplateException {
        if (!this.pluginData.getTransformations().isEmpty()) {
            File outputFile = new File(this.outputDirectory, "transformations.rst");
            if (!this.pluginData.getSinkConnectors().isEmpty() || !this.pluginData.getSourceConnectors().isEmpty()) {
                Template template = configuration.getTemplate("rst/transformations.rst.ftl");
                try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                    this.process(writer, template, this.pluginData);
                }
            }
        }
        File parentDirectory = new File(this.outputDirectory, "transformations");
        String templateName = "rst/transformation.rst.ftl";
        return this.pluginData.getTransformations().stream().map(connectorTemplate -> this.transformRstTest((TransformationData)connectorTemplate, "rst/transformation.rst.ftl", parentDirectory));
    }

    @TestFactory
    public Stream<DynamicTest> rstSchemas() throws IOException, TemplateException {
        File parentDirectory = new File(this.outputDirectory, "schemas");
        List<Schema> schemas = this.schemas();
        if (!schemas.isEmpty()) {
            if (!parentDirectory.exists()) {
                parentDirectory.mkdirs();
            }
            File outputFile = new File(this.outputDirectory, "schemas.rst");
            String templateName = "rst/schemas.rst.ftl";
            if (!this.pluginData.getSinkConnectors().isEmpty() || !this.pluginData.getSourceConnectors().isEmpty()) {
                Template template = configuration.getTemplate("rst/schemas.rst.ftl");
                try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                    this.process(writer, template, this.pluginData);
                }
            }
        }
        String templateName = "rst/schema.rst.ftl";
        return this.schemas().stream().filter(schema -> !Strings.isNullOrEmpty((String)schema.name())).map(schema -> DynamicTest.dynamicTest((String)String.format("%s.%s", schema.type(), schema.name()), () -> {
            StringBuilder filenameBuilder = new StringBuilder().append(schema.type().toString().toLowerCase());
            if (!Strings.isNullOrEmpty((String)schema.name())) {
                filenameBuilder.append('.').append(schema.name());
            }
            filenameBuilder.append(".rst");
            File outputFile = new File(parentDirectory, filenameBuilder.toString());
            Template template = configuration.getTemplate("rst/schema.rst.ftl");
            log.info("Writing {}", (Object)outputFile);
            try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                ImmutableMap variables = ImmutableMap.of((Object)"input", (Object)SchemaData.of(schema), (Object)"helper", (Object)new RstTemplateHelper());
                template.process((Object)variables, (Writer)writer);
            }
        }));
    }

    @Test
    public void rstConnectors() throws IOException, TemplateException {
        File outputFile = new File(this.outputDirectory, "connectors.rst");
        String templateName = "rst/connectors.rst.ftl";
        if (!this.pluginData.getSinkConnectors().isEmpty() || !this.pluginData.getSourceConnectors().isEmpty()) {
            Template template = configuration.getTemplate("rst/connectors.rst.ftl");
            try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                this.process(writer, template, this.pluginData);
            }
        }
    }

    @Test
    public void readmeRST() throws IOException, TemplateException {
        File outputFile = new File("target", "README.rst");
        Template template = configuration.getTemplate("rst/README.rst.ftl");
        log.info("Writing {}", (Object)outputFile);
        try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
            this.process(writer, template, this.pluginData);
        }
    }

    @Test
    public void readmeMD() throws IOException, TemplateException {
        String output;
        File outputFile = new File("target", "README.md");
        Template template = configuration.getTemplate("md/README.md.ftl");
        try (StringWriter writer = new StringWriter();){
            writer.write(10);
            this.process(writer, template, this.pluginData);
            output = writer.toString();
        }
        log.info("\n{}", (Object)output);
        Files.write((CharSequence)output, (File)outputFile, (Charset)Charsets.UTF_8);
    }

    static {
        pluginTemplateLookup = new LinkedHashMap<Class, PluginData>();
    }
}

