/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates.rst;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.jcustenborder.kafka.connect.utils.templates.ConnectorTemplate;
import com.github.jcustenborder.kafka.connect.utils.templates.IntentedWriter;
import com.github.jcustenborder.kafka.connect.utils.templates.Table;
import com.github.jcustenborder.kafka.connect.utils.templates.TemplateHelper;
import com.google.common.base.Joiner;
import com.opencsv.CSVWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class RstTemplateHelper
extends TemplateHelper {
    List<Integer> emphasizeLines(String content) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try (StringReader stringReader = new StringReader(content);
             LineNumberReader reader = new LineNumberReader(stringReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("< Required Configuration >")) continue;
                result.add(reader.getLineNumber());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public String jsonExample(ConnectorTemplate template) {
        String json;
        StringWriter writer = new StringWriter();
        ObjectNode outputNode = this.createJsonNode(template);
        try {
            json = this.objectMapper.writeValueAsString((Object)outputNode);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        writer.write(".. code-block:: json");
        writer.write(10);
        writer.write("    :name: connector.json");
        writer.write(10);
        List<Integer> emphasizeLines = this.emphasizeLines(json);
        if (!emphasizeLines.isEmpty()) {
            writer.write("    :emphasize-lines: ");
            writer.write(Joiner.on((char)',').join(emphasizeLines));
            writer.write(10);
        }
        writer.write(10);
        writer.write(this.indent(json));
        writer.write(10);
        return writer.toString();
    }

    String indent(String result) {
        StringWriter writer = new StringWriter();
        try (StringReader stringReader = new StringReader(result);
             BufferedReader reader = new BufferedReader(stringReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                ((Writer)writer).write("    ");
                ((Writer)writer).write(line);
                ((Writer)writer).write(10);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return ((Object)writer).toString();
    }

    public String propertiesExample(ConnectorTemplate template) {
        StringWriter writer = new StringWriter();
        Properties properties = this.createProperties(template);
        try {
            properties.store(writer, "");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        String result = writer.toString();
        result = this.indent(result);
        writer = new StringWriter();
        writer.write(".. code-block:: properties");
        writer.write(10);
        writer.write("    :name: connector.properties");
        writer.write(10);
        List<Integer> emphasizeLines = this.emphasizeLines(result);
        if (!emphasizeLines.isEmpty()) {
            writer.write("    :emphasize-lines: ");
            writer.write(Joiner.on((char)',').join(emphasizeLines));
            writer.write(10);
        }
        writer.write(10);
        writer.write(result);
        return writer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String table(Table table) {
        try (StringWriter writer = new StringWriter();){
            try (IntentedWriter printWriter = new IntentedWriter(writer);){
                printWriter.write(String.format(".. csv-table:: %s\n", table.getTitle()));
                printWriter.increase();
                printWriter.write(String.format(":header: \"%s\"\n", Joiner.on((String)"\", \"").join(table.getHeaders())));
                printWriter.write(":widths: auto\n");
                printWriter.println();
                try (CSVWriter csvWriter = new CSVWriter((Writer)printWriter);){
                    List rows = table.getRowData().stream().map(strings -> strings.toArray(new String[strings.size()])).collect(Collectors.toList());
                    csvWriter.writeAll(rows);
                }
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

