/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.jcustenborder.kafka.connect.utils.templates.ConnectorTemplate;
import com.github.jcustenborder.kafka.connect.utils.templates.SinkConnectorTemplate;
import com.github.jcustenborder.kafka.connect.utils.templates.SourceConnectorTemplate;
import com.github.jcustenborder.kafka.connect.utils.templates.TemplateConfigEntry;
import com.github.jcustenborder.kafka.connect.utils.templates.TransformationTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class TemplateHelper {
    protected static final String REQUIRED_CONFIG = "< Required Configuration >";
    protected final ObjectMapper objectMapper = new ObjectMapper();

    public TemplateHelper() {
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
    }

    protected Properties newProperties() {
        return new SortedProperties();
    }

    protected ObjectNode createJsonNode(ConnectorTemplate template) {
        ObjectNode outputNode;
        ObjectNode configNode = this.objectMapper.createObjectNode();
        if (template instanceof TransformationTemplate) {
            outputNode = configNode;
            configNode.put("name", "Connector1");
            configNode.put("connector.class", "org.apache.kafka.some.SourceConnector");
            configNode.put("transforms", "tran");
            configNode.put("transforms.tran.type", template.getClassName());
            for (TemplateConfigEntry entry : template.getConfig().getRequiredConfigs()) {
                configNode.put(String.format("transforms.tran.%s", entry.getName()), REQUIRED_CONFIG);
            }
        } else {
            configNode.put("name", template.getSimpleName() + "1");
            configNode.put("connector.class", template.getClassName());
            configNode.put("tasks.max", "1");
            if (!(template instanceof SourceConnectorTemplate) && template instanceof SinkConnectorTemplate) {
                configNode.put("topics", REQUIRED_CONFIG);
            }
            for (TemplateConfigEntry entry : template.getConfig().getRequiredConfigs()) {
                configNode.put(entry.getName(), REQUIRED_CONFIG);
            }
            outputNode = this.objectMapper.createObjectNode();
            outputNode.put("config", (JsonNode)configNode);
        }
        return outputNode;
    }

    protected Properties createProperties(ConnectorTemplate template) {
        Properties properties = this.newProperties();
        if (template instanceof TransformationTemplate) {
            properties.put("name", "Connector1");
            properties.put("connector.class", "org.apache.kafka.some.SourceConnector");
            properties.put("tasks.max", "1");
            properties.put("transforms", "tran");
            properties.put("transforms.tran.type", template.getClassName());
            for (TemplateConfigEntry entry : template.getConfig().getRequiredConfigs()) {
                properties.put(String.format("transforms.tran.%s", entry.getName()), REQUIRED_CONFIG);
            }
        } else {
            properties.put("name", template.getSimpleName() + "1");
            properties.put("connector.class", template.getClassName());
            properties.put("tasks.max", "1");
            if (!(template instanceof SourceConnectorTemplate) && template instanceof SinkConnectorTemplate) {
                properties.put("topics", REQUIRED_CONFIG);
            }
            for (TemplateConfigEntry entry : template.getConfig().getRequiredConfigs()) {
                properties.put(entry.getName(), REQUIRED_CONFIG);
            }
        }
        return properties;
    }

    class SortedProperties
    extends Properties {
        List<Object> keys = new ArrayList<Object>();

        SortedProperties() {
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(this.keys);
        }
    }
}

