/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates.rst;

import com.github.jcustenborder.kafka.connect.utils.templates.IntentedWriter;
import com.github.jcustenborder.kafka.connect.utils.templates.Table;
import com.google.common.base.Joiner;
import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;

public class RstTemplateHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String table(Table table) {
        try (StringWriter writer = new StringWriter();){
            try (IntentedWriter printWriter = new IntentedWriter(writer);){
                printWriter.write(String.format(".. csv-table:: %s\n", table.getTitle()));
                printWriter.increase();
                printWriter.write(String.format(":header: \"%s\"\n", Joiner.on((String)"\", \"").join(table.getHeaders())));
                printWriter.write(":widths: auto\n");
                printWriter.println();
                try (CSVWriter csvWriter = new CSVWriter((Writer)printWriter);){
                    List rows = table.getRowData().stream().map(strings -> strings.toArray(new String[strings.size()])).collect(Collectors.toList());
                    csvWriter.writeAll(rows);
                }
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

