/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.github.jcustenborder.kafka.connect.utils.AssertSchema;
import com.github.jcustenborder.kafka.connect.utils.AssertStruct;
import com.github.jcustenborder.kafka.connect.utils.GenericAssertions;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.jupiter.api.Assertions;

public class AssertConnectRecord {
    public static void assertValue(Object expected, Object actual, String message) {
        String prefix;
        String string = prefix = null != message ? message + ": " : "";
        if (null == expected) {
            Assertions.assertNull((Object)actual, (String)(prefix + "actual should be null."));
            return;
        }
        Assertions.assertNotNull((Object)actual, (String)(prefix + "actual should be null."));
        if (expected instanceof Struct) {
            Assertions.assertTrue((boolean)(actual instanceof Struct), (String)(prefix + "actual should be a Struct."));
            Struct expectedStruct = (Struct)expected;
            Struct actualStruct = (Struct)actual;
            AssertStruct.assertStruct(expectedStruct, actualStruct, message);
        } else if (expected instanceof Map) {
            Assertions.assertTrue((boolean)(actual instanceof Map), (String)(prefix + "actual should be a Map."));
            Map expectedMap = (Map)expected;
            Map actualMap = (Map)actual;
            GenericAssertions.assertMap(expectedMap, actualMap, message);
        } else {
            Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
        }
    }

    public static void assertRecord(ConnectRecord expected, ConnectRecord actual) {
        AssertConnectRecord.assertRecord(expected, actual, null);
    }

    public static void assertRecord(ConnectRecord expected, ConnectRecord actual, String message) {
        String prefix;
        String string = prefix = null != message ? message + ": " : "";
        if (null == expected) {
            Assertions.assertNull((Object)actual, (String)(prefix + "actual should be null."));
            return;
        }
        Assertions.assertNotNull((Object)actual, (String)(prefix + "actual should not be null."));
        Assertions.assertEquals((Object)expected.kafkaPartition(), (Object)actual.kafkaPartition(), (String)(prefix + "kafkaPartition() does not match."));
        Assertions.assertEquals((Object)expected.topic(), (Object)actual.topic(), (String)(prefix + "topic() does not match."));
        Assertions.assertEquals((Object)expected.timestamp(), (Object)actual.timestamp(), (String)(prefix + "timestamp() does not match."));
        AssertSchema.assertSchema(expected.keySchema(), actual.keySchema(), prefix + "keySchema() does not match");
        AssertConnectRecord.assertValue(expected.key(), actual.key(), prefix + "key() does not match.");
        AssertSchema.assertSchema(expected.valueSchema(), actual.valueSchema(), prefix + "valueSchema() does not match");
        AssertConnectRecord.assertValue(expected.value(), actual.value(), prefix + "value() does not match.");
    }

    public static void assertSourceRecord(SourceRecord expected, SourceRecord actual) {
        AssertConnectRecord.assertSourceRecord(expected, actual, null);
    }

    public static void assertSourceRecord(SourceRecord expected, SourceRecord actual, String message) {
        String prefix = null != message ? message + ": " : "";
        AssertConnectRecord.assertRecord((ConnectRecord)expected, (ConnectRecord)actual, message);
        GenericAssertions.assertMap(expected.sourceOffset(), actual.sourceOffset(), prefix + "sourceOffset() does not match.");
        GenericAssertions.assertMap(expected.sourcePartition(), actual.sourcePartition(), prefix + "sourcePartition() does not match.");
    }
}

