/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.github.jcustenborder.kafka.connect.utils.MarkdownFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDocumentationTest {
    private static final Logger log = LoggerFactory.getLogger(BaseDocumentationTest.class);
    Reflections reflections;

    protected abstract String[] packages();

    @BeforeEach
    public void before() throws MalformedURLException {
        log.info("before() - Configuring reflections to use package '{}'", (Object[])this.packages());
        this.reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()).forPackages(this.packages()));
    }

    @Test
    public void markdown() throws IOException, IllegalAccessException, InstantiationException {
        Set connectorClasses = this.reflections.getSubTypesOf(Connector.class);
        ArrayList<Class> sorted = new ArrayList<Class>(connectorClasses);
        sorted.sort(Comparator.comparing(Class::getName));
        Assertions.assertFalse((boolean)sorted.isEmpty(), (String)"No connector classes were found.");
        try (StringWriter stringWriter = new StringWriter();){
            try (PrintWriter writer = new PrintWriter(stringWriter);){
                writer.println();
                writer.println("# Configuration");
                writer.println();
                for (Class connectorClass : sorted) {
                    if (Modifier.isAbstract(connectorClass.getModifiers())) {
                        log.trace("Skipping {} because it's abstract.", (Object)connectorClass.getName());
                        continue;
                    }
                    writer.printf("## %s", connectorClass.getSimpleName());
                    writer.println();
                    writer.println();
                    Connector connector = (Connector)connectorClass.newInstance();
                    ConfigDef configDef = connector.config();
                    writer.println("```properties");
                    writer.println("name=connector1");
                    writer.println("tasks.max=1");
                    writer.printf("connector.class=%s", connectorClass.getName());
                    writer.println();
                    writer.println();
                    writer.println("# Set these required values");
                    for (Map.Entry kvp : configDef.configKeys().entrySet()) {
                        writer.printf("%s=", kvp.getKey());
                        writer.println();
                    }
                    writer.println("```");
                    writer.println();
                    writer.println(MarkdownFormatter.toMarkdown(configDef));
                }
            }
            log.info("{}", (Object)stringWriter);
        }
    }
}

