/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.webdav;

import android.util.Log;
import com.fsck.k9.mail.K9MailLib;
import com.fsck.k9.mail.helper.UrlEncodingHelper;
import com.fsck.k9.mail.store.webdav.WebDavUtils;
import java.net.URI;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;

public class HttpGeneric
extends HttpEntityEnclosingRequestBase {
    public String METHOD_NAME = "POST";

    public HttpGeneric() {
    }

    public HttpGeneric(URI uri) {
        this.setURI(uri);
    }

    public HttpGeneric(String uri) {
        if (K9MailLib.isDebug()) {
            Log.v((String)"k9", (String)("Starting uri = '" + uri + "'"));
        }
        String[] urlParts = uri.split("/");
        int length = urlParts.length;
        String end = urlParts[length - 1];
        String url = "";
        try {
            if (length > 3) {
                end = UrlEncodingHelper.decodeUtf8(end);
                end = UrlEncodingHelper.encodeUtf8(end);
                end = end.replaceAll("\\+", "%20");
            }
        }
        catch (IllegalArgumentException iae) {
            Log.e((String)"k9", (String)("IllegalArgumentException caught in HttpGeneric(String uri): " + iae + "\nTrace: " + WebDavUtils.processException(iae)));
        }
        for (int i = 0; i < length - 1; ++i) {
            url = i != 0 ? url + "/" + urlParts[i] : urlParts[i];
        }
        if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_WEBDAV) {
            Log.v((String)"k9", (String)("url = '" + url + "' length = " + url.length() + ", end = '" + end + "' length = " + end.length()));
        }
        url = url + "/" + end;
        Log.i((String)"k9", (String)("url = " + url));
        this.setURI(URI.create(url));
    }

    public String getMethod() {
        return this.METHOD_NAME;
    }

    public void setMethod(String method) {
        if (method != null) {
            this.METHOD_NAME = method;
        }
    }
}

