/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.webdav;

import android.util.Log;
import com.fsck.k9.mail.store.webdav.ParsedMessageEnvelope;
import com.fsck.k9.mail.store.webdav.WebDavConstants;
import com.fsck.k9.mail.store.webdav.WebDavUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

class DataSet {
    private Map<String, Map<String, String>> mData = new HashMap<String, Map<String, String>>();
    private StringBuilder mUid = new StringBuilder();
    private Map<String, String> mTempData = new HashMap<String, String>();

    DataSet() {
    }

    public void addValue(String value, String tagName) {
        if (tagName.equals("uid")) {
            this.mUid.append(value);
        }
        if (this.mTempData.containsKey(tagName)) {
            this.mTempData.put(tagName, this.mTempData.get(tagName) + value);
        } else {
            this.mTempData.put(tagName, value);
        }
    }

    public void finish() {
        String uid = this.mUid.toString();
        if (this.mTempData != null) {
            this.mData.put(uid, this.mTempData);
        } else if (this.mTempData != null) {
            // empty if block
        }
        this.mUid = new StringBuilder();
        this.mTempData = new HashMap<String, String>();
    }

    public Map<String, String> getSpecialFolderToUrl() {
        Iterator<Map<String, String>> iterator = this.mData.values().iterator();
        if (iterator.hasNext()) {
            Map<String, String> folderMap = iterator.next();
            return folderMap;
        }
        return new HashMap<String, String>();
    }

    public Map<String, String> getUidToUrl() {
        HashMap<String, String> uidToUrl = new HashMap<String, String>();
        for (String uid : this.mData.keySet()) {
            Map<String, String> data = this.mData.get(uid);
            String value = data.get("href");
            if (value == null || value.equals("")) continue;
            uidToUrl.put(uid, value);
        }
        return uidToUrl;
    }

    public Map<String, Boolean> getUidToRead() {
        HashMap<String, Boolean> uidToRead = new HashMap<String, Boolean>();
        for (String uid : this.mData.keySet()) {
            Map<String, String> data = this.mData.get(uid);
            String readStatus = data.get("read");
            if (readStatus != null && !readStatus.equals("")) {
                Boolean value = !readStatus.equals("0");
                uidToRead.put(uid, value);
                continue;
            }
            uidToRead.put(uid, false);
        }
        return uidToRead;
    }

    public String[] getHrefs() {
        ArrayList<String> hrefs = new ArrayList<String>();
        for (String uid : this.mData.keySet()) {
            Map<String, String> data = this.mData.get(uid);
            String href = data.get("href");
            hrefs.add(href);
        }
        return hrefs.toArray(WebDavConstants.EMPTY_STRING_ARRAY);
    }

    public String[] getUids() {
        ArrayList<String> uids = new ArrayList<String>();
        for (String uid : this.mData.keySet()) {
            uids.add(uid);
        }
        return uids.toArray(WebDavConstants.EMPTY_STRING_ARRAY);
    }

    public int getMessageCount() {
        int messageCount = 0;
        for (String uid : this.mData.keySet()) {
            Map<String, String> data = this.mData.get(uid);
            String count = data.get("visiblecount");
            if (count == null || count.equals("")) continue;
            messageCount = Integer.parseInt(count);
        }
        return messageCount;
    }

    public Map<String, ParsedMessageEnvelope> getMessageEnvelopes() {
        HashMap<String, ParsedMessageEnvelope> envelopes = new HashMap<String, ParsedMessageEnvelope>();
        for (String uid : this.mData.keySet()) {
            ParsedMessageEnvelope envelope = new ParsedMessageEnvelope();
            Map<String, String> data = this.mData.get(uid);
            if (data != null) {
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    String header = entry.getKey();
                    if (header.equals("read")) {
                        String read = entry.getValue();
                        boolean readStatus = !read.equals("0");
                        envelope.setReadStatus(readStatus);
                        continue;
                    }
                    if (header.equals("date")) {
                        String date = entry.getValue();
                        date = date.substring(0, date.length() - 1);
                        SimpleDateFormat dfInput = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US);
                        SimpleDateFormat dfOutput = new SimpleDateFormat("EEE, d MMM yy HH:mm:ss Z", Locale.US);
                        String tempDate = "";
                        try {
                            Date parsedDate = dfInput.parse(date);
                            tempDate = dfOutput.format(parsedDate);
                        }
                        catch (ParseException pe) {
                            Log.e((String)"k9", (String)("Error parsing date: " + pe + "\nTrace: " + WebDavUtils.processException(pe)));
                        }
                        envelope.addHeader(header, tempDate);
                        continue;
                    }
                    envelope.addHeader(header, entry.getValue());
                }
            }
            envelopes.put(uid, envelope);
        }
        return envelopes;
    }
}

