/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import android.util.Log;
import com.fsck.k9.mail.store.imap.ImapResponse;
import java.util.ArrayList;
import java.util.List;

class ImapUtility {
    ImapUtility() {
    }

    public static List<String> getImapSequenceValues(String set) {
        ArrayList<String> list = new ArrayList<String>();
        if (set != null) {
            String[] setItems;
            for (String item : setItems = set.split(",")) {
                if (item.indexOf(58) == -1) {
                    if (!ImapUtility.isNumberValid(item)) continue;
                    list.add(item);
                    continue;
                }
                list.addAll(ImapUtility.getImapRangeValues(item));
            }
        }
        return list;
    }

    public static List<String> getImapRangeValues(String range) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            int colonPos;
            if (range != null && (colonPos = range.indexOf(58)) > 0) {
                long first = Long.parseLong(range.substring(0, colonPos));
                long second = Long.parseLong(range.substring(colonPos + 1));
                if (ImapUtility.is32bitValue(first) && ImapUtility.is32bitValue(second)) {
                    if (first < second) {
                        for (long i = first; i <= second; ++i) {
                            list.add(Long.toString(i));
                        }
                    } else {
                        for (long i = first; i >= second; --i) {
                            list.add(Long.toString(i));
                        }
                    }
                } else {
                    Log.d((String)"k9", (String)("Invalid range: " + range));
                }
            }
        }
        catch (NumberFormatException e) {
            Log.d((String)"k9", (String)("Invalid range value: " + range), (Throwable)e);
        }
        return list;
    }

    private static boolean isNumberValid(String number) {
        try {
            long value = Long.parseLong(number);
            if (ImapUtility.is32bitValue(value)) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Log.d((String)"k9", (String)("Invalid UID value: " + number));
        return false;
    }

    private static boolean is32bitValue(long value) {
        return (value & 0xFFFFFFFF00000000L) == 0L;
    }

    public static String encodeString(String str) {
        return "\"" + str.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
    }

    public static ImapResponse getLastResponse(List<ImapResponse> responses) {
        int lastIndex = responses.size() - 1;
        return responses.get(lastIndex);
    }
}

