/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import com.fsck.k9.mail.AuthType;
import com.fsck.k9.mail.ServerSettings;
import com.fsck.k9.mail.helper.UrlEncodingHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

class ImapStoreUriCreator {
    ImapStoreUriCreator() {
    }

    public static String create(ServerSettings server) {
        String scheme;
        String userEnc = UrlEncodingHelper.encodeUtf8(server.username);
        String passwordEnc = server.password != null ? UrlEncodingHelper.encodeUtf8(server.password) : "";
        String clientCertificateAliasEnc = server.clientCertificateAlias != null ? UrlEncodingHelper.encodeUtf8(server.clientCertificateAlias) : "";
        switch (server.connectionSecurity) {
            case SSL_TLS_REQUIRED: {
                scheme = "imap+ssl+";
                break;
            }
            case STARTTLS_REQUIRED: {
                scheme = "imap+tls+";
                break;
            }
            default: {
                scheme = "imap";
            }
        }
        AuthType authType = server.authenticationType;
        String userInfo = authType == AuthType.EXTERNAL ? authType.name() + ":" + userEnc + ":" + clientCertificateAliasEnc : authType.name() + ":" + userEnc + ":" + passwordEnc;
        try {
            String path;
            Map<String, String> extra = server.getExtra();
            if (extra != null) {
                boolean autoDetectNamespace = Boolean.TRUE.toString().equals(extra.get("autoDetectNamespace"));
                String pathPrefix = autoDetectNamespace ? null : extra.get("pathPrefix");
                path = "/" + (autoDetectNamespace ? "1" : "0") + "|" + (pathPrefix == null ? "" : pathPrefix);
            } else {
                path = "/1|";
            }
            return new URI(scheme, userInfo, server.host, server.port, path, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Can't create ImapStore URI", e);
        }
    }
}

