/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import android.util.Log;
import com.fsck.k9.mail.K9MailLib;
import com.fsck.k9.mail.filter.FixedLengthInputStream;
import com.fsck.k9.mail.filter.PeekableInputStream;
import com.fsck.k9.mail.store.imap.AlertResponse;
import com.fsck.k9.mail.store.imap.ImapList;
import com.fsck.k9.mail.store.imap.ImapResponse;
import com.fsck.k9.mail.store.imap.ImapResponseCallback;
import com.fsck.k9.mail.store.imap.NegativeImapResponseException;
import com.fsck.k9.mail.store.imap.UntaggedHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ImapResponseParser {
    private PeekableInputStream inputStream;
    private ImapResponse response;
    private Exception exception;

    public ImapResponseParser(PeekableInputStream in) {
        this.inputStream = in;
    }

    public ImapResponse readResponse() throws IOException {
        return this.readResponse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImapResponse readResponse(ImapResponseCallback callback) throws IOException {
        try {
            int peek = this.inputStream.peek();
            if (peek == 43) {
                this.readContinuationRequest(callback);
            } else if (peek == 42) {
                this.readUntaggedResponse(callback);
            } else {
                this.readTaggedResponse(callback);
            }
            if (this.exception != null) {
                throw new RuntimeException("readResponse(): Exception in callback method", this.exception);
            }
            ImapResponse imapResponse = this.response;
            return imapResponse;
        }
        finally {
            this.response = null;
            this.exception = null;
        }
    }

    private void readContinuationRequest(ImapResponseCallback callback) throws IOException {
        this.parseCommandContinuationRequest();
        this.response = ImapResponse.newContinuationRequest(callback);
        this.skipIfSpace();
        String rest = this.readStringUntilEndOfLine();
        this.response.add(rest);
    }

    private void readUntaggedResponse(ImapResponseCallback callback) throws IOException {
        this.parseUntaggedResponse();
        this.response = ImapResponse.newUntaggedResponse(callback);
        this.readTokens(this.response);
    }

    private void readTaggedResponse(ImapResponseCallback callback) throws IOException {
        String tag = this.parseTaggedResponse();
        this.response = ImapResponse.newTaggedResponse(callback, tag);
        this.readTokens(this.response);
    }

    List<ImapResponse> readStatusResponse(String tag, String commandToLog, String logId, UntaggedHandler untaggedHandler) throws IOException, NegativeImapResponseException {
        ImapResponse response;
        ArrayList<ImapResponse> responses = new ArrayList<ImapResponse>();
        do {
            response = this.readResponse();
            if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_IMAP) {
                Log.v((String)"k9", (String)(logId + "<<<" + response));
            }
            if (response.getTag() != null && !response.getTag().equalsIgnoreCase(tag)) {
                Log.w((String)"k9", (String)("After sending tag " + tag + ", got tag response from previous command " + response + " for " + logId));
                Iterator responseIterator = responses.iterator();
                while (responseIterator.hasNext()) {
                    ImapResponse delResponse = (ImapResponse)responseIterator.next();
                    if (delResponse.getTag() == null && delResponse.size() >= 2 && (ImapResponseParser.equalsIgnoreCase(delResponse.get(1), "EXISTS") || ImapResponseParser.equalsIgnoreCase(delResponse.get(1), "EXPUNGE"))) continue;
                    responseIterator.remove();
                }
                response = null;
                continue;
            }
            if (untaggedHandler != null) {
                untaggedHandler.handleAsyncUntaggedResponse(response);
            }
            responses.add(response);
        } while (response == null || response.getTag() == null);
        if (response.size() < 1 || !ImapResponseParser.equalsIgnoreCase(response.get(0), "OK")) {
            String message = "Command: " + commandToLog + "; response: " + response.toString();
            String alertText = AlertResponse.getAlertText(response);
            throw new NegativeImapResponseException(message, alertText);
        }
        return responses;
    }

    private void readTokens(ImapResponse response) throws IOException {
        response.clear();
        Object firstToken = this.readToken(response);
        this.checkTokenIsString(firstToken);
        String symbol = (String)firstToken;
        response.add(symbol);
        if (this.isStatusResponse(symbol)) {
            this.parseResponseText(response);
        } else if (ImapResponseParser.equalsIgnoreCase(symbol, "LIST") || ImapResponseParser.equalsIgnoreCase(symbol, "LSUB")) {
            this.parseListResponse(response);
        } else {
            Object token;
            while ((token = this.readToken(response)) != null) {
                if (token instanceof ImapList) continue;
                response.add(token);
            }
        }
    }

    private void parseResponseText(ImapResponse parent) throws IOException {
        String rest;
        this.skipIfSpace();
        int next = this.inputStream.peek();
        if (next == 91) {
            this.parseList(parent, '[', ']');
            this.skipIfSpace();
        }
        if ((rest = this.readStringUntilEndOfLine()) != null && !rest.isEmpty()) {
            parent.add(rest);
        }
    }

    private void parseListResponse(ImapResponse response) throws IOException {
        this.expect(' ');
        this.parseList(response, '(', ')');
        this.expect(' ');
        String delimiter = this.parseQuoted();
        response.add(delimiter);
        this.expect(' ');
        String name = this.parseString();
        response.add(name);
        this.expect('\r');
        this.expect('\n');
    }

    private void skipIfSpace() throws IOException {
        if (this.inputStream.peek() == 32) {
            this.expect(' ');
        }
    }

    private Object readToken(ImapResponse response) throws IOException {
        Object token;
        while ((token = this.parseToken(response)) != null && (token.equals(")") || token.equals("]"))) {
        }
        return token;
    }

    private Object parseToken(ImapList parent) throws IOException {
        while (true) {
            int ch;
            if ((ch = this.inputStream.peek()) == 40) {
                return this.parseList(parent, '(', ')');
            }
            if (ch == 91) {
                return this.parseList(parent, '[', ']');
            }
            if (ch == 41) {
                this.expect(')');
                return ")";
            }
            if (ch == 93) {
                this.expect(']');
                return "]";
            }
            if (ch == 34) {
                return this.parseQuoted();
            }
            if (ch == 123) {
                return this.parseLiteral();
            }
            if (ch == 32) {
                this.expect(' ');
                continue;
            }
            if (ch == 13) {
                this.expect('\r');
                this.expect('\n');
                return null;
            }
            if (ch == 10) {
                this.expect('\n');
                return null;
            }
            if (ch != 9) break;
            this.expect('\t');
        }
        return this.parseBareString(true);
    }

    private String parseString() throws IOException {
        int ch = this.inputStream.peek();
        if (ch == 34) {
            return this.parseQuoted();
        }
        if (ch == 123) {
            return (String)this.parseLiteral();
        }
        return this.parseBareString(false);
    }

    private boolean parseCommandContinuationRequest() throws IOException {
        this.expect('+');
        return true;
    }

    private void parseUntaggedResponse() throws IOException {
        this.expect('*');
        this.expect(' ');
    }

    private String parseTaggedResponse() throws IOException {
        return this.readStringUntil(' ');
    }

    private ImapList parseList(ImapList parent, char start, char end) throws IOException {
        this.expect(start);
        ImapList list = new ImapList();
        parent.add(list);
        String endString = String.valueOf(end);
        while (true) {
            Object token;
            if ((token = this.parseToken(list)) == null) {
                return null;
            }
            if (token.equals(endString)) break;
            if (token instanceof ImapList) continue;
            list.add(token);
        }
        return list;
    }

    private String parseBareString(boolean allowBrackets) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int ch;
            if ((ch = this.inputStream.peek()) == -1) {
                throw new IOException("parseBareString(): end of stream reached");
            }
            if (ch == 40 || ch == 41 || allowBrackets && (ch == 91 || ch == 93) || ch == 123 || ch == 32 || ch == 34 || ch >= 0 && ch <= 31 || ch == 127) {
                if (sb.length() == 0) {
                    throw new IOException(String.format("parseBareString(): (%04x %c)", ch, ch));
                }
                return sb.toString();
            }
            sb.append((char)this.inputStream.read());
        }
    }

    private Object parseLiteral() throws IOException {
        int count;
        this.expect('{');
        int size = Integer.parseInt(this.readStringUntil('}'));
        this.expect('\r');
        this.expect('\n');
        if (size == 0) {
            return "";
        }
        if (this.response.getCallback() != null) {
            FixedLengthInputStream fixed = new FixedLengthInputStream(this.inputStream, size);
            Object result = null;
            try {
                result = this.response.getCallback().foundLiteral(this.response, fixed);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                this.exception = e;
            }
            int available = fixed.available();
            if (available > 0 && available != size) {
                while (fixed.available() > 0) {
                    fixed.skip(fixed.available());
                }
            }
            if (result != null) {
                return result;
            }
        }
        byte[] data = new byte[size];
        for (int read = 0; read != size; read += count) {
            count = this.inputStream.read(data, read, size - read);
            if (count != -1) continue;
            throw new IOException("parseLiteral(): end of stream reached");
        }
        return new String(data, "US-ASCII");
    }

    private String parseQuoted() throws IOException {
        int ch;
        this.expect('\"');
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        while ((ch = this.inputStream.read()) != -1) {
            if (!escape && ch == 92) {
                escape = true;
                continue;
            }
            if (!escape && ch == 34) {
                return sb.toString();
            }
            sb.append((char)ch);
            escape = false;
        }
        throw new IOException("parseQuoted(): end of stream reached");
    }

    private String readStringUntil(char end) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = this.inputStream.read()) != -1) {
            if (ch == end) {
                return sb.toString();
            }
            sb.append((char)ch);
        }
        throw new IOException("readStringUntil(): end of stream reached");
    }

    private String readStringUntilEndOfLine() throws IOException {
        String rest = this.readStringUntil('\r');
        this.expect('\n');
        return rest;
    }

    private void expect(char expected) throws IOException {
        int readByte = this.inputStream.read();
        if (readByte != expected) {
            throw new IOException(String.format("Expected %04x (%c) but got %04x (%c)", expected, Character.valueOf(expected), readByte, Character.valueOf((char)readByte)));
        }
    }

    private boolean isStatusResponse(String symbol) {
        return symbol.equalsIgnoreCase("OK") || symbol.equalsIgnoreCase("NO") || symbol.equalsIgnoreCase("BAD") || symbol.equalsIgnoreCase("PREAUTH") || symbol.equalsIgnoreCase("BYE");
    }

    static boolean equalsIgnoreCase(Object token, String symbol) {
        if (token == null || !(token instanceof String)) {
            return false;
        }
        return symbol.equalsIgnoreCase((String)token);
    }

    private void checkTokenIsString(Object token) throws IOException {
        if (!(token instanceof String)) {
            throw new IOException("Unexpected non-string token: " + token);
        }
    }
}

